//=============================================================================
// HXAugMuscle.
//
// Do I really need AugMuscleClassLevel for non net owner clients? --han
//=============================================================================
class HXAugMuscle extends HXAugmentation;

// ----------------------------------------------------------------------------
// SpecialActivation()
//
// Called by Activate to check whether this aug has special requirements
// other than beeing present (Health below 100, new drone ready, etc.).
//
// Can return false to cancel activation.
// ----------------------------------------------------------------------------

function bool SpecialActivation()
{
	// Needs to be replicated for decoration bumping.
	HXPlayerPawn(Player).AugMuscleClassLevel = CurrentLevel;
}

// ----------------------------------------------------------------------------
// Deactivate()
// ----------------------------------------------------------------------------

function Deactivate()
{
	Super.Deactivate();

	// Needs to be replicated for decoration bumping.
	HXPlayerPawn(Player).AugMuscleClassLevel = -1;

	// check to see if the player is carrying something too heavy for him
	if (Player.CarriedDecoration != None)
		if (!Player.CanBeLifted(Player.CarriedDecoration))
			Player.DropDecoration();
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	EnergyRate=20.0
	Icon=AugIconMuscle
	SmallIcon=AugIconMuscle_Small
	AugmentationName="Microfibral Muscle"
	Description="Muscle strength is amplified with ionic polymeric gel myofibrils that allow the agent to push and lift extraordinarily heavy objects.|n|nTECH ONE: Strength is increased slightly.|n|nTECH TWO: Strength is increased moderately.|n|nTECH THREE: Strength is increased significantly.|n|nTECH FOUR: An agent is inhumanly strong."
	LevelValues(0)=1.25
	LevelValues(1)=1.50
	LevelValues(2)=1.75
	LevelValues(3)=2.00
	AugmentationLocation=LOC_Arm
}
