//=============================================================================
// HXAugRadarTrans.
//=============================================================================
class HXAugRadarTrans extends HXAugmentation;

// ----------------------------------------------------------------------------
// GetEnergyRate()
// ----------------------------------------------------------------------------

simulated function float GetEnergyRate()
{
	return EnergyRate*LevelValues[CurrentLevel];
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	EnergyRate=300.0
	Icon=AugIconRadarTrans
	SmallIcon=AugIconRadarTrans_Small
	AugmentationName="Radar Transparency"
	Description="Radar-absorbent resin augments epithelial proteins; microprojection units distort agent's visual signature. Provides highly effective concealment from automated detection systems -- bots, cameras, turrets.|n|nTECH ONE: Power drain is normal.|n|nTECH TWO: Power drain is reduced slightly.|n|nTECH THREE: Power drain is reduced moderately.|n|nTECH FOUR: Power drain is reduced significantly."
	LevelValues(0)=1.00
	LevelValues(1)=0.83
	LevelValues(2)=0.66
	LevelValues(3)=0.50
	AugmentationLocation=LOC_Subdermal
}
