//=============================================================================
// HXAugmentation.
//
// The integration sucks. There should be a system querying the aug, skill
// and inventory chain for those alterations.
//=============================================================================
class HXAugmentation extends Augmentation;

/*
var() bool bAutomatic;
var bool bAlwaysActive;
var travel bool bBoosted;
var bool bUsingMedbot;
var travel bool bHasIt;// does the player have it?
var travel bool bIsActive; // is it actually turned on?
*/
var bool bActivateWithAll;   // Whether this Aug is affected by ActivateAll.
var bool bDeactivateWithAll; // Whether this Aug is affected by DeactivateAll.
/*
var() float EnergyRate;			
var travel int CurrentLevel;
var int MaxLevel;
var texture icon;
var int IconWidth;
var int IconHeight;
var texture smallIcon;
var travel int HotKeyNum;
var travel Augmentation next;
var localized String EnergyRateLabel;
var localized string OccupiesSlotLabel;
var localized string AugLocsText[7];
var() localized string AugActivated;
var() localized string AugDeactivated;
*/
var localized string AugAlwaysActive;
/*
var() localized string AugmentationName;
var() localized string Description;
//var() localized string MPInfo;
var() localized string AugAlreadyHave;
var() localized string AugNowHave;
var() localized string AugNowHaveAtLevel;
var() localized string AlwaysActiveLabel;
var() localized String CanUpgradeLabel;
var() localized String CurrentLevelLabel;
var() localized String MaximumLabel;

// which player am I attached to?
var DeusExPlayer Player;

var() float LevelValues[4];

var() enum EAugmentationLocation
{
	LOC_Cranial,
	LOC_Eye,
	LOC_Torso,
	LOC_Arm,
	LOC_Leg,
	LOC_Subdermal,
	LOC_Default
} AugmentationLocation;

// DEUS_EX AMSD In multiplayer, we have strict aug pairs, no two augs can have the
// same MPConflict slot value.
var() int MPConflictSlot;

var() sound ActivateSound;
var() sound DeactivateSound;
var() sound LoopSound;
*/

// ----------------------------------------------------------------------------
// Network replication.
// ----------------------------------------------------------------------------

/*
replication
{
    //variables server to client
    reliable if ((Role == ROLE_Authority) && (bNetOwner))
        bHasIt, bIsActive, CurrentLevel, next, HotKeyNum, Player;

    //functions client to server
    reliable if (Role < ROLE_Authority)
        Activate, Deactivate, IncLevel;

}
*/

// ----------------------------------------------------------------------------
// state Active 
//
// Each augmentation should have its own version of this which actually
// implements the effects of having the augmentation on.
// ----------------------------------------------------------------------------

state Active
{

Begin:
}

// ----------------------------------------------------------------------------
// state Inactive
//
// Don't do anything in this state.
// ----------------------------------------------------------------------------

auto state Inactive
{
}

// ----------------------------------------------------------------------------
// SpecialActivation()
//
// Called by Activate to check whether this aug has special requirements
// other than beeing present (Health below 100, new drone ready, etc.).
//
// Can return false to cancel activation.
// ----------------------------------------------------------------------------

function bool SpecialActivation()
{
	return true;
}

// ----------------------------------------------------------------------------
// Activate()
// ----------------------------------------------------------------------------

function Activate()
{
	// Can't do anything if we don't have it.
	if ( !bHasIt )
		return;

	// If the 'bAlwaysActive' flag is set, this aug can't be activated.
	// I added this, and hope that this won't break.
	if ( bAlwaysActive )
	{
		// This should ideally never be reached.
		Player.ClientMessage( Sprintf(AugAlwaysActive,AugmentationName), 'StatusLine' );
		return;
	}

	if ( IsInState('Inactive') )
	{
		if ( !SpecialActivation() )
			return;

		Player.ClientMessage( Sprintf(AugActivated,AugmentationName), 'StatusLine' );
		if ( ActivateSound!=None )
			Player.PlaySound( ActivateSound, SLOT_None );

		// this block needs to be before bIsActive is set to True, otherwise
		// NumAugsActive counts incorrectly and the sound won't work

		if (Player.AugmentationSystem.NumAugsActive() == 0)
			Player.AmbientSound = LoopSound;

		bIsActive = true;

		if ( Player.bHUDShowAllAugs )
			Player.UpdateAugmentationDisplayStatus( Self );
		else
			Player.AddAugmentationDisplay( Self );

		GotoState('Active');
	}
	// ClientMessage else?
}

// ----------------------------------------------------------------------------
// Deactivate()
// ----------------------------------------------------------------------------

function Deactivate()
{
	// Can't do anything if we don't have it.
	if ( !bHasIt )
		return;

	// If the 'bAlwaysActive' flag is set, this aug can't be deactivated.
	if ( bAlwaysActive )
	{
		// This should ideally never be reached.
		Player.ClientMessage( Sprintf(AugAlwaysActive,AugmentationName), 'StatusLine' );
		return;
	}

	if ( IsInState('Active') )
	{
		Player.ClientMessage( Sprintf(AugDeactivated,AugmentationName), 'StatusLine' );
		if ( DeactivateSound!=None )
			Player.PlaySound( DeactivateSound, SLOT_None );

		bIsActive = false;

		if ( Player.bHUDShowAllAugs )
			Player.UpdateAugmentationDisplayStatus( Self );
		else
			Player.RemoveAugmentationDisplay( Self );

		if ( Player.AugmentationSystem.NumAugsActive()==0 )
			Player.AmbientSound = None;

		GotoState('Inactive');
	}
	// ClientMessage else?
}

// ----------------------------------------------------------------------------
// IncLevel()
// ----------------------------------------------------------------------------

function bool IncLevel()
{
	if ( !CanBeUpgraded() )
	{
		Player.ClientMessage( Sprintf(AugAlreadyHave,AugmentationName), 'StatusLine' );
		return false;
	}

	if ( bIsActive )
		Deactivate();

	CurrentLevel++;
				
	Player.ClientMessage( Sprintf(AugNowHave,AugmentationName,CurrentLevel+1), 'StatusLine' );
}

// ----------------------------------------------------------------------------
// CanBeUpgraded()
//
// Checks to see if the player has an Upgrade cannister for this 
// augmentation, as well as making sure the augmentation isn't already
// at full strength.
// ----------------------------------------------------------------------------

simulated function bool CanBeUpgraded()
{
	local bool bCanUpgrade;
	local Augmentation anAug;
	local HXAugmentationUpgradeCannister augCan;

	bCanUpgrade = False;

	// Check to see if this augmentation is already at 
	// the maximum level
	if ( CurrentLevel < MaxLevel )
	{
		// Now check to see if the player has a cannister that can 
		// be used to upgrade this Augmentation
		augCan = HXAugmentationUpgradeCannister(player.FindInventoryType(Class'HXAugmentationUpgradeCannister'));

		if (augCan != None)
			bCanUpgrade = True;
	}

	return bCanUpgrade;
}

// ----------------------------------------------------------------------------
// UsingMedBot()
// ----------------------------------------------------------------------------

function UsingMedBot( bool bNewUsingMedbot )
{
	bUsingMedbot = bNewUsingMedbot;
}

// ----------------------------------------------------------------------------
// UpdateInfo()
// ----------------------------------------------------------------------------

simulated function bool UpdateInfo(Object winObject)
{
	local HXPersonaInfoWindow winInfo;
	local String strOut;

	winInfo = HXPersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	winInfo.Clear();
	winInfo.SetTitle(AugmentationName);

	if (bUsingMedbot)
	{
		winInfo.SetText(winInfo.Sprintf(OccupiesSlotLabel, AugLocsText[AugmentationLocation]));
		winInfo.AppendText(winInfo.CR() $ winInfo.CR() $ Description);
	}
	else
	{
		winInfo.SetText(Description);
	}

	//Log( Sprintf(EnergyRateLabel, Int(EnergyRate)) );
	//Log( EnergyRateLabel $ " - " $ Int(EnergyRate) );

	// Energy Rate
	winInfo.AppendText(winInfo.CR() $ winInfo.CR() $ winInfo.Sprintf(EnergyRateLabel, Int(EnergyRate)));
	//winInfo.AppendText( Sprintf(EnergyRateLabel, Int(EnergyRate)));
	//winInfo.AppendText( "BLABLA" );

	// Current Level
	strOut = winInfo.Sprintf(CurrentLevelLabel, CurrentLevel + 1);
	
	// Can Upgrade / Is Active labels
	if (CanBeUpgraded())
		strOut = strOut @ CanUpgradeLabel;
	else if (CurrentLevel == MaxLevel )
		strOut = strOut @ MaximumLabel;

	winInfo.AppendText(winInfo.CR() $ winInfo.CR() $ strOut);

	// Always Active?
	if (bAlwaysActive)
		winInfo.AppendText(winInfo.CR() $ winInfo.CR() $ AlwaysActiveLabel);

	return True;
}

// ----------------------------------------------------------------------------
// IsActive()
// ----------------------------------------------------------------------------

simulated function bool IsActive()
{
	return bIsActive;
}

// ----------------------------------------------------------------------------
// IsAlwaysActive()
// ----------------------------------------------------------------------------

simulated function bool IsAlwaysActive()
{
	return bAlwaysActive;
}

// ----------------------------------------------------------------------------
// GetHotKey()
// ----------------------------------------------------------------------------

simulated function int GetHotKey()
{
	return HotKeyNum;
}

// ----------------------------------------------------------------------------
// GetCurrentLevel()
// ----------------------------------------------------------------------------

simulated function int GetCurrentLevel()
{
	return CurrentLevel;
}

// ----------------------------------------------------------------------------
// GetEnergyRate()
//
// Allows the individual augs to override their energy use
// ----------------------------------------------------------------------------

simulated function float GetEnergyRate()
{
	return EnergyRate;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bGameRelevant=True
	EnergyRate=50.0
	MaxLevel=3
	IconWidth=52
	IconHeight=52
	HotKeyNum=-1
	EnergyRateLabel="Energy Rate: %d Units/Minute"
	OccupiesSlotLabel="Occupies Slot: %s"
	AugLocsText(0)="Cranial"
	AugLocsText(1)="Eyes"
	AugLocsText(2)="Torso"
	AugLocsText(3)="Arms"
	AugLocsText(4)="Legs"
	AugLocsText(5)="Subdermal"
	AugLocsText(6)="Default"
	AugActivated="%s activated"
	AugDeactivated="%s deactivated"
	AugAlwaysActive="%s is always active"
	//MPInfo="DEFAULT AUG MP INFO - REPORT THIS AS A BUG"
	AugAlreadyHave="You already have the %s at the maximum level"
	AugNowHave="%s upgraded to level %d"
	AugNowHaveAtLevel="Augmentation %s at level %d"
	AlwaysActiveLabel="[Always Active]"
	CanUpgradeLabel="(Can Upgrade)"
	CurrentLevelLabel="Current Level: %d"
	MaximumLabel="(Maximum)"
	ActivateSound=AugActivate
	DeActivateSound=AugDeactivate
	LoopSound=AugLoop
	bHidden=True
	bTravel=True
	NetUpdateFrequency=5.0
	bActivateWithAll=True
	bDeactivateWithAll=True
}
