//=============================================================================
// HXAugmentationCannister.
//=============================================================================
class HXAugmentationCannister extends HXDeusExPickup;

// Thanks to ION we can't travel class.
var() travel Name AddAugs[2];

var localized string AugsAvailable;
var localized string MustBeUsedOn;

// ----------------------------------------------------------------------------
// Network Replication.
// ----------------------------------------------------------------------------

replication
{
	// Server to client.
	reliable if ( bNetOwner && Role==ROLE_Authority )
		AddAugs;
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local AugmentationCannister OtherAugmentationCannister;

	// Call Super.
	Super.Succeeds( Other );

	// Special AugmentationCannister Init.
	OtherAugmentationCannister = AugmentationCannister(Other);
	if ( OtherAugmentationCannister!=None )
	{
		// AugmentationCannister.
		AddAugs[0] = OtherAugmentationCannister.AddAugs[0];
		AddAugs[1] = OtherAugmentationCannister.AddAugs[1];
	}
}

// ----------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------

simulated function PreBeginPlay()
{
	local int iAddAugs;

	local class<Actor> AugmentationClass;

	Super.PreBeginPlay();

	if ( Level.NetMode!=NM_Client && !IsInRelevant() )
	{
		// Mutators had their chance to modify AddAugs. Now translate those classes to HX ones if needed.
		for ( iAddAugs=0; iAddAugs<ArrayCount(AddAugs); iAddAugs++ )
		{
			if ( AddAugs[iAddAugs]=='' )
				continue;

			// Load class matching AddAugs[j] and use Mutator flow to translate it into the corrosponding
			// replacement class. Afterwards use this classes name.
			AugmentationClass = class<Augmentation>(DynamicLoadObject("DeusEx."$AddAugs[iAddAugs],class'Class',true));
			if ( AugmentationClass==None )
				continue;

			Game.ModifyActorClass( AugmentationClass );
			if ( !ClassIsChildOf(AugmentationClass,Class'HXAugmentation') )
				continue;

			AddAugs[iAddAugs] = AugmentationClass.Name;
		}
	}
}

// ----------------------------------------------------------------------------
// SpawnCopy()
// ----------------------------------------------------------------------------

function Inventory SpawnCopy( pawn Other )
{
	local HXAugmentationCannister CannisterCopy;
	local Inventory Copy;

	Copy = Super.SpawnCopy( Other );

	CannisterCopy = HXAugmentationCannister(Copy);
	if ( CannisterCopy!=None )
	{
		CannisterCopy.AddAugs[0] = AddAugs[0];
		CannisterCopy.AddAugs[1] = AddAugs[1];
	}

	return Copy;
}

// ----------------------------------------------------------------------------
// InfoText()
//
// Description intended for the info window.
// ----------------------------------------------------------------------------

simulated function string InfoText()
{
	// Only show count if we have multiple copies.
	if ( bCanHaveMultipleCopies && NumCopies>1 )
		return Super.InfoText() $ "|n|n" $ CountLabel @ String(NumCopies);
	else
		return Super.InfoText();
}

// ----------------------------------------------------------------------------
// UpdateInfo()
// ----------------------------------------------------------------------------

simulated function bool UpdateInfo(Object winObject)
{
	local HXPersonaInfoWindow winInfo;
	local String outText;
	local Int canIndex;
	local Augmentation aug;

	winInfo = HXPersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	winInfo.Clear();
	winInfo.SetTitle(itemName);
	winInfo.SetText(Description);

	winInfo.AppendText(winInfo.CR() $ winInfo.CR() $ AugsAvailable);
	winInfo.AppendText(winInfo.CR() $ winInfo.CR());

	for(canIndex=0; canIndex<ArrayCount(AddAugs); canIndex++)
	{
		if (AddAugs[canIndex] != '')
		{
			aug = GetAugmentation(canIndex);

			if (aug != None)
				winInfo.AppendText(aug.default.AugmentationName $ winInfo.CR());
		}
	}	
	
	winInfo.AppendText(winInfo.CR() $ MustBeUsedOn);

	return True;
}

// ----------------------------------------------------------------------------
// GetAugmentation()
// ----------------------------------------------------------------------------

simulated function Augmentation GetAugmentation(int augIndex)
{
	local Augmentation anAug;
	local DeusExPlayer player;

	// First make sure we have a valid value
	if ((augIndex < 0) || (augIndex > (ArrayCount(AddAugs) - 1)))
		return None;

	if (AddAugs[augIndex] == '')
		return None;

	// Loop through all the augmentation objects and look 
	// for the augName that matches the one stored in 
	// this object

	player = DeusExPlayer(Owner);

	if (player != None)
	{
		anAug = player.AugmentationSystem.FirstAug;
		while(anAug != None)
		{
			if (addAugs[augIndex] == anAug.Class.Name)
				break;

			anAug = anAug.next;
		}
	}

	return anAug;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	AugsAvailable="Can Add:"
	MustBeUsedOn="Can only be installed with the help of a MedBot."
	ItemName="Augmentation Canister"
	ItemArticle="an"
	PlayerViewOffset=(X=30.0,Y=0.0,Z=-12.0)
	PlayerViewMesh=AugmentationCannister
	PickupViewMesh=AugmentationCannister
	ThirdPersonMesh=AugmentationCannister
	LandSound=PlasticHit1
	Icon=BeltIconAugmentationCannister
	LargeIcon=LargeIconAugmentationCannister
	LargeIconWidth=19
	LargeIconHeight=49
	Description="An augmentation canister teems with nanoscale mechanocarbon ROM modules suspended in a carrier serum. When injected into a compatible host subject, these modules augment an individual with extra-sapient abilities. However, proper programming of augmentations must be conducted by a medical robot, otherwise terminal damage may occur. For more information, please see 'Face of the New Man' by Kelley Chance."
	BeltDescription="AUG CAN"
	Mesh=AugmentationCannister
	CollisionRadius=4.31
	//CollisionHeight=10.24
	CollisionHeight=9.49
	Mass=10.0
	Buoyancy=12.0
	AddAugs(0)=AugMuscle
	AddAugs(1)=AugCombat
}
