//=============================================================================
// HXAutoTurretGun.
//=============================================================================
class HXAutoTurretGun extends HXHackableDevices;

var int		team;
var String	titleString;
var float	updateTime;

replication
{
	reliable if (Role==ROLE_Authority)
		team, titleString;
}

simulated function Destroyed()
{
	local HXAutoTurret turret;

	if ( Role==ROLE_Authority )
	{
		turret = HXAutoTurret(Owner);
		if (turret != None)
		{
			turret.gun = None;
			turret.Destroy();
			SetOwner(None);
		}
	}
	Super.Destroyed();		
}

function ResetComputerAlignment()
{
	local HXAutoTurret turret;
	local HXComputerSecurity TempComp;
	local int ViewIndex;

	turret = HXAutoTurret(Owner);

/*
	if (( Level.NetMode != NM_Standalone ) && ( turret != None ))
	{
		//Find the associated computer
		foreach AllActors(class'HXComputerSecurity',TempComp)
		{
			for (ViewIndex = 0; ViewIndex < ArrayCount(TempComp.Views); ViewIndex++)
			{
				if (TempComp.Views[ViewIndex].turretTag == turret.Tag)
				{
					TempComp.Team = -1;
				}
			}
		}
	}
*/
}

function HackAction(Actor Hacker, bool bHacked)
{
   local HXComputerSecurity CompOwner;
   local HXComputerSecurity TempComp;
	local HXAutoTurret turret;
   local SecurityCamera Camera;
   local name CameraTag;
   local int ViewIndex;

	Super.HackAction(Hacker, bHacked);

	turret = HXAutoTurret(Owner);
	if (bHacked && (turret != None))
	{
      //if (Level.NetMode == NM_Standalone)
      //{
         if (!turret.bDisabled)
         {
            turret.UnTrigger(Hacker, Pawn(Hacker));
            turret.bDisabled = True;
         }
         else
         {
            turret.bDisabled = False;
            turret.Trigger(Hacker, Pawn(Hacker));
         }
      //}
/*
      else
      {
         //DEUS_EX AMSD Reset the hackstrength afterwards
         if (hackStrength == 0.0)
            hackStrength = 0.6;
         turret.bDisabled = True;
         turret.Trigger(Hacker,Pawn(Hacker));
         //Find the associated computer.
         foreach AllActors(class'HXComputerSecurity',TempComp)
         {
            for (ViewIndex = 0; ViewIndex < ArrayCount(TempComp.Views); ViewIndex++)
            {
               if (TempComp.Views[ViewIndex].turretTag == Turret.Tag)
               {
                  CompOwner = TempComp;
                  //find associated turret
                  cameratag = TempComp.Views[ViewIndex].cameratag;
                  if (cameratag != '')
                  {
                     foreach AllActors(class'HXSecuritycamera', camera, cameraTag)
                     {
                        break;
                     }
                  }
               }
            }
         }

         if (CompOwner != None)
         {
            if ( (Hacker.IsA('DeusExPlayer')) && (Camera.bActive))
            {
               Camera.HackStrength = 0.6;
               if (Camera.bActive)
                  Camera.UnTrigger(Hacker, Pawn(Hacker));
            }
         }
      }
*/
	}
}

function Tick(float deltaTime)
{
	local HXAutoTurret turret;

	Super.Tick(deltaTime);

	// As a client, it was possible for the turret to become irrelevant to you while the gun remained relevant
	if  ((Level.NetMode != NM_Standalone) && (updateTime < Level.Timeseconds))
	{
		updateTime = Level.Timeseconds + 2.0;
		turret = HXAutoTurret(Owner);
		if ( turret != None )
		{
			if ( team != turret.team )
				team = turret.team;
			if (!( titleString ~= turret.titleString ))
				titleString = turret.titleString;
		}
	}
}

function TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
{
	//if (( Level.NetMode != NM_Standalone ) && (EventInstigator.IsA('DeusExPlayer')))
		//DeusExPlayer(EventInstigator).ServerConditionalNotifyMsg( DeusExPlayer(EventInstigator).MPMSG_TurretInv );

	Super.TakeDamage(Damage, EventInstigator, HitLocation, Momentum, DamageType);
}

function PreBeginPlay()
{
	Super.PreBeginPlay();

	//if ( Level.NetMode != NM_Standalone )
	//{
		//bInvincible = True;
      //hackStrength = 0.6;
	//}
}

function PostBeginPlay()
{
	local AutoTurretGun StaleGun;
	//local HXAutoTurret turret;

	Super.PostBeginPlay();

	//turret = HXAutoTurret(Owner);

	//if (( Level.NetMode != NM_Standalone ) && ( turret != None ))
	//{
		//team = turret.team;
		//titleString = turret.titleString;
	//}

	// the sins of our youth
	//foreach AllActors( Class'AutoTurretGun', StaleGun )
	//{
		//StaleGun.bInvincible = False;
		//StaleGun.SetOwner(None);
		//StaleGun.Destroy();
	//}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bGameRelevant=True
	bAlwaysRelevant=True 
	Team=-1
	HackStrength=0.5
	HitPoints=50
	MinDamageThreshold=50
	bInvincible=False
	FragType=MetalFragment
	ItemName="Autonomous Defense Turret"
	Physics=PHYS_Rotating
	Mesh=AutoTurretGun
	PrePivot=(Z=-8.77)
	SoundRadius=24
	CollisionRadius=22.50
	//CollisionHeight=9.10
	CollisionHeight=8.35
	LightEffect=LE_NonIncidence
	LightBrightness=255
	LightHue=28
	LightSaturation=160
	LightRadius=2
	bRotateToDesired=True
	Mass=50.0
	Buoyancy=10.0
	RotationRate=(Pitch=16384,Yaw=16384)
	bVisionImportant=True
}
