//=============================================================================
// HXBarrelFire.
//=============================================================================
class HXBarrelFire extends HXContainers;

var float LastDamageTime;

// ----------------------------------------------------------------------------
// DamageOther()
// ----------------------------------------------------------------------------

function DamageOther( Actor Other )
{
	if ( Other!=None && !Other.IsA('HXScriptedPawn') )
	{
		// Only take damage every second.
		if ( Level.TimeSeconds-LastDamageTime>=1.0 )
		{
			Other.TakeDamage( 5, None, Location, Vect(0,0,0), 'Burned' );
			LastDamageTime = Level.TimeSeconds;
		}
	}
}

// ----------------------------------------------------------------------------
// SupportActor()
// ----------------------------------------------------------------------------

singular function SupportActor( Actor Other )
{
	DamageOther( Other );
	Super.SupportActor( Other );
}

// ----------------------------------------------------------------------------
// Bump()
// ----------------------------------------------------------------------------

singular function Bump( Actor Other )
{
	DamageOther( Other );
	Super.Bump( Other );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	HitPoints=40
	bInvincible=True
	bFlammable=False
	ItemName="Burning Barrel"
	bBlockSight=True
	Mesh=BarrelFire
	ScaleGlow=2.0
	bUnlit=True
	SoundRadius=16
	SoundVolume=255
	AmbientSound=FireSmall2
	CollisionRadius=20.00
	//CollisionHeight=29.00
	CollisionHeight=28.25
	LightType=LT_Steady
	LightEffect=LE_FireWaver
	LightBrightness=128
	LightHue=32
	LightSaturation=64
	LightRadius=6
	Mass=260.0
	Buoyancy=270.0
}
