//=============================================================================
// HXBeamTrigger.
//=============================================================================
class HXBeamTrigger extends HXLaserBeamTrigger;

var Actor LastTriggerActor; // Used to avoid running trigger loop each Tick if blocked.
var bool bAlreadyTriggered;

// ----------------------------------------------------------------------------
// BeamTriggered()
//
// A new releveant Actor ran into the beam.
// ----------------------------------------------------------------------------

function BeamTriggered( Actor Other )
{	
	local Pawn OtherPawn;
	local Actor A;

	Super.BeamTriggered( Other );

	// Skip if it should only be triggered once.
	if ( bAlreadyTriggered && bTriggerOnceOnly )
		return;

	// Mark as already trigger. Changed for HX so
	// bAlreadyTriggered gets always set instead of only
	// when bTriggerOnceOnly.
	bAlreadyTriggered = true;

	// Trigger event.
	if ( Event!='' && Other!=LastTriggerActor )
	{
		OtherPawn = Pawn(Other);

		foreach AllActors( class'Actor', A, Event )
			A.Trigger( Self, OtherPawn );

		LastTriggerActor = Other;
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	LaserEmitterClass=HXBlueLaserEmitter
	MultiSkins(1)=HXLaserSpot2
}
