//=============================================================================
// HXBeverage.
//=============================================================================
class HXBeverage extends HXFood
	abstract;

/*
var const bool  bBreakable; // Can we destroy this item (by dropping)?
*/
var const Sound BreakItSmashSound;

// ----------------------------------------------------------------------------
// _BreakItSmashIt()
// ----------------------------------------------------------------------------

function _BreakItSmashIt() 
{
	local DeusExFragment s;
	local float size;
	local int i;
		
	size = (CollisionRadius + CollisionHeight) / 2;

	// !! Would be nice to have a decal for the cleaner bot !!
	for (i=0; i<Int(size); i++) 
	{
		s = DeusExFragment(Spawn(FragType, Owner));
		if (s != None)
		{
			s.Instigator = Instigator;
			s.CalcVelocity(Velocity,0);
			s.DrawScale = ((FRand() * 0.05) + 0.05) * size;
			s.Skin = GetMeshTexture();

			// play a good breaking sound for the first fragment
			if (i == 0)
				s.PlaySound( BreakItSmashSound, SLOT_None,,, 768);
		}
	}

	Destroy();
}

//=============================================================================
// state Pickup.
//
// This inventory item is sitting on the ground.
//=============================================================================

auto state Pickup
{
	// if we hit the ground fast enough, break it, smash it!!!
	function Landed( vector HitNormal )
	{
		// If we hit the ground fast enough, break it, smash it!!!
		if ( bBreakable && VSize(Velocity)>400.0 )
		{
			// Skip over DeusExPickup playing landing sound when breaking.
			Super(HXPickup).Landed( HitNormal );

			_BreakItSmashIt();
		}
		else
		{
			Super(HXDeusExPickup).Landed( HitNormal );
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	MsgPutInMouth="Drank %s %s"
	BreakItSmashSound=GlassBreakSmall
}
