//=============================================================================
// HXBinoculars.
//=============================================================================
class HXBinoculars extends HXDeusExPickup;

// ----------------------------------------------------------------------------
// state Activated.
// ----------------------------------------------------------------------------

state Activated
{
	function Activate()
	{
		local HXPlayerPawn player;

		Super.Activate();

		player = HXPlayerPawn(Owner);
		if (player != None)
			player.DesiredFOV = player.Default.DesiredFOV;
	}

	function BeginState()
	{
		local HXPlayerPawn player;
	
		Super.BeginState();

		player = HXPlayerPawn(Owner);
		RefreshScopeDisplay(player, False);
	}
Begin:
}

// ----------------------------------------------------------------------------
// state DeActivated.
// ----------------------------------------------------------------------------

state DeActivated
{
	function BeginState()
	{
		local HXPlayerPawn player;
		
		Super.BeginState();

		player = HXPlayerPawn(Owner);
		if (player != None)
		{
			// Hide the Scope View
			//HXRootWindow(player.rootWindow).scopeView.DeactivateView();
			player.ClientDeactivateScopeView();
		}
	}
}

// ----------------------------------------------------------------------------
// RefreshScopeDisplay()
// ----------------------------------------------------------------------------

function RefreshScopeDisplay(HXPlayerPawn player, optional bool bInstant)
{
	if ((bActive) && (player != None))
	{
		// Show the Scope View
		//HXRootWindow(player.rootWindow).scopeView.ActivateView(20, True, bInstant);
		player.ClientActivateScopeView( 20, True, bInstant );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bActivatable=True
	ItemName="Binoculars"
	ItemArticle="some"
	PlayerViewOffset=(X=18.0,Y=0.0,Z=-6.0)
	PlayerViewMesh=Binoculars
	PickupViewMesh=Binoculars
	ThirdPersonMesh=Binoculars
	LandSound=PaperHit2
	Icon=BeltIconBinoculars
	LargeIcon=LargeIconBinoculars
	LargeIconWidth=49
	LargeIconHeight=34
	Description="A pair of military binoculars."
	BeltDescription="BINOCS"
	Mesh=Binoculars
	CollisionRadius=7.00
	//CollisionHeight=2.06
	CollisionHeight=1.31
	Mass=5.0
	Buoyancy=6.0
}
