//=============================================================================
// HXBioelectricCell.
//=============================================================================
class HXBioelectricCell extends HXInstantUsePickup;

var localized String RechargesLabel;

var const Sound RechargeSound;
var const int   RechargeAmount;

// ----------------------------------------------------------------------------
// InstantUse()
// ----------------------------------------------------------------------------

function InstantUse( Pawn OwnerPawn, Actor FrobTarget )
{
	local HXPlayerPawn OwnerPlayer;

	OwnerPlayer = HXPlayerPawn(OwnerPawn);
	if ( OwnerPlayer==None )
		return;

	// RechargePlayer sents the ClientMessage for us.
	if ( RechargeAmount>0 )
		OwnerPlayer.RechargePlayer( RechargeAmount, false );
	if ( RechargeSound!=None )
		OwnerPlayer.PlaySound( RechargeSound, SLOT_None,,, 256 );
}

// ----------------------------------------------------------------------------
// UpdateInfo()
// ----------------------------------------------------------------------------

simulated function bool UpdateInfo(Object winObject)
{
	local HXPersonaInfoWindow winInfo;
	local string str;

	winInfo = HXPersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	winInfo.SetTitle(itemName);
	winInfo.SetText(Description $ winInfo.CR() $ winInfo.CR());
	winInfo.AppendText(Sprintf(RechargesLabel, RechargeAmount));

	// Print the number of copies
	str = CountLabel @ String(NumCopies);
	//winInfo.AppendText(winInfo.CR() $ winInfo.CR() $ str);
	winInfo.AppendText(str);

	return True;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	M_Activated=""
	RechargeSound=BioElectricHiss
	MsgTooMany="You can't carry any more bioelectric cells."
	RechargeAmount=25
	RechargesLabel="Recharges %d Energy Units"
	MaxCopies=30
	bCanHaveMultipleCopies=True
	bActivatable=True
	ItemName="Bioelectric Cell"
	PlayerViewOffset=(X=30.0,Y=0.0,Z=-12.0)
	PlayerViewMesh=BioCell
	PickupViewMesh=BioCell
	ThirdPersonMesh=BioCell
	LandSound=PlasticHit2
	Icon=BeltIconBioCell
	LargeIcon=LargeIconBioCell
	LargeIconWidth=44
	LargeIconHeight=43
	Description="A bioelectric cell provides efficient storage of energy in a form that can be utilized by a number of different devices.|n|n<UNATCO OPS FILE NOTE JR289-VIOLET> Augmented agents have been equipped with an interface that allows them to transparently absorb energy from bioelectric cells. -- Jaime Reyes <END NOTE>"
	BeltDescription="BIOCELL"
	Mesh=BioCell
	CollisionRadius=4.70
	//CollisionHeight=0.93
	CollisionHeight=0.18
	Mass=5.0
	Buoyancy=4.0
}
