//=============================================================================
// HXBird.
//=============================================================================
class HXBird extends HXAnimal
	abstract;

var(AI) float LikesFlying;

var Sound FlySound;
var Sound CooSound;

var Name  WaitAnim;
var float LastCheck;
var float Stuck;
var float HitTimer;
var float Fright;
var float InitialRate;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Bird OtherBird;

	// Call Super.
	Super.Succeeds( Other );

	// Special Bird Init.
	OtherBird = Bird(Other);
	if ( OtherBird!=None )
	{
		LikesFlying = OtherBird.LikesFlying;
	}
}

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( bDeleteMe || IsInRelevant() )
		return;

	// Put this rather in PostPostBeginPlay() ?
	if ( Level.NetMode!=NM_Client )
		AIClearEventCallback( 'WeaponFire' );
}



function TakeDamage(int Damage, Pawn instigatedBy, Vector hitlocation, 
                    Vector momentum, name damageType)
{
	if ((DamageType == 'EMP') || (DamageType == 'NanoVirus'))
		return;

	if (!bInvincible)
		Health -= Damage;

	HealthHead     = Health;
	HealthTorso    = Health;
	HealthArmLeft  = Health;
	HealthArmRight = Health;
	HealthLegLeft  = Health;
	HealthLegRight = Health;

	if (Health > 0)
	{
		MakeFrightened();
		GotoState('Flying');
		//PlayHit(actualDamage, hitLocation, damageType, momentum.z);
	}
	else
	{
		ClearNextState();
		//PlayDeathHit(actualDamage, hitLocation, damageType);
		Enemy = instigatedBy;
		Died(instigatedBy, damageType, HitLocation);
	}
}


function TweenToWaiting(float tweentime)
{
	if (FRand() >= 0.5)
		WaitAnim = 'Idle1';
	else
		WaitAnim = 'Idle2';
	TweenAnim(WaitAnim, tweentime);
}

simulated function PlayWaiting()
{
	LoopAnim(WaitAnim);
}

function PlayFlying()
{
	LoopAnim('Fly', 1.0, 0.1);
	InitialRate = AnimRate;
}

function MakeFrightened()
{
	Fright = (cowardice*99)+1;
}

function FleeFromPawn(Pawn fleePawn)
{
	MakeFrightened();
	if (GetStateName() != 'Flying')
		GotoState('Flying');
}

function Tick(float deltaSeconds)
{
	Super.Tick(deltaSeconds);

	if (Fright > 0)
	{
		Fright -= deltaSeconds;
		if (Fright < 0)
			Fright = 0;
	}
}

state Wandering
{
	function BeginState()
	{
		Super.BeginState();
		AISetEventCallback('LoudNoise', 'HeardNoise');
	}

	function EndState()
	{
		Super.EndState();
		AIClearEventCallback('LoudNoise');
	}

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);

		if ((DamageType == 'EMP') || (DamageType == 'NanoVirus'))
			return;

		if ( health <= 0 )
			return;
		enemy = instigatedBy;
		if ( Enemy != None )
			LastSeenPos = Enemy.Location;
		//SetNextState('Flying', 'Begin');
		//GotoState('TakingHit');
		MakeFrightened();
		GotoState('Flying');
	}

	function PickDestination()
	{
		local int   iterations;
		local float magnitude;

		magnitude  = (wanderlust*300+100) * (FRand()*0.2+0.9); // 100-400, +/-10%
		iterations = 5;  // try up to 5 different directions

		if (!AIPickRandomDestination(30, magnitude, 0, 0, 0, 0, iterations, FRand()*0.4+0.35, destLoc))
			destLoc = Location;
	}

	function HeardNoise(Name eventName, EAIEventState state, XAIParams params)
	{
		FleeFromPawn(Pawn(params.bestActor));
	}

	function Tick(float deltaSeconds)
	{
		Super.Tick(deltaSeconds);

		LastCheck += deltaSeconds;
		if (LastCheck > 0.5)
		{
			LastCheck = 0;
			if (FRand() < 0.1)
			{
				PlaySound( CooSound, SLOT_Misc );
			}
		}
	}
}


state Flying
{
	simulated function HitWall(vector HitNormal, actor Wall)
	{
		local Vector  newVector;
		local Rotator newRotator;

		if (HitTimer > 0)
			return;

		HitTimer = 0.5;
		Disable('HitWall');

		newVector    = (Velocity dot HitNormal) * HitNormal * (-2.0) + Velocity;
		newRotator   = Rotator(newVector);

		SetRotation(newRotator);
		DesiredRotation = newRotator;

		Acceleration = vect(0, 0, 0);
		Velocity     = newVector;
		if (VSize(Velocity) < 0.01)
			Velocity = Vector(Rotation);

		destLoc = Location + 80*Velocity/VSize(Velocity);
		GotoState('Flying', 'KeepGoing');
	}

	function Tick(float deltaSeconds)
	{
		local float rate;

		Global.Tick(deltaSeconds);

		if (HitTimer > 0)
		{
			HitTimer -= deltaSeconds;
			if (HitTimer < 0)
			{
				HitTimer = 0;
				Enable('HitWall');
			}
		}
		Stuck += deltaSeconds;

		if (Physics == PHYS_Flying)
		{
			rate = FClamp(Acceleration.Z+250, 0, 500)/500 + 0.5;
			AnimRate = InitialRate*rate;
		}
		else if (Physics == PHYS_Falling)
			AnimRate = InitialRate*0.1;
	}

	function HeardNoise(Name eventName, EAIEventState state, XAIParams params)
	{
		MakeFrightened();
	}

	function bool ReadyToLand()
	{
		local Pawn fearPawn;

		fearPawn = FrightenedByPawn();
		if (fearPawn != None)
		{
			MakeFrightened();
			return false;
		}
		else if (Fright > 0)
			return false;
		else if (FRand() <= LikesFlying)
			return false;
		else
			return true;
	}

	function CheckStuck()
	{
		if (Stuck > 10.0)
			GotoState('Flying', 'Drop');
	}

	function bool CheckDestination(vector dest, out float magnitude, float minDist)
	{
		local bool retval;
		local float dist;

		retval = False;
		dist = magnitude;
		while (dist > minDist)
		{
			if (PointReachable(Location+(dest*dist)))
				break;
			dist *= 0.5;
		}
		if (dist > minDist)
		{
			magnitude = dist;
			retval    = True;
		}

		return (retval);
	}

	function PickDestination()
	{
		local vector dest;
		local float  magnitude;
		local int    iterations;
		local bool   bValid;

		iterations = 4;
		while (iterations > 0)
		{
			//magnitude = 800+(FRand()*100-50);
			magnitude = 1200+(FRand()*200-100);
			dest = VRand();
			bValid = CheckDestination(dest, magnitude, 100);
			if (!bValid && (dest.Z != 0))
			{
				dest.Z = -dest.Z;
				bValid = CheckDestination(dest, magnitude, 100);
			}
			if (bValid)
				break;

			iterations--;
		}
		if (iterations > 0)
		{
			destLoc = Location + (dest*magnitude);
			Stuck = 0;
		}
		else
		{
			if (VSize(Velocity) > 0.001)
				destLoc = 40*Velocity/VSize(Velocity);
			else
				destLoc = Velocity;
			if (Stuck > 5.0)
				destLoc += VRand()*((Stuck-5.0)*3.0);
			destLoc += Location;
		}
	}

	function PickInitialDestination()
	{
		local vector  dest;
		local rotator rot;
		local float   magnitude;

		//magnitude = 200 + (FRand()*50-25);
		magnitude = 300 + (FRand()*100-50);
		rot.yaw = Rotation.yaw;
		//rot.pitch = 8192+(Rand(6000)-3000);
		rot.pitch = 10000+(Rand(6000)-3000);
		rot.roll = 0;
		dest = Vector(rot);
		if (CheckDestination(dest, magnitude, 20))
			destLoc = Location + (dest*magnitude);
		else
			destLoc = Location + vect(0, 0, 100);
	}

	function bool PickFinalDestination()
	{
		local vector dest;
		local Actor  landActor;
		local vector hitLoc;
		local vector hitNorm;
		local vector endPoint;
		local vector startPoint;
		local int    iterations;
		local bool   retval;

		retval = False;

		iterations = 3;
		while (iterations > 0)
		{
			startPoint = VRand()*100 + Location;
			startPoint.Z = Location.Z;
			endPoint = startPoint;
			endPoint.Z -= 1000;
			foreach TraceActors(Class'Actor', landActor, hitLoc, hitNorm, endPoint, startPoint)
			{
				if (landActor == Level)
				{
					hitLoc.Z += CollisionHeight+5;
					if (PointReachable(hitLoc))
						break;
				}
				else
				{
					landActor = None;
					break;
				}
			}
			if (landActor != None)
			{
				break;
			}
			iterations--;
		}

		if (iterations > 0)
		{
			destLoc = hitLoc;
			retval  = True;
		}

		return (retval);
	}

	function BeginState()
	{
		SetPhysics(PHYS_Flying);
		Enable('HitWall');
		Stuck       = 0;
		HitTimer    = 0;
		AISetEventCallback('LoudNoise', 'HeardNoise');
		PlaySound( FlySound, SLOT_Misc );
		SetCollision(true, false, false);
	}

	function EndState()
	{
		SetCollision(true, true, true);
		SetPhysics(PHYS_Falling);
		Enable('HitWall');
		AIClearEventCallback('LoudNoise');
	}

Begin:
	PlayFlying();

StartFlying:
	PickInitialDestination();
	MoveTo(destLoc);

Fly:
	if (ReadyToLand())
		Goto('Land');
	PickDestination();

KeepGoing:
	CheckStuck();
	MoveTo(destLoc);
	Goto('Fly');

Land:
	if (!PickFinalDestination())
	{
		PickDestination();
		Goto('KeepGoing');
	}
	MoveTo(destLoc);
	SetPhysics(PHYS_Falling);
	WaitForLanding();
	Acceleration = vect(0, 0, 0);
	GotoState('Wandering');

Drop:
	DesiredRotation.pitch = -16384;
	SetPhysics(PHYS_Falling);
	Sleep(0.5);
	SetPhysics(PHYS_Flying);
	Goto('Fly');
}


// Kind of a hack, but...
state Fleeing
{
ignores all;
begin:
	GotoState('Flying');
}

state Attacking
{
ignores all;
begin:
	Sleep(0.5);
	GotoState('Wandering');
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	WalkingSpeed=0.666667
	GroundSpeed=24.0
	WaterSpeed=8.0
	AirSpeed=150.0
	AccelRate=500.0
	JumpZ=0.0
	BaseEyeHeight=3.0
	Health=20
	UnderWaterTime=20.0
	AttitudeToPlayer=ATTITUDE_Fear
	HealthHead=20
	HealthTorso=20
	HealthLegLeft=20
	HealthLegRight=20
	HealthArmLeft=20
	HealthArmRight=20
	DrawType=DT_Mesh
	Mass=2.0
	Buoyancy=2.5
	WaitAnim=Idle1
	LikesFlying=0.25
	bFleeBigPawns=True
	Restlessness=1.0
	Wanderlust=0.05
	Cowardice=0.2
	bCanFly=True
	MaxStepHeight=2.0
}
