//=============================================================================
// HXBlackHelicopterExplosionEffect. :(
//
// Combines what the visual effects played when BlackHelicopter in Area 51
// starts to explode.
//=============================================================================
class HXBlackHelicopterExplosionEffect extends HXEffects
	transient;

var float ChopperCollisionHeight;

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	local AnimatedSprite Explosion;
	local PlayerPawn PlayerPawn;
	local Vector SpawnLocation;
	local int i;

	// Small explosion sprites
	for ( i=0; i<6; i++ )
	{
		SpawnLocation = Location + VRand() * ChopperCollisionHeight;
		if (FRand() < 0.25)
		{
			Explosion = Spawn( Class'ExplosionSmall', , , SpawnLocation );
		}
		else
		{
			Explosion = Spawn( Class'ExplosionMedium', , , SpawnLocation );
		}

		if ( Explosion!=None )
		{
			Explosion.RemoteRole = ROLE_None;
			Explosion.AnimSpeed += 0.3 * FRand();
		}
	}

	// Note: Maybe spawn some fragments too?

	// Sound.
	PlayerPawn = GetPlayerPawn();
	if ( PlayerPawn!=None )
	{
		PlayerPawn.PlaySound( Sound'MediumExplosion1', SLOT_None, 2.0,, 16384 );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	RemoteRole=ROLE_SimulatedProxy
	NetPriority=4.000000
	bAlwaysRelevant=True
	bNetTemporary=True
	bNetOptional=False
	DrawType=DT_None
	LifeSpan=1.000000
	ChopperCollisionHeight=87.839996
}
