//=============================================================================
// HXBlackHelicopterFinalExplosionEffect. :(
//
// Combines what the visual effects played when BlackHelicopter in Area 51
// finally explodes.
//=============================================================================
class HXBlackHelicopterFinalExplosionEffect extends HXEffects
	transient;

var float ChopperCollisionHeight;
var Texture ChopperSkin; // Used for Fragments.

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	local HXSphereEffect SphereEffect;
	local AnimatedSprite Explosion;
	local PlayerPawn PlayerPawn;
	local DeusExFragment Fragment;
	local Vector SpawnLocation;
	local int i;

	// Large explosion sprites.
	for ( i=0; i<20; i++ )
	{
		SpawnLocation = Location + VRand() * ChopperCollisionHeight;

		if (FRand() < 0.25)
		{
			Explosion = Spawn( Class'ExplosionMedium', , , SpawnLocation );
		}
		else
		{
			Explosion = Spawn( Class'ExplosionLarge', , , SpawnLocation );
		}

		if ( Explosion!=None )
		{
			Explosion.RemoteRole = ROLE_None;
			Explosion.AnimSpeed += 0.4 * FRand();
		}
	}

	// Metal fragments.
	for ( i=0; i<20; i++ )
	{
		SpawnLocation = Location + VRand() * ChopperCollisionHeight;

		Fragment = Spawn( Class'MetalFragment', , , SpawnLocation );
		if ( Fragment!=None)
		{
			Fragment.RemoteRole = ROLE_None;
			Fragment.CalcVelocity( Vect(40000,0,0), 512 );
			Fragment.DrawScale = 5.0 + 2.0 * FRand();
			Fragment.Skin = ChopperSkin;
			if (FRand() < 0.5)
				Fragment.bSmoking = True;
		}
	}

	// Light sphere.
	SphereEffect = Spawn( Class'HXSphereEffect',,, Location );
	if ( SphereEffect!=None)
	{
		SphereEffect.RemoteRole = ROLE_None;
		SphereEffect.Size = 32.0;
	}

	// Sound.
	PlayerPawn = GetPlayerPawn();
	if ( PlayerPawn!=None )
	{
		PlayerPawn.PlaySound( Sound'LargeExplosion2', SLOT_None, 2.0,, 16384 );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	RemoteRole=ROLE_SimulatedProxy
	NetPriority=4.000000
	bAlwaysRelevant=True
	bNetTemporary=True
	bNetOptional=False
	DrawType=DT_None
	LifeSpan=1.00000
	ChopperSkin=Texture'DeusExDeco.Skins.BlackHelicopterTex1'
	ChopperCollisionHeight=87.839996
}
