//=============================================================================
// HXBushes3.
//=============================================================================
class HXBushes3 extends HXOutdoorThings;

enum ESkinColor
{
	SC_Bushes1,
	SC_Bushes2,
	SC_Bushes3,
	SC_Bushes4
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Bushes3 OtherBushes3;

	// Call Super.
	Super.Succeeds( Other );

	// Special Bushes3 Init.
	OtherBushes3 = Bushes3(Other);
	if ( OtherBushes3!=None )
	{
		SetPropertyText( "SkinColor", OtherBushes3.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_Bushes1: Skin = Texture'Bushes3Tex1'; break;
			case SC_Bushes2: Skin = Texture'Bushes3Tex2'; break;
			case SC_Bushes3: Skin = Texture'Bushes3Tex3'; break;
			case SC_Bushes4: Skin = Texture'Bushes3Tex4'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ItemName="Bush"
	Mesh=Bushes3
	CollisionRadius=10.00
	//CollisionHeight=30.00
	CollisionHeight=29.25
	Mass=40.0
	Buoyancy=20.0
}
