//=============================================================================
// HXButton1.
//
// Notes:
//  * ION's netcode is basically just a way to ensure that the Button1 has the
//    correct end position if it becomes relevant while the mover it is 
//    attched too is moving.
//    However, a better approach might be set bAlwaysRelevant=True when
//    MoverTag is not empty, as just a few actors per map are affected.
//    (Trying it now).
//=============================================================================
class HXButton1 extends HXDecoration;

enum EButtonType
{
	BT_Up,
	BT_Down,
	BT_1,
	BT_2,
	BT_3,
	BT_4,
	BT_5,
	BT_6,
	BT_7,
	BT_8,
	BT_9,
	BT_Blank
};

var() EButtonType ButtonType;
var() float ButtonLitTime;
var() sound ButtonSound1;
var() sound ButtonSound2;
var() bool bLit;
var() bool bWaitForEvent;
var bool bPressed;

/*var Vector	LastLoc, RPCLocation;
var bool		bIsMoving;*/

// ----------------------------------------------------------------------------
// Network replication.
// ----------------------------------------------------------------------------

/*replication
{
	reliable if ( Role==ROLE_Authority )
		RPCLocation;
}*/

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		SetSkin( ButtonType, bLit );

		/*if ( Level.NetMode!=NM_Standalone )
			RPCLocation = Location;*/

		bAlwaysRelevant = MoverTag!='';
	}
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Button1 OtherButton1;

	// Call Super.
	Super.Succeeds( Other );

	// Special Button1 Init.
	OtherButton1 = Button1(Other);
	if ( OtherButton1!=None )
	{
		SetPropertyText( "ButtonType", OtherButton1.GetPropertyText("ButtonType") );
		ButtonLitTime = OtherButton1.ButtonLitTime;
		ButtonSound1  = OtherButton1.ButtonSound1;
		ButtonSound2  = OtherButton1.ButtonSound2;
		bLit          = OtherButton1.bLit;
		bWaitForEvent = OtherButton1.bWaitForEvent;
	}
}

// ----------------------------------------------------------------------------
// SetSkin().
//
// WOW! What a mess.  I wish you could convert strings to names!
// HX_HAN: Well, that was added later.. Or you could have used DynamicLoad().
// ----------------------------------------------------------------------------

function SetSkin( EButtonType Type, bool Lit )
{
	switch ( Type )
	{
		case BT_Up:
			if ( Lit )
			{
				Skin = Texture'Button1Tex2';
				ScaleGlow = 3.0;
			}
			else
			{
				Skin = Texture'Button1Tex1';
				ScaleGlow = Default.ScaleGlow;
			}
			break;
		case BT_Down:
			if ( Lit )
			{
				Skin = Texture'Button1Tex4';
				ScaleGlow = 3.0;
			}
			else
			{
				Skin = Texture'Button1Tex3';
				ScaleGlow = Default.ScaleGlow;
			}
			break;
		case BT_1:
			if ( Lit )
			{
				Skin = Texture'Button1Tex6';
				ScaleGlow = 3.0;
			}
			else
			{
				Skin = Texture'Button1Tex5';
				ScaleGlow = Default.ScaleGlow;
			}
			break;
		case BT_2:
			if ( Lit )
			{
				Skin = Texture'Button1Tex8';
				ScaleGlow = 3.0;
			}
			else
			{
				Skin = Texture'Button1Tex7';
				ScaleGlow = Default.ScaleGlow;
			}
			break;
		case BT_3:
			if ( Lit )
			{
				Skin = Texture'Button1Tex10';
				ScaleGlow = 3.0;
			}
			else
			{
				Skin = Texture'Button1Tex9';
				ScaleGlow = Default.ScaleGlow;
			}
			break;
		case BT_4:
			if ( Lit )
			{
				Skin = Texture'Button1Tex12';
				ScaleGlow = 3.0;
			}
			else
			{
				Skin = Texture'Button1Tex11';
				ScaleGlow = Default.ScaleGlow;
			}
			break;
		case BT_5:
			if ( Lit )
			{
				Skin = Texture'Button1Tex14';
				ScaleGlow = 3.0;
			}
			else
			{
				Skin = Texture'Button1Tex13';
				ScaleGlow = Default.ScaleGlow;
			}
			break;
		case BT_6:
			if ( Lit )
			{
				Skin = Texture'Button1Tex16';
				ScaleGlow = 3.0;
			}
			else
			{
				Skin = Texture'Button1Tex15';
				ScaleGlow = Default.ScaleGlow;
			}
			break;
		case BT_7:
			if ( Lit )
			{
				Skin = Texture'Button1Tex18';
				ScaleGlow = 3.0;
			}
			else
			{
				Skin = Texture'Button1Tex17';
				ScaleGlow = Default.ScaleGlow;
			}
			break;
		case BT_8:
			if ( Lit )
			{
				Skin = Texture'Button1Tex20';
				ScaleGlow = 3.0;
			}
			else
			{
				Skin = Texture'Button1Tex19';
				ScaleGlow = Default.ScaleGlow;
			}
			break;
		case BT_9:
			if ( Lit )
			{
				Skin = Texture'Button1Tex22';
				ScaleGlow = 3.0;
			}
			else
			{
				Skin = Texture'Button1Tex21';
				ScaleGlow = Default.ScaleGlow;
			}
			break;
		case BT_Blank:
			if ( Lit )
			{
				Skin = Texture'Button1Tex24';
				ScaleGlow = 3.0;
			}
			else
			{
				Skin = Texture'Button1Tex23';
				ScaleGlow = Default.ScaleGlow;
			}
			break;
	}
}

// ----------------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------------

function Trigger( Actor Other, Pawn Instigator )
{
	if ( bWaitForEvent )
		Timer();
}

// ----------------------------------------------------------------------------
// Timer()
// ----------------------------------------------------------------------------

function Timer()
{
	PlaySound( ButtonSound2, SLOT_None );
	SetSkin( ButtonType, bLit );
	bPressed = False;
}

// ----------------------------------------------------------------------------
// Frob()
// ----------------------------------------------------------------------------

function Frob( Actor Frobber, Inventory FrobWith )
{
	if ( !bPressed )
	{
		bPressed = True;
		PlaySound( ButtonSound1, SLOT_None );
		SetSkin( ButtonType, !bLit );
		if ( !bWaitForEvent )
			SetTimer( ButtonLitTime, False );

		Super.Frob( Frobber, FrobWith );
	}
}

// ----------------------------------------------------------------------------
// SupportActor()
// ----------------------------------------------------------------------------

singular function SupportActor( Actor StandingActor )
{
	// Do nothing.
}

// ----------------------------------------------------------------------------
// Bump()
// ----------------------------------------------------------------------------

function Bump( Actor Other )
{
	// Do nothing.
}

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

simulated function Tick( float DeltaTime )
{						  	
	/*if ( Level.NetMode!=NM_Standalone )
	{
		if ( Role==ROLE_Authority )
		{
			// Was moving, now at rest.
			if ( bIsMoving && Location==LastLoc )
				RPCLocation = Location;

			bIsMoving = Location!=LastLoc;
			LastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest.
			if ( LastLoc!=RPCLocation )
			{
				SetLocation( RPCLocation );
				LastLoc = RPCLocation;
			}
		}
	}*/

	Super.Tick( DeltaTime );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ButtonType=BT_Blank
	ButtonLitTime=0.5
	ButtonSound1=Beep1
	bInvincible=True
	ItemName="Button"
	bPushable=False
	Physics=PHYS_None
	RemoteRole=ROLE_SimulatedProxy
	Mesh=Button1
	CollisionRadius=2.00
	//CollisionHeight=2.00
	CollisionHeight=1.25
	bCollideWorld=False
	bBlockActors=False
	Mass=5.0
	Buoyancy=2.0
}
