//=============================================================================
// HXCageLight.
//=============================================================================
class HXCageLight extends HXDecoration;

enum ESkinColor
{
	SC_1,
	SC_2,
	SC_3,
	SC_4,
	SC_5,
	SC_6
};

var() ESkinColor SkinColor;
var() bool bOn;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local CageLight OtherCageLight;

	// Call Super.
	Super.Succeeds( Other );

	// Special CageLight Init.
	OtherCageLight = CageLight(Other);
	if ( OtherCageLight!=None )
	{
		SetPropertyText("SkinColor", OtherCageLight.GetPropertyText("SkinColor") );
		bOn = OtherCageLight.bOn;
	}
}

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_1: Skin = Texture'CageLightTex1'; break;
			case SC_2: Skin = Texture'CageLightTex2'; break;
			case SC_3: Skin = Texture'CageLightTex3'; break;
			case SC_4: Skin = Texture'CageLightTex4'; break;
			case SC_5: Skin = Texture'CageLightTex5'; break;
			case SC_6: Skin = Texture'CageLightTex6'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------------

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		if ( !bOn )
			LightType = LT_None;
	}
}

function Trigger(Actor Other, Pawn Instigator)
{
	Super.Trigger(Other, Instigator);

	if (!bOn)
	{
		bOn = True;
		LightType = LT_Steady;
		bUnlit = True;
		ScaleGlow = 2.0;
	}
	else
	{
		bOn = False;
		LightType = LT_None;
		bUnlit = False;
		ScaleGlow = 1.0;
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bOn=True
	HitPoints=5
	bInvincible=True
	FragType=GlassFragment
	bHighlight=False
	bClientHighlight=False
	bCanBeBase=True
	ItemName="Light Fixture"
	bPushable=False
	Physics=PHYS_None
	Mesh=CageLight
	Skin=CageLightTex1
	ScaleGlow=2.0
	CollisionRadius=17.14
	//CollisionHeight=17.14
	CollisionHeight=16.39
	LightType=LT_Steady
	LightBrightness=255
	LightHue=32
	LightSaturation=224
	LightRadius=8
	Mass=20.0
	Buoyancy=10.0
}
