//=============================================================================
// HXCameraPointDummy.
//=============================================================================
class HXCameraPointDummy extends HXInfo
	transient;

var Rotator	ViewRotation;
var float		FOVAngle;

// Info of currently running point with highest number
//var int		TopSequenceNum;
//var float	TopTimeOffset;
//var float LastTopUpdateTime;

//var int TicksSinceUpdate;

var float		StartTimeSeconds;
var vector	StartLocation;
var rotator StartViewRotation;

var float		TickedSeconds;

// ----------------------------------------------------------------------
// Spawned()
//
// Update the non local players Location, ViewRotation and FOV depending
// on the camera approximation to help replication.
// ----------------------------------------------------------------------

event Spawned()
{
	Log( Self $ ".Spawned()", 'CameraPoint' );

	StartTimeSeconds	= Level.TimeSeconds;
	StartLocation			= Location;
	StartViewRotation = ViewRotation;

	TickedSeconds = 0.0;
}

// ----------------------------------------------------------------------
// Tick()
//
// Update the non local players Location, ViewRotation and FOV depending
// on the camera approximation to help replication.
// ----------------------------------------------------------------------

event Tick( float DeltaTime )
{
	local PlayerPawn Player, LocalPlayer;
	local Pawn P;

	LocalPlayer = GetPlayerPawn();
	
	for( P = Level.PawnList; P != None; P = P.nextPawn )
	{
		if( P.bIsPlayer )
		{
			Player = PlayerPawn(P);

			//if ( Player != None && Player != LocalPlayer )
			if ( Player != None )
			{
				UpdatePlayer( Player );
			}
		}
	}

	TickedSeconds += DeltaTime;
}

// ----------------------------------------------------------------------
// UpdatePlayer()
// ----------------------------------------------------------------------

function UpdatePlayer( PlayerPawn Player )
{
	if ( Player.GetStateName() != 'Paralyzed' )
		Player.GotoState( 'Paralyzed', 'LetterBox' );

	//Player.SetCollision( false, false, false );
	Player.BaseEyeHeight = 0.0;
	Player.bHidden = True;

	Player.SetLocation( Location );
	Player.SetFOVAngle( FOVAngle );

	Player.ViewRotation = ViewRotation;
	Player.DesiredFOV = FOVAngle;

	// 50uu ~ 1m
	//Player.RelevantRadius = 800;

	//if (Player.Shadow != None)
	//{
		//Player.Shadow.Destroy();
		//Player.Shadow = None;
	//}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	FovAngle=75.000000
	Physics=PHYS_None
	bHidden=True
	bCollideActors=False
	bCollideWorld=False
	bBlockActors=False
	bBlockPlayers=False
	RemoteRole=ROLE_None
}
