//=============================================================================
// HXCampaignMutator.
//=============================================================================
class HXCampaignMutator extends HXMutator;

// ----------------------------------------------------------------------------
// PreSetupActors()
//
// Apply script side fixes to original Actors inside Maps before they have
// a chance of getting replaced by Mutator logic.
// ----------------------------------------------------------------------------

function bool PreSetupActors( Actor Actor, Name MapName, out byte bSuperRelevant )
{
	// Implemented by subclasses.

	return true;
}

// ----------------------------------------------------------------------------
// SpawnAdditionalActors()
//
// Called during PreBeginPlay() on the first visit of the map.
// ----------------------------------------------------------------------------

function SpawnAdditionalActors( Name MapName )
{
	// Implemented by subclasses.
}

// ----------------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------------

event PreBeginPlay()
{
	Super.PreBeginPlay();

	//
	// PreBeginPlay is called twice -- mask the first execution.
	//
	// The first time it is called during Spawn inside InitGame, which is before
	// the Mutator chain is completely spawned, so we want to ignore this call.
	// The second it is ran during the full PreBeginPlay loop for all actors,
	// in which case the Mutator chain is completed and we can happily use it to
	// spawn mutatated copies of Actors.
	//
	if ( !bSpawning )
	{
		// Awkward. Do a little better than using bShowStartupMessage, or at least rename it to like bFirstTime. 
		if ( Game.bShowStartupMessage )
		{
			Log( "CampaignMutator spawning additional Actors.", 'DevMutator' );

			SpawnAdditionalActors( Level.Outer.Name );
		}
	}
}

// ----------------------------------------------------------------------------
// CheckReplacement()
// ----------------------------------------------------------------------------

function bool CheckReplacement( Actor Other, out byte bSuperRelevant )
{
	// Only do this on startup.
	if ( Level.bStartup )
	{
		// Fixup stuff for campaign maps which can be done by script on a per Actor basis.
		return PreSetupActors( Other, Level.Outer.Name, bSuperRelevant );
	}
	return true;
}

// ----------------------------------------------------------------------------
// SpawnModifiedActor()
// ----------------------------------------------------------------------------

function Actor SpawnModifiedActor( class<Actor> SpawnClass, Actor SpawnOwner, Name SpawnTag, Vector SpawnLocation, Rotator SpawnRotation, bool bSpawnNoCollisionFail )
{
	Game.ModifyActorClass( SpawnClass );
	return SpawnEx( SpawnClass, SpawnOwner, SpawnTag, SpawnLocation, SpawnRotation, bSpawnNoCollisionFail );
}

// ----------------------------------------------------------------------------
// SpawnModifiedInventory()
// ----------------------------------------------------------------------------

function Inventory SpawnModifiedInventory( class<Inventory> SpawnClass, Actor SpawnOwner, Name SpawnTag, Vector SpawnLocation, Rotator SpawnRotation, bool bSpawnNoCollisionFail )
{
	Game.ModifyInventoryClass( SpawnClass );
	return Inventory(SpawnEx( SpawnClass, SpawnOwner, SpawnTag, SpawnLocation, SpawnRotation, bSpawnNoCollisionFail ));
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bSpawning=True
}
