//=============================================================================
// HXCarBurned.
//=============================================================================
class HXCarBurned extends HXOutdoorThings;

enum ESkinColor
{
	SC_Yellow,
	SC_DarkBlue
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_Yellow:   Skin = Texture'CarBurnedTex1'; break;
			case SC_DarkBlue: Skin = Texture'CarBurnedTex2'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ItemName="Burned Car"
	bCanBeBase=True
	Mesh=CarBurned
	CollisionRadius=101.65
	//CollisionHeight=29.43
	CollisionHeight=28.68
	Mass=2000.0
	Buoyancy=1500.0
}
