//=============================================================================
// HXCarStripped.
//=============================================================================
class HXCarStripped extends HXOutdoorThings;

enum ESkinColor
{
	SC_LightBlue,
	SC_DarkBlue,
	SC_Gray,
	SC_Black
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_LightBlue: Skin = Texture'CarStrippedTex1'; break;
			case SC_DarkBlue:  Skin = Texture'CarStrippedTex2'; break;
			case SC_Gray:      Skin = Texture'CarStrippedTex3'; break;
			case SC_Black:     Skin = Texture'CarStrippedTex4'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local CarStripped OtherCarStripped;

	// Call Super.
	Super.Succeeds( Other );

	// Special CarStripped Init.
	OtherCarStripped = CarStripped(Other);
	if ( OtherCarStripped!=None )
	{
		SetPropertyText( "SkinColor", OtherCarStripped.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	FragType=MetalFragment
	ItemName="Stripped Car"
	bCanBeBase=True
	Mesh=CarStripped
	Skin=CarStrippedTex1
	CollisionRadius=115.00
	//CollisionHeight=23.86
	CollisionHeight=23.11
	Mass=2000.0
	Buoyancy=1500.0
}
