//=============================================================================
// HXCarcass.
//
// TODO:
//  - Make flies clientside only.
//=============================================================================
class HXCarcass extends Carcass
	abstract;

var transient HXGameInfo Game;
var Name PrecessorName;
var bool bSpawning;

struct InventoryItemCarcass
{
	var() class<Inventory> Inventory;
	var() int              Count;
};

var(Display) Mesh Mesh2;		// mesh for secondary carcass
var(Display) Mesh Mesh3;		// mesh for floating carcass
var(Inventory) InventoryItemCarcass InitialInventory[8];  // Initial inventory items held in the carcass
var() bool bHighlight;

var String			KillerBindName;		// what was the bind name of whoever killed me?
var Name			KillerAlliance;		// what alliance killed me?
var bool			bGenerateFlies;		// should we make flies?
var HXPawnGenerator FlyGenerator;
var Name			Alliance;			// this body's alliance
var Name			CarcassName;		// original name of carcass
var int				MaxDamage;			// maximum amount of cumulative damage
var bool			bNotDead;			// this body is just unconscious
var() bool			bEmitCarcass;		// make other NPCs aware of this body

var bool			bInit;

// Used for Received Items window
var bool bSearchMsgPrinted;

var localized string MsgSearching;
var localized string MsgEmpty;
var localized string MsgNotDead;
var localized string MsgAnimalCarcass;
var localized string MsgCannotPickup;
var localized String MsgRecharged;

var localized string ItemName;			// human readable name

var() bool bInvincible;
var bool bAnimalCarcass;

// New HXCarcass.
var localized String TooMuchAmmo;

struct ReceivedItemMessageLine
{
	var class<Inventory> Item;
	var int							 Count;
};
struct ReceivedItemMessage
{
	var HXPlayerPawn Player;
	var int LineCount;
	// This is two more then player inventory slots.
	var ReceivedItemMessageLine Line[32];
};
var ReceivedItemMessage PendingMessage;

// ----------------------------------------------------------------------------
// Network replication.
// ----------------------------------------------------------------------------

replication
{
	reliable if ( Role==ROLE_Authority )
		ItemName;
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Carcass OtherCarcass;
	local DeusExCarcass OtherDeusExCarcass;
	local int iInitialInventory;

	// Save Precessors name aside for debugging purposes.
	PrecessorName        = Other.Name;

	// Collision and Blocking.
	bCollideWhenPlacing = Other.bCollideWhenPlacing; // Still used for far moving after spawn.
	bCollideWorld       = Other.bCollideWorld;

	SetCollisionSize( Other.CollisionRadius, Other.CollisionHeight );
	SetCollision( Other.bCollideActors, Other.bBlockActors, Other.bBlockPlayers );

// Advanced.
//bStatic              = Other.bStatic;             // Nope. Defined by defaultproperties.
	bHidden              = Other.bHidden;

	// Events. 
	Event                = Other.Event;
//Tag                  = Other.Tag;   // Set by Spawn.

	// Object (partial).
	Group                = Other.Group;

	// Advanced (partial).
	bOwned               = Other.bOwned;

	// Make sure old Actor has Tag, Event, Group, BindName and BarkBindName removed.
	Other.Tag            = '';
	Other.Event          = '';
	Other.Group          = '';
	Other.BindName       = "";
	Other.BarkBindName   = "";

	// Special Carcass Init.
	OtherCarcass = Carcass(Other);
	if ( OtherCarcass!=None )
	{
		// Carcass.

		// Special DeusExCarcass Init.
		OtherDeusExCarcass = DeusExCarcass(Other);
		if ( OtherDeusExCarcass!=None )
		{
			// DeusExCarcass (partial)
			ItemName = OtherDeusExCarcass.ItemName;

			// Copy InitialInventory.
			for ( iInitialInventory=0; iInitialInventory<ArrayCount(InitialInventory); iInitialInventory++ )
			{
				InitialInventory[iInitialInventory].Inventory = OtherDeusExCarcass.InitialInventory[iInitialInventory].Inventory;
				InitialInventory[iInitialInventory].Count			= OtherDeusExCarcass.InitialInventory[iInitialInventory].Count;
			}

			// Mesh pose quirk.
			if ( OtherDeusExCarcass.Mesh==OtherDeusExCarcass.default.Mesh2 )
				Mesh = Mesh2;
			else if ( OtherDeusExCarcass.Mesh==OtherDeusExCarcass.default.Mesh3 )
				Mesh = Mesh3;
		}
	}
}

// ----------------------------------------------------------------------------
// IsInRelevant()
// 
// Whether code is currently running during a spawn inside a mutator in which
// case the properties are not yet properly set.
// ----------------------------------------------------------------------------

simulated function bool IsInRelevant()
{
	if ( Level.Game==None ) // Will happen on client too.
		return false;
	return Level.Game.IsInState( 'InIsRelevant' );
}

// ----------------------------------------------------------------------------
// Spawned()
// ----------------------------------------------------------------------------

simulated event Spawned()
{
	Super.Spawned();

	if ( Level.bStartup )
		bGameRelevant = true;

	Game = HXGameInfo(Level.Game);
}

// ----------------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------------

function PreBeginPlay()
{
	local int iInitialInventory;

	if ( bDeleteMe || IsInRelevant() )
		return;

	// Handle autodestruction if desired. Moved this here because the
	// config properties won't have their correct value set when spawned inside
	// the mutator, so you can't replace them at first pass there.
	if ( !bGameRelevant && Level.NetMode!=NM_Client && !Level.Game.IsRelevant(Self) )
	{
		Destroy();
		return;
	}

	if ( Level.NetMode!=NM_Client )
	{
		// Enforce HX classes?
		for ( iInitialInventory=0; iInitialInventory<ArrayCount(InitialInventory); iInitialInventory++ )
			if ( InitialInventory[iInitialInventory].Inventory!=None )
				Game.ModifyInventoryClass( InitialInventory[iInitialInventory].Inventory );
	}
}

// ----------------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------------

function PostBeginPlay()
{
	// Bail out if alreadys destroyed (e.g. replaced by a mutator).
	if ( bDeleteMe )
		return;

	// Code running inside mutator. Hence config properties are not yet valid.
	if ( IsInRelevant() )
		return;

	bCollideWorld = true;

	// Use the carcass name by default
	CarcassName = Name;

	// Add initial inventory items
	InitializeInventory();

	// use the correct mesh
	if ( Region.Zone.bWaterZone )
	{
		Mesh = Mesh3;
		bNotDead = false;		// you will die in water every time
	}

	if (bAnimalCarcass)
		itemName = MsgAnimalCarcass;

	MaxDamage = 0.8*Mass;
	SetScaleGlow();

	SetTimer( 30.0, false );

	Super.PostBeginPlay();
}

// ----------------------------------------------------------------------------
// SetInitialState()
//
// Called after PostBeginPlay.
// ----------------------------------------------------------------------------

simulated event SetInitialState()
{
	if ( bDeleteMe || IsInRelevant() )
		return;

	if ( InitialState!='' )
		GotoState( InitialState );
	else
		GotoState( 'Auto' );

	bSpawning = false;
}

// ----------------------------------------------------------------------------
// PostPostBeginPlay()
// ----------------------------------------------------------------------------

simulated event PostPostBeginPlay()
{
	// This may need to be reset, as a new GameInfo is spawned each time.
	Game = HXGameInfo(Level.Game);

	Super.PostPostBeginPlay();
}

// ----------------------------------------------------------------------------
// FellOutOfWorld()
// ----------------------------------------------------------------------------

event FellOutOfWorld()
{
	if ( PrecessorName!='' )
	{
		Log( Sprintf("Precessor of falling out of world %s was %s.",Name,PrecessorName), 'FellOutOfWorld' );
	}

	SetPhysics( PHYS_None );
	Destroy();
}	

// ----------------------------------------------------------------------------
// Destroyed()
// ----------------------------------------------------------------------------

function Destroyed()
{
	if (FlyGenerator != None)
	{
		FlyGenerator.StopGenerator();
		FlyGenerator = None;
	}
	Super.Destroyed();
}

// ----------------------------------------------------------------------------
// InitFor()
// ----------------------------------------------------------------------------

function InitFor( Actor Other )
{
	if ( Other!=None )
	{
		// Copy DrawScale. This is needed to be able to use same Carcass class for the NPC and Player Class
		// which may disaggree about DrawScale.
		DrawScale = Other.DrawScale;

		// set as unconscious or add the pawns name to the description
		if (!bAnimalCarcass)
		{
			if (bNotDead)
			{
				itemName = MsgNotDead;
			}
			else if (Other.IsA('PlayerPawn'))
			{
				if ( PlayerPawn(Other).PlayerReplicationInfo != None )
				{
					itemName = itemName $ " (" $ PlayerPawn(Other).PlayerReplicationInfo.PlayerName $ ")";
				}
			}
			else if (Other.IsA('HXScriptedPawn'))
			{
				itemName = itemName $ " (" $ HXScriptedPawn(Other).FamiliarName $ ")";
			}
		}

		Mass           = Other.Mass;
		Buoyancy       = Mass * 1.2;
		MaxDamage      = 0.8*Mass;
		if (HXScriptedPawn(Other) != None)
			if (HXScriptedPawn(Other).bBurnedToDeath)
				CumulativeDamage = MaxDamage-1;

		SetScaleGlow();

		// Will this carcass spawn flies?
		if (bAnimalCarcass)
		{
			itemName = MsgAnimalCarcass;
			if (FRand() < 0.2)
				bGenerateFlies = true;
		}
		// Uhm, are there actually any robot carcasses?
		else if ( !(Other.IsA('HXScriptedPawn') && HXScriptedPawn(Other).bIsRobot) && !bNotDead )
		{
			if (FRand() < 0.1)
				bGenerateFlies = true;
			bEmitCarcass = true;
		}

		if (Other.AnimSequence == 'DeathFront')
			Mesh = Mesh2;

		//
		// Set the instigator and tag information.
		//
		// Instigator is set to Self in PreBeginPlay for Pawns, but this shouldn't trigger alliance
		// conflicts (e.g. when suiciding).
		//
		if ( Other.Instigator!=None && Other.Instigator!=Other )
		{
			KillerBindName = Other.Instigator.BindName;
			KillerAlliance = Other.Instigator.Alliance;
		}
		else
		{
			KillerBindName = Other.BindName;
			KillerAlliance = '';
		}
		Tag = Other.Tag;
		Alliance = Pawn(Other).Alliance;
		CarcassName = Other.Name;
	}
}

// ----------------------------------------------------------------------------
// InitializeInventory()
//
// Add initial inventory items
// ----------------------------------------------------------------------------

function InitializeInventory()
{
	local int i, j;
	local Inventory inv;
	local HXWeapon WeaponInv;

	for ( i=0; i < 8; i++ )
	{
		if ( InitialInventory[i].inventory != None && InitialInventory[i].count > 0 )
		{
			// Ammo was prevented from beeing picked up. Just the random weapon ammo amount was allowed.
			if ( ClassIsChildOf( InitialInventory[i].Inventory, class'Ammo' ) )
			{
				// do nothing
				continue;
			}
			else
			{
				// make sure it mimicks the DeusEx behavior of having multiple weapons of the same type
				for (j=0; j<InitialInventory[i].count; j++)
				{
					inv = spawn(InitialInventory[i].inventory, self);

					WeaponInv = HXWeapon(Inv);

					if ( WeaponInv!=None )
					{
						// Grenades and LAMs always pickup 1
						if ( WeaponInv.bIsGrenade )
						{
							WeaponInv.PickupAmmoCount = 1;
						}
						// Any weapons have their ammo set to a random number of rounds (1-4)
						else
						{
							WeaponInv.PickupAmmoCount = Rand(4) + 1;
						}
					}

					if (inv != None)
					{
						inv.bHidden = True;
						inv.SetPhysics(PHYS_None);
						AddInventory(inv);
					}
				}
			}
		}
	}
}

// ----------------------------------------------------------------------------
// ZoneChange()
// ----------------------------------------------------------------------------

function ZoneChange(ZoneInfo NewZone)
{
	Super.ZoneChange(NewZone);

	// use the correct mesh for water
	if (NewZone.bWaterZone)
		Mesh = Mesh3;
}

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

function Tick(float deltaSeconds)
{
	if (!bInit)
	{
		bInit = true;
		if (bEmitCarcass)
			AIStartEvent('Carcass', EAITYPE_Visual);
	}
	Super.Tick(deltaSeconds);
}

// ----------------------------------------------------------------------------
// Timer()
// ----------------------------------------------------------------------------

function Timer()
{
	local class<Actor> FlyGeneratorClass;

	if ( Level.NetMode!=NM_Client && bGenerateFlies && FlyGenerator==None )
	{
		FlyGeneratorClass = class'FlyGenerator';
		Game.ModifyActorClass( FlyGeneratorClass );

		FlyGenerator = Spawn(class<HXPawnGenerator>(FlyGeneratorClass), , , Location, Rotation);
		if ( FlyGenerator!=None )
			FlyGenerator.SetBase( Self );
	}
}

// ----------------------------------------------------------------------------
// ChunkUp()
// ----------------------------------------------------------------------------

function ChunkUp(int Damage)
{
	local int i;
	local float size;
	local Vector loc;
	local FleshFragment chunk;

	// gib the carcass
	size = (CollisionRadius + CollisionHeight) / 2;
	if (size > 10.0)
	{
		for (i=0; i<size/4.0; i++)
		{
			loc.X = (1-2*FRand()) * CollisionRadius;
			loc.Y = (1-2*FRand()) * CollisionRadius;
			loc.Z = (1-2*FRand()) * CollisionHeight;
			loc += Location;
			chunk = spawn(class'FleshFragment', None,, loc);
			if (chunk != None)
			{
				chunk.DrawScale = size / 25;
				chunk.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
				chunk.bFixedRotationDir = True;
				chunk.RotationRate = RotRand(False);
			}
		}
	}
	Destroy();
}

// ----------------------------------------------------------------------------
// TakeDamage()
// ----------------------------------------------------------------------------

function TakeDamage(int Damage, Pawn instigatedBy, Vector hitLocation, Vector momentum, name damageType)
{
	local int i;

	if (bInvincible)
		return;

	// only take "gib" damage from these damage types
	if ((damageType == 'Shot') || (damageType == 'AutoShot') || (damageType == 'Sabot') || (damageType == 'Exploded') || (damageType == 'Munch') || (damageType == 'Tantalus'))
	{
		if ((damageType != 'Munch') && (damageType != 'Tantalus'))
		{
         //if ((Game != None) && (!Game.bSpawnEffects))
         //{
         //}
         //else
         //{
            spawn(class'BloodSpurt',,,HitLocation);
            spawn(class'BloodDrop',,, HitLocation);
            for (i=0; i<Damage; i+=10)
               spawn(class'BloodDrop',,, HitLocation);
         //}
		}

		// this section copied from Carcass::TakeDamage() and modified a little
		if (!bDecorative)
		{
			bBobbing = false;
			SetPhysics(PHYS_Falling);
		}
		if ((Physics == PHYS_None) && (Momentum.Z < 0))
			Momentum.Z *= -1;
		Velocity += 3 * momentum/(Mass + 200);
		if (DamageType == 'Shot')
			Damage *= 0.4;
		CumulativeDamage += Damage;
		if (CumulativeDamage >= MaxDamage)
			ChunkUp(Damage);
		if (bDecorative)
			Velocity = vect(0,0,0);
	}

	SetScaleGlow();
}

// ----------------------------------------------------------------------------
// SetScaleGlow()
//
// sets the scale glow for the carcass, based on damage
// ----------------------------------------------------------------------------

function SetScaleGlow()
{
	local float pct;

	// scaleglow based on damage
	pct = FClamp(1.0-float(CumulativeDamage)/MaxDamage, 0.1, 1.0);
	ScaleGlow = pct;
}

// ----------------------------------------------------------------------------
// Frob()
//
// search the body for inventory items and give them to the frobber
// ----------------------------------------------------------------------------

function Frob(Actor Frobber, Inventory frobWith)
{
	local Inventory item, nextItem, startItem;
	local HXWeapon W;
	local HXPickup P;
	local bool bFoundSomething;
	local HXPlayerPawn Player;
	local ammo AmmoType;
	local bool bPickedItemUp;
	local POVCorpse corpse;
	//local HXPickup invItem;
	local int itemCount;

	local int TmpX, TmpY;
	local bool bCanPickup;

//log("HXCarcass::Frob()--------------------------------");

	// Just to be on the safe side. --han
	if ( bDeleteMe )
		return;

	// Can we assume only the *PLAYER* would actually be frobbing carci?
	Player = HXPlayerPawn(Frobber);

/*
	// if we've already been searched, let the player pick us up
	// don't pick up animal carcii
	if (!bAnimalCarcass)
	{
      // DEUS_EX AMSD Since we don't have animations for carrying corpses, and since it has no real use in multiplayer,
      // and since the PutInHand propagation doesn't just work, this is work we don't need to do.
      // Were you to do it, you'd need to check the respawning issue, destroy the POVcorpse it creates and point to the
      // one in inventory (like I did when giving the player starting inventory).
		if ((Inventory == None) && (player != None) && (player.inHand == None) && (Level.NetMode == NM_Standalone))
		{
			if (!bInvincible)
			{
				corpse = Spawn(class'POVCorpse');
				if (corpse != None)
				{
					// destroy the actual carcass and put the fake one
					// in the player's hands
					corpse.carcClassString = String(Class);
					corpse.KillerAlliance = KillerAlliance;
					corpse.KillerBindName = KillerBindName;
					corpse.Alliance = Alliance;
					corpse.bNotDead = bNotDead;
					corpse.bEmitCarcass = bEmitCarcass;
					corpse.CumulativeDamage = CumulativeDamage;
					corpse.MaxDamage = MaxDamage;
					corpse.CorpseItemName = itemName;
					corpse.CarcassName = CarcassName;
					corpse.Frob(player, None);
					corpse.SetBase(player);
					player.PutInHand(corpse);
					Destroy();
					return;
				}
			}
		}
	}
*/

	bFoundSomething = False;
	bSearchMsgPrinted = False;

	if (Player != None)
	{
		ReceivedItemMessageInit( Player );

		if (Inventory != None)
		{

			//item = Inventory;
			//startItem = item;
			//
			//do
			//{
				//Log("===>HXCarcass:item="$item );

				//nextItem = item.Inventory;
				//item = nextItem;
			//}
			//until ((item == None) || (item == startItem));

			item = Inventory;
			startItem = item;

			do
			{
				//Log("===>HXCarcass:item="$item );

				nextItem = item.Inventory;

				bPickedItemUp = False;

				if (item != None)
				{
					bFoundSomething = True;

					// NanoKeys
					if (item.IsA('HXNanoKey'))
					{
						if (player != None)
						{
							//player.PickupNanoKey(HXNanoKey(item));
							// just display if we do not already have the key
							if ( Game.PickupNanoKey(HXNanoKey(item)) )
								ReceivedItemMessageAddItem( item, 1 );

							DeleteInventory(item);

							item.Destroy();
							item = None;
						}
						bPickedItemUp = True;
					}

					// Credits
					else if (item.IsA('HXCredits'))		// I hate special cases
					{
						if (player != None)
						{
							// HX_INV: maybe call GiveTo() here
							ReceivedItemMessageAddItem( item, HXCredits(item).numCredits );
							Player.Credits += HXCredits(item).numCredits;
							Player.ClientMessage(Sprintf(HXCredits(item).MsgCreditsAdded, HXCredits(item).numCredits));
							DeleteInventory(item);

							item.Destroy();
							item = None;
						}
						bPickedItemUp = True;
					}

					// Ammo
					else if ( Item.IsA('HXAmmo') )
					{
						// Check if we have enough room for ammo
						AmmoType = Ammo( Player.FindInventoryType( item.Class ) );

						// Player has this AmmoType, but is not at max
						if ( AmmoType == None || AmmoType.AmmoAmount < AmmoType.MaxAmmo ) // !! Could keep additional ammo.
						{
							ReceivedItemMessageAddItem( AmmoType, 1 ); // !! This is a bug, but using Item is even worse.

							// if this is an illegal ammo type, use the weapon name to print the message
							//if ( AmmoType == None || AmmoType.PickupViewMesh == Mesh'TestBox' )
								//Player.ClientMessage( item.PickupMessage @ item.itemArticle @ item.itemName, 'Pickup' );
							//else
								//Player.ClientMessage( AmmoType.PickupMessage @ AmmoType.itemArticle @ AmmoType.itemName, 'Pickup' );

							// Now pick it up
							DeleteInventory( item );

							GivePlayerInventory( Player, item );
							item = None;

							bPickedItemUp = True;

							//Player.UpdateAmmoBeltText(AmmoType);				
						}
						else
						{
							Player.ClientMessage( TooMuchAmmo @ item.itemName );
						}
					}

					// Weapons
					else if ( item.IsA('HXWeapon') )   // I *really* hate special cases
					{
						W = HXWeapon( Player.FindInventoryType(item.Class) );

						// Check if the player already has the weapon
						if ( W != None )
						{
							// Check for single use weapons
							//bCanPickup = ! ( W.ReloadCount == 0 && 
															 //W.PickupAmmoCount == 0 && 
															 //W.AmmoName != None );

							// This is a single-use weapon, prevent the player from picking up
							if ( W.ReloadCount == 0 )
							{
								Player.ClientMessage( Sprintf( Player.CanCarryOnlyOne, item.itemName ) );		
							}
							// Non single use weapon
							else
							{
								// HX_INV: Let the weapon handle the pickup of ammo and mods
								//				 and display the ClientMessage, just check if we will add ammo
								//				 to update the received items display
								AmmoType = Ammo( Player.FindInventoryType( Weapon(item).AmmoName ) );

								// PickupAmmoCount was actually never displayed
								// TODO: maybe add an display for installed weapon mods
								if ( AmmoType != None && AmmoType.AmmoAmount < AmmoType.MaxAmmo )
								{
									//ReceivedItemMessageAddItem( AmmoType, Weapon(item).PickupAmmoCount );
									ReceivedItemMessageAddItem( AmmoType, 1 );

									// if this is an illegal ammo type, use the weapon name to print the message
									//if (AmmoType.PickupViewMesh == Mesh'TestBox')
										//Player.ClientMessage( item.PickupMessage @ item.itemArticle @ item.itemName, 'Pickup' );
									//else
										//Player.ClientMessage( AmmoType.PickupMessage @ AmmoType.itemArticle @ AmmoType.itemName, 'Pickup' );
								}

								// Now pick it up
								DeleteInventory( item );

								GivePlayerInventory( Player, item );
								item = None;

								//Player.UpdateAmmoBeltText(AmmoType);
							}
						}
						else
						{
							// Player has enough inventory space, so pick it up
							if ( Player.FindInventorySpace( item.invSlotsX, item.invSlotsY, TmpX, TmpY ) )
							{
								ReceivedItemMessageAddItem( item, 1 );
								
								//Player.ClientMessage(Item.PickupMessage @ Item.itemArticle @ Item.itemName, 'Pickup');
								//PlaySound(Item.PickupSound);
								
								// Now pick it up
								DeleteInventory( item );

								GivePlayerInventory( Player, item );
								item = None;
							}
							// Not enough room
							else
							{
								Player.ClientMessage( Sprintf( Player.InventoryFull, item.itemName ) );							
							}
						}
					}

					// Pickups
					else if ( item.IsA('HXPickup') )
					{
						P = HXPickup( Player.FindInventoryType( item.Class ) );

						// We can't have multiple copies or we don't have the item yet
						if ( !HXPickup(item).bCanHaveMultipleCopies || P == None )
						{
							// Player has enough inventory space, so pick it up
							if ( Player.FindInventorySpace( item.invSlotsX, item.invSlotsY, TmpX, TmpY ) )
							{
								ReceivedItemMessageAddItem( item, HXPickup(item).NumCopies );
								
								//Player.ClientMessage(Item.PickupMessage @ Item.itemArticle @ Item.itemName, 'Pickup');
								//PlaySound(Item.PickupSound);
								
								// Now pick it up
								DeleteInventory( item );

								GivePlayerInventory( Player, item );
								item = None;
							}
							// Not enough room
							else
							{
								Player.ClientMessage( Sprintf( Player.InventoryFull, item.itemName ) );
							}

						}
						// Multiple copies player has type of Pickup already
						else
						{
							// Check if Player has not MaxCopies
							if ( P.MaxCopies > 0 && P.NumCopies < P.MaxCopies )
							{
								// Player has enough room so add all copies
								if ( HXPickup(item).NumCopies <= ( P.MaxCopies - P.NumCopies ) )
								{
									ReceivedItemMessageAddItem( item, HXPickup(item).NumCopies );
									//Player.ClientMessage( P.PickupMessage @ invItem.itemArticle @ P.itemName, 'Pickup' );

									// Now pick it up
									DeleteInventory( item );

									GivePlayerInventory( Player, item );
									item = None;
								}
								// Just add the amount of copies the player can pick up
								else
								{
									ReceivedItemMessageAddItem( P, P.MaxCopies - P.NumCopies );
									Player.ClientMessage(P.PickupMessage @ P.itemArticle @ P.itemName $ ".", 'Pickup');

									HXPickup(item).NumCopies -= P.MaxCopies - P.NumCopies;
									P.NumCopies = P.MaxCopies;
								}
							}
							else
							{
								Player.ClientMessage(Sprintf(MsgCannotPickup, P.itemName));
							}
						}
					}
					else
					{
						Player.ClientMessage(Sprintf("Unhandled CarcassInventory %s", item.itemName));
					}
				}

				item = nextItem;
			}
			until ((item == None) || (item == startItem));
		}

		if ( !bFoundSomething )
			Player.ClientMessage(MsgEmpty);

		ReceivedItemMessageSend();
	}

	Super.Frob(Frobber, frobWith);
}


// ----------------------------------------------------------------------------
// ReceivedItemMessageInit()
// ----------------------------------------------------------------------------

function ReceivedItemMessageInit( HXPlayerPawn Player )
{
	PendingMessage.Player			= Player;
	PendingMessage.LineCount	= 0;
}

// ----------------------------------------------------------------------------
// ReceivedItemMessageAddItem()
// ----------------------------------------------------------------------------

function ReceivedItemMessageAddItem( Inventory Item, int Count )
{
	local int i;

	// BARF
	if ( !bSearchMsgPrinted )
	{
		PendingMessage.Player.ClientMessage( MsgSearching );
		bSearchMsgPrinted = True;
	}

	// Make sure the object belt is updated
	// This will not work right for mp! FIX_ME
	//if ( item.IsA('Ammo') )
		//PendingMessage.Player.UpdateAmmoBeltText(Ammo(item));
	//else
		//PendingMessage.Player.UpdateBeltText(item);

	// Sanity checks
	if ( PendingMessage.LineCount >= ArrayCount(PendingMessage.Line) )
	{
		Log( Self $ ".ReceivedItemMessageAddItem( " $ Item $ ", " $ count $ " ) Buffer overflowed... skipping.." );
		return;
	}
	else if ( Item == None || count < 1 )
	{
		Log( Self $ ".ReceivedItemMessageAddItem( " $ Item $ ", " $ count $ " ) Invalid." );
		return;
	}

	// If it ever happens that a carcass has multiple NanoKeys, show each one
	if ( Item != class'HXNanoKey' )
	{
		// Search pending first
		for ( i = 0; i < PendingMessage.LineCount; i++ )
		{
			if ( PendingMessage.Line[i].Item == Item.Class )
			{
				PendingMessage.Line[i].Count += Count;
				return;
			}
		}
	}

	// No pending, so add a new line
	PendingMessage.Line[PendingMessage.LineCount].Item	= Item.Class;
	PendingMessage.Line[PendingMessage.LineCount].Count	= Count;
	PendingMessage.LineCount++;
}

// ----------------------------------------------------------------------------
// ReceivedItemMessageSend()
// ----------------------------------------------------------------------------

function ReceivedItemMessageSend()
{
	local int i;
	local bool bClear;

	// If nothing was transfered just clear the window
	if ( PendingMessage.LineCount == 0 )
	{
		PendingMessage.Player.ClientAddReceivedItemDisplay( None, 0, True );
		return;
	}

	bClear = True;

	for ( i = 0; i < PendingMessage.LineCount; i++ )
	{
		PendingMessage.Player.ClientAddReceivedItemDisplay( PendingMessage.Line[i].Item, PendingMessage.Line[i].Count, bClear );
		bClear = False;
	}
}

// ----------------------------------------------------------------------------
// GivePlayerInventory()
// ----------------------------------------------------------------------------

function GivePlayerInventory( HXPlayerPawn Player, Inventory Item )
{
	local Actor A;

	// make sure nothing is based on us if we're an inventory
	foreach Item.BasedActors(class'Actor', A)
		A.SetBase(None);

	Item.GotoState('Pickup');
	Item.Frob( Player, None );

	// if the object destroyed itself, get out
	if ( /*Item==None ||*/ Item.bDeleteMe )
		return;

	if ( Level.Game.ShouldRespawn(Item) )
	{
		Item.Destroy();
		return;
	}

	// if the inventory item aborted it's own pickup, get out
	//if ( InvToGive.Owner != Player )
		//return;

	// set the base so the inventory follows us around correctly
	//InvToGive.SetBase(Player);
}

// ----------------------------------------------------------------------------
// AddInventory()
//
// copied from Engine.Pawn
// Add Item to this carcasses inventory. 
// Returns true if successfully added, false if not.
// ----------------------------------------------------------------------------

function bool AddInventory( inventory NewItem )
{
	// Skip if already in the inventory.
	local inventory Inv;

	for( Inv=Inventory; Inv!=None; Inv=Inv.Inventory )
		if( Inv == NewItem )
			return false;

	// The item should not have been destroyed if we get here.
	assert(NewItem!=None);

	// Add to front of inventory chain.
	NewItem.SetOwner(Self);
	NewItem.Inventory = Inventory;
	NewItem.InitialState = 'Idle2';
	Inventory = NewItem;

	return true;
}

// ----------------------------------------------------------------------------
// DeleteInventory()
// 
// copied from Engine.Pawn
// Remove Item from this pawn's inventory, if it exists.
// Returns true if it existed and was deleted, false if it did not exist.
// ----------------------------------------------------------------------------

function bool DeleteInventory( inventory Item )
{
	// If this item is in our inventory chain, unlink it.
	local actor Link;

	for( Link = Self; Link!=None; Link=Link.Inventory )
	{
		if( Link.Inventory == Item )
		{
			Link.Inventory = Item.Inventory;
			break;
		}
	}
	
	if ( Item.Owner == Self )
		Item.SetOwner(None);
}

// ----------------------------------------------------------------------------
// auto state Dead.
// ----------------------------------------------------------------------------

auto state Dead
{
	function Timer()
	{
		// overrides goddamned lifespan crap
      // DEUS_EX AMSD In multiplayer, we want corpses to have lifespans.  
      //if (Level.NetMode == NM_Standalone)		
         Global.Timer();
      //else
         //Super.Timer();
	}

	function HandleLanding()
	{
		local Vector HitLocation, HitNormal, EndTrace;
		local Actor hit;
		local BloodPool pool;

		if (!bNotDead)
		{
			// trace down about 20 feet if we're not in water
			if (!Region.Zone.bWaterZone)
			{
				EndTrace = Location - vect(0,0,320);
				hit = Trace(HitLocation, HitNormal, EndTrace, Location, False);
            if ((Game != None) && (!Game.bSpawnEffects))
            {
               pool = None;
            }
            else
            {
               pool = spawn(class'BloodPool',,, HitLocation+HitNormal, Rotator(HitNormal));
            }
				if (pool != None)
					pool.maxDrawScale = CollisionRadius / 40.0;
			}

			// alert NPCs that I'm food
			AIStartEvent('Food', EAITYPE_Visual);
		}

		// by default, the collision radius is small so there won't be as
		// many problems spawning carcii
		// expand the collision radius back to where it's supposed to be
		// don't change animal carcass collisions
		if (!bAnimalCarcass)
			SetCollisionSize(40.0, Default.CollisionHeight);

		// alert NPCs that I'm really disgusting
		if (bEmitCarcass)
			AIStartEvent('Carcass', EAITYPE_Visual);
	}

Begin:
	while (Physics == PHYS_Falling)
	{
		Sleep(1.0);
	}
	HandleLanding();
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bSpawning=True
	bHighlight=True
	MsgSearching="You found:"
	MsgEmpty="You don't find anything"
	MsgNotDead="Unconscious"
	MsgAnimalCarcass="Animal Carcass"
	MsgCannotPickup="You cannot pickup the %s"
	MsgRecharged="Recharged %d points"
	ItemName="Dead Body"
	RemoteRole=ROLE_SimulatedProxy
	LifeSpan=0.0
	CollisionRadius=20.00
	//CollisionHeight=7.00
	CollisionHeight=6.25
	bCollideWorld=False
	Mass=150.0
	Buoyancy=170.0
	BindName="DeadBody"
	bVisionImportant=True
	LifeSpan=0.0
	bPlayerCarcass=False
	TooMuchAmmo="You already have enough of"
}
