//=============================================================================
// HXCat.
//=============================================================================
class HXCat extends HXAnimal;

var float Time;

function bool ShouldBeStartled(Pawn startler)
{
	local float speed;
	local float Time;
	local float dist;
	local float dist2;
	local bool  bPh33r;

	bPh33r = false;
	if (startler != None)
	{
		speed = VSize(startler.Velocity);
		if (speed >= 20)
		{
			dist = VSize(Location - startler.Location);
			Time = dist/speed;
			if (Time <= 3.0)
			{
				dist2 = VSize(Location - (startler.Location+startler.Velocity*Time));
				if (dist2 < speed*1.5)
					bPh33r = true;
			}
		}
	}

	return bPh33r;
}

function Tick(float deltaTime)
{
	Super.Tick(deltaTime);

	Time += deltaTime;

	// check for random noises
	if (Time > 1.0)
	{
		Time = 0;
		if (FRand() < 0.05)
			PlaySound(sound'CatPurr', SLOT_None,,, 128);
	}
}

state Attacking
{
	function Tick(float deltaSeconds)
	{
		Super.Tick(deltaSeconds);
		if (Enemy != None)
			GotoState('Fleeing');
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bPlayDying=True
	bFleeBigPawns=True
	MinHealth=0.0
	CarcassType=CatCarcass
	WalkingSpeed=0.111111
	InitialInventory(0)=(Inventory=Class'WeaponCatScratch')
	GroundSpeed=180.0
	WaterSpeed=50.0
	AirSpeed=144.0
	AccelRate=500.0
	MaxStepHeight=14.0
	BaseEyeHeight=6.0
	Health=30
	UnderWaterTime=20.0
	AttitudeToPlayer=ATTITUDE_Ignore
	HitSound1=CatHiss
	HitSound2=CatHiss
	Die=CatDie
	Alliance=Cat
	DrawType=DT_Mesh
	Mesh=Cat
	CollisionRadius=17.0
	//CollisionHeight=11.3
	CollisionHeight=6.8
	bBlockActors=False
	Mass=10.0
	Buoyancy=97.0
	RotationRate=(Yaw=100000)
	BindName="Cat"
	FamiliarName="Cat"
	UnfamiliarName="Cat"
}
