//=============================================================================
// HXCeilingFan.
//=============================================================================
class HXCeilingFan extends HXDecoration;

enum ESkinColor
{
	SC_WoodBrass,
	SC_DarkWoodIron,
	SC_White,
	SC_WoodBrassFancy,
	SC_WoodPlastic
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_WoodBrass:
				Skin = Texture'CeilingFanTex1';
				break;
			case SC_DarkWoodIron:
				Skin = Texture'CeilingFanTex2';
				break;
			case SC_White:
				Skin = Texture'CeilingFanTex3';
				break;
			case SC_WoodBrassFancy:
				Skin = Texture'CeilingFanTex4';
				break;
			case SC_WoodPlastic:
				Skin = Texture'CeilingFanTex5';
				break;
		}
	}
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local CeilingFan OtherCeilingFan;

	// Call Super.
	Super.Succeeds( Other );

	// Special CeilingFan Init.
	OtherCeilingFan = CeilingFan(Other);
	if ( OtherCeilingFan!=None )
	{
		SetPropertyText( "SkinColor", OtherCeilingFan.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	SkinColor=SC_DarkWoodIron
	FragType=WoodFragment
	bHighlight=False
	bClientHighlight=False
	bCanBeBase=True
	ItemName="Ceiling Fan Blades"
	bPushable=False
	Physics=PHYS_Rotating
	RemoteRole=ROLE_SimulatedProxy
	Mesh=CeilingFan
	Skin=CeilingFanTex1
	CollisionRadius=45.75
	//CollisionHeight=3.30
	CollisionHeight=2.55
	bCollideWorld=False
	bFixedRotationDir=True
	Mass=50.0
	Buoyancy=30.0
	RotationRate=(Yaw=16384)
}
