//=============================================================================
// HXCeilingFanMotor.
//=============================================================================
class HXCeilingFanMotor extends HXDecoration;

enum ESkinColor
{
	SC_WoodBrass,
	SC_DarkWoodIron,
	SC_White,
	SC_WoodBrassFancy,
	SC_WoodPlastic
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_WoodBrass:
				Skin = Texture'CeilingFanTex1';
				break;
			case SC_DarkWoodIron:
				Skin = Texture'CeilingFanTex2';
				break;
			case SC_White:
				Skin = Texture'CeilingFanTex3';
				break;
			case SC_WoodBrassFancy:
				Skin = Texture'CeilingFanTex4';
				break;
			case SC_WoodPlastic:
				Skin = Texture'CeilingFanTex5';
				break;
		}
	}
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local CeilingFanMotor OtherCeilingFanMotor;

	// Call Super.
	Super.Succeeds( Other );

	// Special CeilingFanMotor Init.
	OtherCeilingFanMotor = CeilingFanMotor(Other);
	if ( OtherCeilingFanMotor!=None )
	{
		SetPropertyText( "SkinColor", OtherCeilingFanMotor.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	SkinColor=SC_DarkWoodIron
	bInvincible=True
	bHighlight=False
	bClientHighlight=False
	bCanBeBase=True
	ItemName="Ceiling Fan Motor"
	bPushable=False
	Physics=PHYS_None
	Mesh=CeilingFanMotor
	Skin=CeilingFanTex1
	SoundRadius=12
	SoundVolume=160
	AmbientSound=MotorHum
	CollisionRadius=12.00
	//CollisionHeight=4.42
	CollisionHeight=3.67
	bCollideWorld=False
	Mass=50.0
	Buoyancy=30.0
}
