//=============================================================================
// HXChairLeather.
//=============================================================================
class HXChairLeather extends HXSeat;

enum ESkinColor
{
	SC_Black,
	SC_Blue,
	SC_Brown,
	SC_LitGray,
	SC_Tan
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local ChairLeather OtherChairLeather;

	// Call Super.
	Super.Succeeds( Other );

	// Special ChairLeather Init.
	OtherChairLeather = ChairLeather(Other);
	if ( OtherChairLeather!=None )
	{
		SetPropertyText( "SkinColor", OtherChairLeather.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	//
	// The original code here always used ChairLeatherTex1 for any SkinColor.
	// 
	// I do believe this way intentional and not a bug, as the other Skins
	// frankly do look awful. Also I regard it as unlikely that this bug
	// would have slipped through. --han
	//
	//if ( Role==ROLE_Authority && !IsInRelevant() )
	//{
	//	switch ( SkinColor )
	//	{
	//		case SC_Black:   Skin = Texture'ChairLeatherTex1'; break;
	//		case SC_Blue:    Skin = Texture'ChairLeatherTex2'; break;
	//		case SC_Brown:   Skin = Texture'ChairLeatherTex3'; break;
	//		case SC_LitGray: Skin = Texture'ChairLeatherTex4'; break;
	//		case SC_Tan:     Skin = Texture'ChairLeatherTex5'; break;
	//	}
	//}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	SitPoint(0)=(X=0.0,Y=-8.0,Z=0.0)
	ItemName="Comfy Chair"
	Mesh=ChairLeather
	Skin=ChairLeatherTex1
	CollisionRadius=33.50
	//CollisionHeight=23.25
	CollisionHeight=22.50
	Mass=100.0
	Buoyancy=110.0
}
