//=============================================================================
// HXChargedPickup.
//=============================================================================
class HXChargedPickup extends HXDeusExPickup
	abstract;

var const bool bOneUseOnly;

//var const Sound ActivateSound;   // Already declared in Inventory.
//var const Sound DeactivateSound; // Already declared in Inventory.
var const Sound LoopSound;

var const Texture ChargedIcon;

var const localized string ChargeRemainingLabel;
var const localized string MsgCannotDropOnceUsed;

var class<Skill> SkillNeeded;

var travel bool bIsActive;

// ----------------------------------------------------------------------------
// UpdateInfo()
// ----------------------------------------------------------------------------

simulated function bool UpdateInfo(Object winObject)
{
	local HXPersonaInfoWindow winInfo;
	local DeusExPlayer player;
	local String outText;

	winInfo = HXPersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	player = DeusExPlayer(Owner);

	if (player != None)
	{
		winInfo.SetTitle(itemName);
		winInfo.SetText(Description $ winInfo.CR() $ winInfo.CR());

		outText = ChargeRemainingLabel @ Int(GetCurrentCharge()) $ "%";
		winInfo.AppendText(outText);
	}

	return True;
}

// ----------------------------------------------------------------------------
// GetCurrentCharge()
// ----------------------------------------------------------------------------

simulated function float GetCurrentCharge()
{
	return (float(Charge)/float(default.Charge))*100.0;
}

// ----------------------------------------------------------------------------
// ChargedPickupBegin()
// ----------------------------------------------------------------------------

function ChargedPickupBegin(HXPlayerPawn Player)
{
	Player.HXAddChargedDisplay(Self);
	PlaySound(ActivateSound, SLOT_None);
	if (LoopSound != None)
		AmbientSound = LoopSound;

   //DEUS_EX AMSD In multiplayer, remove it from the belt if the belt
   //is the only inventory.
   if ((Level.NetMode != NM_Standalone) && (Player.bBeltIsMPInventory))
   {
      if (HXRootWindow(Player.rootWindow) != None)
         HXRootWindow(Player.rootWindow).DeleteInventory(self);

      bInObjectBelt=False;
      BeltPos=default.BeltPos;
   }

	bIsActive = True;
}

// ----------------------------------------------------------------------------
// ChargedPickupEnd()
// ----------------------------------------------------------------------------

function ChargedPickupEnd(HXPlayerPawn Player)
{
	Player.HXRemoveChargedDisplay(Self);
	PlaySound(DeactivateSound, SLOT_None);
	if (LoopSound != None)
		AmbientSound = None;

	// remove it from our inventory if this is a one
	// use item
	if (bOneUseOnly)
		Player.DeleteInventory(Self);

	bIsActive = False;
}

// ----------------------------------------------------------------------------
// IsActive()
// ----------------------------------------------------------------------------

simulated function bool IsActive()
{
	return bIsActive;
}

// ----------------------------------------------------------------------------
// ChargedPickupUpdate()
// ----------------------------------------------------------------------------

function ChargedPickupUpdate(DeusExPlayer Player)
{
}

// ----------------------------------------------------------------------------
// CalcChargeDrain()
// ----------------------------------------------------------------------------

simulated function int CalcChargeDrain(DeusExPlayer Player)
{
	local float skillValue;
	local float drain;

	drain = 4.0;
	skillValue = 1.0;

	if (skillNeeded != None)
		skillValue = Player.SkillSystem.GetSkillLevelValue(skillNeeded);
	drain *= skillValue;

	return Int(drain);
}

// ----------------------------------------------------------------------------
// function UsedUp()
//
// copied from Pickup, but modified to keep items from
// automatically switching
// ----------------------------------------------------------------------------

function UsedUp()
{
	local HXPlayerPawn Player;

	if ( Pawn(Owner) != None )
	{
		bActivatable = false;
		Pawn(Owner).ClientMessage(ExpireMessage);	
	}
	Owner.PlaySound(DeactivateSound);
	Player = HXPlayerPawn(Owner);

	if (Player != None)
	{
		if (Player.inHand == Self)
			ChargedPickupEnd(Player);
	}

	Destroy();
}

// ----------------------------------------------------------------------------
// state DeActivated
// ----------------------------------------------------------------------------

state DeActivated
{
}

// ----------------------------------------------------------------------------
// state Activated
// ----------------------------------------------------------------------------

state Activated
{
	function Timer()
	{
		local DeusExPlayer Player;

		Player = DeusExPlayer(Owner);
		if (Player != None)
		{
			ChargedPickupUpdate(Player);
			Charge -= CalcChargeDrain(Player);
			if (Charge <= 0)
				UsedUp();
		}
	}

	function BeginState()
	{
		local HXPlayerPawn Player;

		Super.BeginState();

		Player = HXPlayerPawn(Owner);
		if (Player != None)
		{
			// remove it from our inventory, but save our owner info
			if (bOneUseOnly)
			{
//				Player.DeleteInventory(Self);
				
				// Remove from player's hand
				Player.PutInHand(None);

				SetOwner(Player);
			}

			ChargedPickupBegin(Player);
			SetTimer(0.1, True);
		}
	}

	function EndState()
	{
		local HXPlayerPawn Player;

		Super.EndState();

		Player = HXPlayerPawn(Owner);
		if (Player != None)
		{
			ChargedPickupEnd(Player);
			SetTimer(0.1, False);
		}
	}

	function Activate()
	{
		// if this is a single-use item, don't allow the player to turn it off
		if (bOneUseOnly)
			return;

		Super.Activate();
	}
}

// ----------------------------------------------------------------------------
// CanBeDropped()
//
// Called by HXPlayerPawn.DropItem() to see if we cannot be dropped for some
// reason.
// ----------------------------------------------------------------------------

function bool CanBeDropped( optional bool bSilent )
{
	if ( !Super.CanBeDropped(bSilent) )
		return false;

	if ( IsActive() )
	{
		if ( bOneUseOnly )
		{
			if ( !bSilent )
				Pawn(Owner).ClientMessage( Sprintf(MsgCannotDropOnceUsed,ItemName), 'StatusLine' );	

			return false;
		}
		
		// What about the non existing non single use items? Or stackable?
	}

	return true;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	MsgCannotDropOnceUsed="%s cannot be dropped once used"
	bOneUseOnly=True
	ActivateSound=PickupActivate
	DeActivateSound=PickupDeactivate
	//ChargeRemainingLabel="Charge remaining:"
	ChargeRemainingLabel="CHARGE:"
	bActivatable=True
	Charge=2000
}
