//=============================================================================
// HXCigarettes.
//=============================================================================
class HXCigarettes extends HXInstantUsePickup;

// ----------------------------------------------------------------------------
// InstantUse()
// ----------------------------------------------------------------------------

function InstantUse( Pawn OwnerPawn, Actor FrobTarget )
{
	local vector loc;
	local rotator rot;
	local SmokeTrail puff;

	OwnerPawn.TakeDamage( 5, OwnerPawn, OwnerPawn.Location, vect(0,0,0), 'CoughingNails');

	loc = Owner.Location;
	rot = Owner.Rotation;
	loc += 2.0 * Owner.CollisionRadius * vector(OwnerPawn.ViewRotation);
	loc.Z += Owner.CollisionHeight * 0.9;
	puff = Spawn(class'SmokeTrail', Owner,, loc, rot);
	if (puff != None)
	{
		puff.DrawScale = 1.0;
		puff.origScale = puff.DrawScale;
	}

	//OwnerPawn.PlaySound( Sound'MaleCough', SLOT_Talk );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	M_Activated=""
	MsgActivated="You smoked a pack of cigarettes"
	MsgTooMany="You can't carry any more cigarettes"
	MaxCopies=20
	bCanHaveMultipleCopies=True
	bActivatable=True
	ItemName="Cigarettes"
	ItemArticle="some"
	PlayerViewOffset=(X=30.0,Y=0.0,Z=-12.0)
	PlayerViewMesh=Cigarettes
	PickupViewMesh=Cigarettes
	ThirdPersonMesh=Cigarettes
	Icon=BeltIconCigarettes
	LargeIcon=LargeIconCigarettes
	LargeIconWidth=29
	LargeIconHeight=43
	Description="'COUGHING NAILS -- when you've just got to have a cigarette.'"
	BeltDescription="CIGS"
	Mesh=Cigarettes
	CollisionRadius=5.20
	//CollisionHeight=1.32
	CollisionHeight=0.57
	Mass=2.0
	Buoyancy=3.0
}
