//=============================================================================
// HXCinematicPlay
//=============================================================================
class HXCinematicPlay expands HXConPlay;

// ----------------------------------------------------------------------
// StartCinematic()
//
// Starts a cinematic.  
// ----------------------------------------------------------------------

function bool StartCinematic( optional Actor newInvokeActor )
{
	local DeusExLevelInfo aDeusExLevelInfo;
	local bool bForcePlay;
	local Pawn P;

	bForcePlay = True;

	//if ( Super.StartConversation(newPlayer, newInvokeActor, bForcePlay) == False )
		//return False;

	// Super.StartConversation() start.

	Log( Self $ ".StartCinematic( " $ Game $ ", " $ newInvokeActor $ ", " $ bForcePlay $ " )", 'DevConPlay' );
	Log( "Con: " $ Con, 'DevConPlay' );

	// Make sure we have a conversation and a valid HXGameInfo.
	if ( Con==None || Game==None )
		return false;

	// Make sure the player isn't, uhhrr, you know, DEAD!
	//if (newPlayer.IsInState('Dying'))
		//return False;

	// Keep a pointer to the player in third person conversation
	//if ( !con.bFirstPerson )
	//{
		//player = HXPlayerPawn(newInvokeActor);
		invokeActor = startActor;
	//}
	//else
	//{
		//if (newInvokeActor != None) 
			//invokeActor = newInvokeActor;
		//else
			//invokeActor = startActor;
	//}

	// Bind the conversation events
	//con.BindEvents(ConActorsBound, invokeActor);
	class'HXActor'.static.BindConsersationEvents( con, ConActorsBound, invokeActor, XLevel );

	// Check to see if the conversation has multiple owners, in which case we 
	// want to rebind all the events with this owner.  This allows conversations
	// to be shared by more than one owner.
	if ((con.ownerRefCount > 1) && (invokeActor != None))
		con.BindActorEvents(invokeActor);

	// Save the mission number and location
	foreach AllActors(class'DeusExLevelInfo', aDeusExLevelInfo)
	{
		if (aDeusExLevelInfo != None)
		{
			missionNumber   = aDeusExLevelInfo.missionNumber;
			missionLocation = aDeusExLevelInfo.MissionLocation;
			break;
		}
	}

	// Save the conversation radius
	saveRadiusDistance = con.radiusDistance;

	bConversationStarted = True;

	// Super.StartConversation() end.

	bEndingConversation = False;

	// Check to see if this conversation uses random camera placement
	randomCamera = con.bRandomCamera;

	// Based on whether we're in first-person or third-person mode, 
	// we need to derive our conversation window differently.  First-person
	// conversation mode is non-interactive and only allows speech, for
	// the most part.

	//if ( con.bFirstPerson )
	//{
		//displayMode = DM_FirstPerson;

//		conWinFirst = rootWindow.hud.CreateConWindowFirst();

		// Initialize Windowing System
//		conWinFirst.conPlay = Self;
	//}
	//else
	//{
		//displayMode = DM_ThirdPerson;

		// Hide the hud display if this is a third-person convo
		//rootWindow.hud.Hide();

		//conWinThird = ConWindowActive(rootWindow.NewChild(Class'ConWindowActive', False));
		//conWinThird.SetForcePlay(bForcePlay);
/*
		// Setup default camera information, but only if bForcePlay is set to false
		if (!bForcePlay)
		{
			cameraInfo = con.CreateConCamera();
			//cameraInfo = CreateConCamera( con );
			cameraInfo.InitializeCameraValues(Self);

			if ( randomCamera )
				cameraInfo.SetupRandomCameraPosition();

			if ( player != none )
				HXPlayerPawn(player).bInThirdPersonCameraOverride = cameraInfo.CalculateCameraPosition( HXPlayerPawn(player).ThirdPersonCameraViewActor, HXPlayerPawn(player).ThirdPersonCameraLocation, HXPlayerPawn(player).ThirdPersonCameraRotation );
		}
*/
		// Initialize Windowing System
		//conWinThird.conPlay = Self;

		// Align the conversation window
		//conWinThird.SetWindowAlignments(HALIGN_Full, VALIGN_Full);
		//conWinThird.Show();


		// HX: walk through pawn list instead
		for( P = Level.PawnList; P != None; P = P.nextPawn )
			if ( P.bIsPlayer && P.IsA('HXPlayerPawn') )
				HXPlayerPawn(P).ClientCreateConWinThird( True );
	//}

	// Check to see if this is a passive or interactive conversation
	// Passive conversations are beyond the PC's control and do not have
	// things like Choices, etc. in them.

	// should always be passive
	if ( con.bNonInteractive )
		playMode = PM_Passive;
	else
		playMode = PM_Active;

	// Grab the first event!
	currentEvent = con.eventList;

	// Create a ConHistory object
//	if (!bForcePlay)
//		SetupHistory(player.GetDisplayName(startActor, True));

	// Play this event!
	GotoState('PlayEvent');

	return True;
}

// ----------------------------------------------------------------------
// TerminateConversation()
//
// Time to go away to that nice happy place!
// ----------------------------------------------------------------------

function TerminateConversation(optional bool bContinueSpeech, optional bool bNoPlayedFlag)
{
	// Save this for when we call Super.TerminateConversation() later
	bSaveContinueSpeech = bContinueSpeech;
	bSaveNoPlayedFlag   = bNoPlayedFlag;

	// Some protection to make sure this doesn't happen 
	// more than once.

	if (!bEndingConversation)
	{
		bEndingConversation = True;

		// Tell the Conversation Window to shut down
		//if ((conWinThird != None) && (!bForcePlay))
			//GotoState('WaitForConWin');
		//else
			// HX_NOTE: call it directly
			ConWinFinished();
	}
}

// ----------------------------------------------------------------------
// State WaitForConWin()
// ----------------------------------------------------------------------

state WaitForConWin
{
	function Timer()
	{
		if ( (( displayMode == DM_FirstPerson ) && (conWinFirst != None) && ( !conWinFirst.IsVisible())) || 
			 (( displayMode == DM_ThirdPerson ) && (conWinThird != None) && ( !conWinThird.IsVisible())) )
		{
			SetTimer(0, False);
			ConWinFinished();
		}
		else
		{
			SetTimer(0.2, True);
		}
	}

	function PlayNextEvent()
	{
		SetTimer(0, False);
		ConWinFinished();
	}

	function CloseConWindow()
	{
		if ( displayMode == DM_FirstPerson ) 
		{
			if (conWinFirst != None )
				conWinFirst.Close();
		}
		else
		{
			if (conWinThird != None)
				conWinThird.Close();
		}

		// Wait for the window to finish
		SetTimer(0.2, True);
	}

	function BeginState()
	{
		// Allow input
		if (conWinThird != None)
			conWinThird.RestrictInput(False);

		CloseConWindow();
	}
}

// ----------------------------------------------------------------------
// ConWinFinished()
//
// Called when the conversation window has finished moving and we 
// can destroy the ConPlay actor.
// ----------------------------------------------------------------------

function ConWinFinished()
{
	local Pawn P;

	// Nuke the conversation window
	if (displayMode == DM_FirstPerson)
	{
		//if (conWinFirst != None)
			//conWinFirst.Destroy();
	}
	else
	{
		//if (conWinThird != None)
			//conWinThird.Destroy();

		// Show the hud display if this was a third-person convo
		//if (!bForcePlay)
			//rootWindow.hud.Show();

		// HX: walk through pawn list instead
		for( P = Level.PawnList; P != None; P = P.nextPawn )
			if ( P.bIsPlayer && P.IsA('HXPlayerPawn') )
				HXPlayerPawn(P).ClientDestroyConWinThird();	
	}

	PostTerminateConversation();
 
	// Now nuke ourself.
	Destroy();
}

// ----------------------------------------------------------------------
// PostTerminateConversation()
// ----------------------------------------------------------------------

function PostTerminateConversation()
{
	Super.PostTerminateConversation();

	// TODO: maybe trigger mapchange here
}

// ----------------------------------------------------------------------
// SetupEventSpeechPost()
//
// Display the speech and wait for feedback.
// ----------------------------------------------------------------------

function EEventAction SetupEventSpeechPost( ConEventSpeech event, out String nextLabel )
{
	local EEventAction nextAction;
	local ConEvent checkEvent;
	local String speech;
	local bool bHaveSpeechAudio;

	local HXPlayerPawn			 RelevantPlayers[32];
	local int					 RelevantPlayerCount;

	local Pawn P;
	local int i;

	local string displayName;

	bActorsTurned = False;

	// Restrict input until we've finished setting up this event
//	if (conWinThird != None)
//		conWinThird.RestrictInput(True);

	// Keep track of the current speaker and speaking to actors
	if ((currentSpeaker != event.speaker) || (currentSpeakingTo != event.speakingTo))
	{
		// If we're in "Random Camera" mode, then we want to 
		// pick a new camera position.

		if ((randomCamera) && (cameraInfo != None))
			cameraInfo.SetupRandomCameraPosition();

		// Update our actor variables
		currentSpeaker    = event.speaker;
		currentSpeakingTo = event.speakingTo;

		UpdateCameraInfo();
	}

	// HX: walk through pawn list instead
	for( P = Level.PawnList; P != None; P = P.nextPawn )
		if ( P.bIsPlayer && P.IsA('HXPlayerPawn') )
			RelevantPlayers[RelevantPlayerCount++] = HXPlayerPawn(P);

	// Update the Actors used by the camera
	SetCameraActors();

	// Cause the speaking actor to turn towards the person he is
	// speaking to.
	TurnSpeakingActors(event.speaker, event.speakingTo);

	// Calculate the length of the text string, this is used later
	speech = event.conSpeech.speech;

	bHaveSpeechAudio = (event.conSpeech.soundID != -1);

	lastSpeechTextLength = len(speech);

	// Display the speech text, if:
	// 
	// 1.  Player has bSubtitles flag on
	// 2.  No speech audio exists for the speech

	if ((Game.bSubtitles) || (!bHaveSpeechAudio))
	{			
//		if ( displayMode == DM_FirstPerson )
//			conWinFirst.Show();

		displayName = Game.GetDisplayName(event.speaker);

		// If we're continuing from the last speech, then we want to Append 
		// and not Display the first chunk.
		if ( event.bContinued == True )
		{
			//conWinThird.AppendText( speech );
			for ( i = 0; i < RelevantPlayerCount; i ++ )
				RelevantPlayers[i].ClientAddConWinThirdLine( speech );
		}
		else
		{
			// Clear the window
			//conWinThird.Clear();

			//conWinThird.DisplayName(  );
			//conWinThird.DisplayText( speech, currentSpeaker );

			for ( i = 0; i < RelevantPlayerCount; i ++ )
				RelevantPlayers[i].ClientDisplayConWinThirdLine( displayName, speech, currentSpeaker );
		}
	}
	//else if (displayMode == DM_FirstPerson)
	//{
//		conWinFirst.Hide();
	//}

	// Save this event in the history
//	AddHistoryEvent(player.GetDisplayName(event.Speaker, True), event.conSpeech);

	//for ( i = 0; i < RelevantPlayerCount; i ++ )
		//RelevantPlayers[i].bInThirdPersonCameraOverride = cameraInfo.CalculateCameraPosition( RelevantPlayers[i].ThirdPersonCameraViewActor, RelevantPlayers[i].ThirdPersonCameraLocation, RelevantPlayers[i].ThirdPersonCameraRotation );


	// If we have speech audio, play it!
	if (bHaveSpeechAudio)
	{
		nextAction = EA_WaitForSpeech;
	}
	else
	{
		// Otherwise, we'll wait for the text to play (either in passive mode, which
		// means the text will continue on its own, or in ACTIVE mode, in which case
		// we'll wait for a keypress before continuing.

		if (( playMode == PM_PASSIVE ) || ( displayMode == DM_FirstPerson ))
		{
			nextAction = EA_WaitForText;
		}
		else
		{
			// If we're here, we either have no speech or we're in a text-only mode
			//
			// We want to wait for input unless the next event is a 
			// speech event and has the "Continued" flag set, which 
			// allows for additional speech and choices to 
			// appear immediately after the current speech.
			//
			// Choices automatically continue unless they have the "Clear Screen"
			// flag set.

			checkEvent = GetNextEvent();

			if ( (( ConEventChoice(checkEvent) != None ) && ( !ConEventChoice(checkEvent).bClearScreen )) || 
			   (( ConEventSpeech(checkEvent) != None ) && ( ConEventSpeech(checkEvent).bContinued )) )
				nextAction = EA_NextEvent;
			else
				nextAction = EA_WaitForInput;
		}
	}

	nextLabel = "";
	return nextAction;
}

// ----------------------------------------------------------------------
// PlaySpeech()
// ----------------------------------------------------------------------

function PlaySpeech( int soundID, Actor speaker )
{
	local Sound speech;

	speech = con.GetSpeechAudio(soundID);

	if (speech != None)
	{
		playingSoundID = HXGameInfo(Level.Game).BroadcastActorCinematicSpeech( speech $ "", speaker, 65536.0 );
	}

	StartSpeakingAnimation();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
