//=============================================================================
// HXCinematicWindow.
//=============================================================================
class HXCinematicWindow extends Window;

function InitWindow()
{
	Super.InitWindow();

	SetWindowAlignments(HALIGN_Full, VALIGN_Full);
}

function DestroyWindow()
{
	ResetRootViewport();

	Super.DestroyWindow();
}

function ConfigurationChanged()
{
	SetRootViewport();
}

event VisibilityChanged(bool bNewVisibility)
{
	Super.VisibilityChanged( bNewVisibility );

	if (bNewVisibility)
		SetRootViewport();
	else
		ResetRootViewport();
}

function SetRootViewport()
{
	local RootWindow root;
	local float      cinWidth, cinHeight;
	local float      cinX,     cinY;
	local float ratio;
	local float rawRatio;

	root      = GetRootWindow();

	// calculate the correct 16:9 ratio
	//ratio = 0.5625 * (root.width / root.height);

	rawRatio = root.width / root.height;
	
	// ratio = 0.75 for  4:3
	// ratio = 0.90 for 16:10
	// ratio = 1.00 for 16:9

	if ( rawRatio < 1.34 )
	{
		// okay, still use 16:9
		ratio = 0.5625 * rawRatio;
	}
	else if ( ratio < 1.61 )
	{
		// use 37:20 for 16:10
		ratio = 20.0 / 37.0 * rawRatio;
	}
	else
	{
		// use 20:9 for everything else
		ratio = 9.0 / 20.0 * rawRatio;
	}

	// make sure we at least see something
	if ( ratio > 0.9 )
		ratio = 0.9;

	cinWidth  = root.width;
	cinHeight = root.height * ratio;
	cinX      = 0;
	cinY      = int(0.5 * (root.height - cinHeight));

	// make sure we don't invert the letterbox if the screen size is strange
	if (cinY < 0)
		root.ResetRenderViewport();
	else
		root.SetRenderViewport(cinX, cinY, cinWidth, cinHeight);
}

function ResetRootViewport()
{
	local RootWindow root;

	root = GetRootWindow();
	root.ResetRenderViewport();
}

defaultproperties
{
}
