//=============================================================================
// HXClientDataLinkPlay
//=============================================================================
class HXClientDataLinkPlay extends DataLinkPlay;

// Save the DatalinkTrigger so we can notify the trigger when 
// the datalink has finished playing.
var HXDatalinkTrigger HXDatalinkTrigger;

// ----------------------------------------------------------------------
// SetTrigger()
// ----------------------------------------------------------------------

function SetHXTrigger(HXDatalinkTrigger newDatalinkTrigger)
{
	HXDatalinkTrigger = newDatalinkTrigger;
}


// ----------------------------------------------------------------------
// StartConversation()
//
// Starts a conversation.  
//
// 1.  Initializes the Windowing system
// 2.  Gets a pointer to the first Event
// 3.  Jumps into the 'PlayEvent' state
// ----------------------------------------------------------------------

function bool ConPlayBaseStartConversation(DeusExPlayer newPlayer, optional Actor newInvokeActor, optional bool bForcePlay)
{
	local DeusExLevelInfo aDeusExLevelInfo;

	// Make sure we have a conversation and a valid Player
	if (( con == None ) || ( newPlayer == None ))
		return False;

	// Make sure the player isn't, uhhrr, you know, DEAD!
	if (newPlayer.IsInState('Dying'))
		return False;

	// Keep a pointer to the player and invoking actor
	player      = newPlayer;

	if (newInvokeActor != None) 
		invokeActor = newInvokeActor;
	else
		invokeActor = startActor;

	// Bind the conversation events
	//con.BindEvents(ConActorsBound, invokeActor);
	class'HXActor'.static.BindConsersationEvents( con, ConActorsBound, invokeActor, XLevel );

	// Check to see if the conversation has multiple owners, in which case we 
	// want to rebind all the events with this owner.  This allows conversations
	// to be shared by more than one owner.
	if ((con.ownerRefCount > 1) && (invokeActor != None))
		con.BindActorEvents(invokeActor);

	// Check to see if all the actors are on the level.
	// Don't check this for InfoLink conversations, since oftentimes
	// the person speaking via InfoLink *won't* be on the map.
	//
	// If a person speaking on the conversation can't be found 
	// (say, they were ruthlessly MURDERED!) then abort.
	//
	// Hi Ken!

	if ((!bForcePlay) && (!con.bDataLinkCon) && (!con.CheckActors()))
		return False;

	// Now check to make sure that all the actors are a reasonable distance
	// from one another (excluding the player)
	if ((!bForcePlay) && (!con.CheckActorDistances(player)))
		return False;

	// Save the mission number and location
	foreach AllActors(class'DeusExLevelInfo', aDeusExLevelInfo)
	{
		if (aDeusExLevelInfo != None)
		{
			missionNumber   = aDeusExLevelInfo.missionNumber;
			missionLocation = aDeusExLevelInfo.MissionLocation;
			break;
		}
	}

	// Save the conversation radius
	saveRadiusDistance = con.radiusDistance;

	// Initialize Windowing System
	rootWindow = DeusExRootWindow(player.rootWindow);

	bConversationStarted = True;

	return True;
}


function bool StartConversation(DeusExPlayer newPlayer, optional Actor newInvokeActor, optional bool bForcePlay)
{
	local Actor tempActor;

	if ( !ConPlayBaseStartConversation(newPlayer,newInvokeActor,bForcePlay) )
		return false;

	// Create the DataLink display if necessary.  If it already exists,
	// then we're presently in a DataLink and need to queue this one up
	// for play after the current DataLink is finished.
	//
	// Don't play the DataLink if 
	//
	// 1.  A First-person conversation is currently playing 
	// 2.  Player is rooting around inside a computer
	//
	// In these cases we'll just queue it up instead

	if ( ( dataLink == None ) && 
	    ((player.conPlay == None) && (HXNetworkTerminal(rootWindow.GetTopWindow()) == None)))
	{
		lastSpeechTextLength = 0;
		bEndTransmission = False;
		eventTimer = 0;

		datalink = rootWindow.hud.CreateInfoLinkWindow();

		if ( dataLinkQueue[0] != None )
			dataLink.MessageQueued(True);
	}
	else
	{
		return True;
	}

	// Grab the first event!
	currentEvent = con.eventList;

	// Create the history object.  Passing in True means
	// this is an InfoLink conversation.
	SetupHistory(GetDisplayName(con.GetFirstSpeakerDisplayName()), True);

	// Play a sound and wait a few seconds before starting
	datalink.ShowTextCursor(False);
	player.PlaySound(startSound, SLOT_None); 
	bStartTransmission = True;
	SetTimer(blinkRate, True);
	return True;
}


// ----------------------------------------------------------------------
// NotifyDatalinkTrigger()
// ----------------------------------------------------------------------

function NotifyDatalinkTrigger()
{
	// moved to dryrunner

	//if (datalinkTrigger != None)
		//datalinkTrigger.DatalinkFinished();
}


// ----------------------------------------------------------------------
// SetupEventSetFlag()
// ----------------------------------------------------------------------

function EEventAction SetupEventSetFlag( ConEventSetFlag event, out String nextLabel )
{
	// DryRunner Sets flags

	nextLabel = "";
	return EA_NextEvent;
}

// ----------------------------------------------------------------------
// SetupEventCheckFlag()
// ----------------------------------------------------------------------

function EEventAction SetupEventCheckFlag( ConEventCheckFlag event, out String nextLabel )
{
	local ConFlagRef currentRef;
	local EEventAction action;

	// Default values if we actually make it all the way 
	// through the while loop below.

	nextLabel = event.setLabel;
	action = EA_JumpToLabel;
	
	// Loop through our list of FlagRef's, checking the value of each.
	// If we hit a bad match, then we'll stop right away since there's
	// no point of continuing.

	currentRef = event.flagRef;

	while( currentRef != None )
	{
		//if ( player.flagBase.GetBool(currentRef.flagName) != currentRef.value )
		if ( HXPlayerPawn(Player).FlagReplicationInfo.GetBoolFlag(currentRef.flagName) != currentRef.value )
		{
			nextLabel = "";
			action = EA_NextEvent;
			break;
		}
		currentRef = currentRef.nextFlagRef;
	}
	
	return action;
}

// ----------------------------------------------------------------------------
// HXify()
//
// Last remaining usage of this. Soon to be obsoleted with ditching of client
// side Datalink playback in favor of a streaming based approach.
// ----------------------------------------------------------------------------

final function class<Actor> HXify( Class<Actor> InClass, optional bool bMayFail )
{
	if ( InClass==None )
		return None;

	return Class<Actor>(DynamicLoadObject("HX.HX"$InClass.Name,Class'Class',bMayFail));
}

// ----------------------------------------------------------------------
// SetupEventCheckObject()
//
// Checks to see if the player has the given object.  If so, then we'll
// just fall through and continue running code.  Otherwise we'll jump
// to the supplied label.
// ----------------------------------------------------------------------

function EEventAction SetupEventCheckObject( ConEventCheckObject event, out String nextLabel )
{
	local HXNanoKeyReplicationInfo NanoKeyReplicationInfo;
	local EEventAction NextAction;
	local String KeyString;
	local bool bHasObject;
	local class<Inventory> InvClass;

	// Okay this is some HackyHack stuff here.  We want the ability to
	// check if the player has a particular nanokey.  Sooooooo.
	if ( Event.CheckObject==None && Left(Event.ObjectName,3)~="NK_" )
	{
		// Look for key
		NanoKeyReplicationInfo = HXPlayerPawn(Player).NanoKeyReplicationInfo;
		if ( NanoKeyReplicationInfo!=None )
		{
			KeyString  = Right(Event.ObjectName,Len(Event.ObjectName)-3);
			bHasObject = NanoKeyReplicationInfo.HasNanoKey( KeyString );
		}
		else
			bHasObject = False;
	}
	else
	{
		InvClass = class<Inventory>( HXify(Event.CheckObject) ); // !! This may no longer be correct !!
		if ( InvClass==None )
			InvClass = Event.CheckObject;
		else
			Event.CheckObject = InvClass;
		bHasObject = Player.FindInventoryType(InvClass)!=None;
	}

	// Now branch appropriately
	if ( bHasObject )
	{
		NextAction = EA_NextEvent;
		NextLabel  = "";
	}
	else
	{
		NextAction = EA_JumpToLabel;
		NextLabel  = Event.FailLabel;
	}
	return NextAction;
}

// ----------------------------------------------------------------------
// SetupEventTrigger()
// ----------------------------------------------------------------------

function EEventAction SetupEventTrigger( ConEventTrigger event, out String nextLabel )
{
	// moved to dryrunner

	return EA_NextEvent;
}

// ----------------------------------------------------------------------
// SetupEventAddGoal()
//
// TODO: Add support for goals longer than 255 characters.  
// ----------------------------------------------------------------------

function EEventAction SetupEventAddGoal( ConEventAddGoal event, out String nextLabel )
{
	// moved to dryrunner

	return EA_NextEvent;
}

// ----------------------------------------------------------------------
// SetupEventAddNote()
//
// TODO: Add support for notes longer than 255 characters.  
// ----------------------------------------------------------------------

function EEventAction SetupEventAddNote( ConEventAddNote event, out String nextLabel )
{
	// moved to dryrunner

	return EA_NextEvent;
}

// ----------------------------------------------------------------------
// SetupEventAddSkillPoints()
// ----------------------------------------------------------------------

function EEventAction SetupEventAddSkillPoints( ConEventAddSkillPoints event, out String nextLabel )
{
	// moved to dryrunner

	nextLabel = "";
	return EA_NextEvent;
}

// ----------------------------------------------------------------------
// SetupEventAddCredits()
//
// Adds the specified number of credits to the player.  If the 
// 'creditsToTransfer' variable is negative, this will cause
// the credits to get deducted from the player's credits total.
// ----------------------------------------------------------------------

function EEventAction SetupEventAddCredits( ConEventAddCredits event, out String nextLabel )
{
	// moved to dryrunner

	nextLabel = "";
	return EA_NextEvent;
}

// ----------------------------------------------------------------------
// SetupEventCheckPersona()
// ----------------------------------------------------------------------

function EEventAction SetupEventCheckPersona( ConEventCheckPersona event, out String nextLabel )
{
	local EEventAction action;
	local int personaValue;
	local bool bPass;

	// First determine which persona item we're checking
	switch(event.personaType)
	{
		case EP_Credits:
			personaValue = player.Credits;
			break;

		case EP_Health:
			player.GenerateTotalHealth();
			personaValue = player.Health;
			break;

		case EP_SkillPoints:
			personaValue = player.SkillPointsAvail;
			break;
	}

	// Now decide what to do baby!
	switch(event.condition)
	{
		case EC_Less:
			bPass = (personaValue < event.value);
			break;

		case EC_LessEqual:
			bPass = (personaValue <= event.value);
			break;

		case EC_Equal:
			bPass = (personaValue == event.Value);
			break;

		case EC_GreaterEqual:
			bPass = (personaValue >= event.Value);
			break;

		case EC_Greater:
			bPass = (personaValue > event.Value);
			break;
	}

	if (bPass)
	{
		nextLabel = event.jumpLabel;
		action = EA_JumpToLabel;
	}
	else
	{
		nextLabel = "";
		action = EA_NextEvent;
	}

	return action;
}

// ----------------------------------------------------------------------
// SetupEventTransferObject()
//
// Gives a Pawn the specified object.  The object will be created out of
// thin air (spawned) if there's no "fromActor", otherwise it's 
// transfered from one pawn to another.
//
// We now allow this to work without the From actor, which can happen
// in InfoLinks, since the FromActor may not even be on the map.
// This is useful for tranferring DataVaultImages.
// ----------------------------------------------------------------------

function EEventAction SetupEventTransferObject( ConEventTransferObject event, out String nextLabel )
{
	local EEventAction nextAction;
	local HUDReceivedDisplay rd;
	local HUDReceivedDisplayItem item;

/*
	log("SetupEventTransferObject()------------------------------------------", 'DevDataLinkPlay' );
	log("  event = " $ event, 'DevDataLinkPlay' );
	log("  event.giveObject = " $ event.giveObject, 'DevDataLinkPlay' );
	log("  event.fromActor  = " $ event.fromActor, 'DevDataLinkPlay' );
	log("  event.toActor    = " $ event.toActor, 'DevDataLinkPlay' );
*/

	if ( event.failLabel != "" )
	{
		nextAction = EA_JumpToLabel;
		nextLabel  = event.failLabel;
	}
	else
	{
		nextAction = EA_NextEvent;
		nextLabel = "";
	}

	// First verify that the receiver exists!
	if (event.toActor == None)
	{
		log("SetupEventTransferObject:  WARNING!  toActor does not exist!", 'DevDataLinkPlay' );
		log("  Conversation = " $ con.conName, 'DevDataLinkPlay' );
		return nextAction;
	}

	if ( !ClassIsChildOf( event.giveObject, Class'DataVaultImage') )
	{
		Log( Self $ ".SetupEventTransferObject() Object is a " $ event.giveObject $ " REPORT THIS AS A BUG !!! ", 'DevDataLinkPlay' );
		return nextAction;
	}

	// okay add display for DataVaultImage

	// Show the player that he/she/it just received something!

/*
	function AddItem(Inventory invItem, Int count)
	{
		local HUDReceivedDisplayItem item;

		item = HUDReceivedDisplayItem(winTile.NewChild(Class'HUDReceivedDisplayItem'));
		item.SetItem(invItem, count);

		displayTimer = 0.0;
		Show();
		bTickEnabled = True;
		AskParentForReconfigure();
	}

	event SetItem(Inventory invItem, int count)
	{
		local String labelText;

		winIcon = NewChild(Class'Window');
		winIcon.SetSize(42, 37);
		winIcon.SetBackgroundStyle(DSTY_Masked);
		winIcon.SetBackground(invItem.Icon);

		winLabel = TextWindow(NewChild(Class'TextWindow'));
		winLabel.SetFont(fontLabel);
		winLabel.SetTextColor(colText);
		winLabel.SetTextAlignments(HALIGN_Center, VALIGN_Top);

		labelText = invItem.beltDescription;
		if (count > 1)
			labelText = labelText $ " (" $ String(count) $ ")";

		winLabel.SetText(labelText);
	}
*/
	rd = HXRootWindow(player.rootWindow).hud.receivedItems;
	
	item = HUDReceivedDisplayItem(rd.winTile.NewChild(Class'HUDReceivedDisplayItem'));

	// SetItem()
	item.winIcon = item.NewChild(Class'Window');
	item.winIcon.SetSize(42, 37);
	item.winIcon.SetBackgroundStyle(DSTY_Masked);
	item.winIcon.SetBackground(Class'DataVaultImage'.default.Icon);

	item.winLabel = TextWindow(item.NewChild(Class'TextWindow'));
	item.winLabel.SetFont(item.fontLabel);
	item.winLabel.SetTextColor(item.colText);
	item.winLabel.SetTextAlignments(HALIGN_Center, VALIGN_Top);
	item.winLabel.SetText(Class'DataVaultImage'.default.beltDescription);

	rd.displayTimer = 0.0;
	rd.Show();
	rd.bTickEnabled = True;
	rd.AskParentForReconfigure();

	nextAction = EA_NextEvent;
	nextLabel = "";

	return nextAction;
}


// ----------------------------------------------------------------------
// SetPlayedFlag()
// ----------------------------------------------------------------------

function SetPlayedFlag()
{
	local Name flagName;

	if (con != None)
	{
		// Make a note of when this conversation ended
		con.lastPlayedTime = player.Level.TimeSeconds;

		flagName = StringToName( con.conName $ "_Played" );

		// Only set the Played flag if it doesn't already exist 
		// (some conversations set this intentionally with a longer expiration
		// date so they can be relied up on in future missions)

		//if (!player.flagBase.GetBool(flagName))
		if ( con.bDisplayOnce )
		{
			// Add a flag noting that we've finished this conversation.  
			HXPlayerPawn(player).FlagReplicationInfo.SetClientBoolFlag(flagName, True);
		}

		// If this was a third-person convo, keep track of when the conversation
		// ended and who it was with (this is used to prevent radius convos
		// from playing immediately after letterbox convos).
		//
		// If this was a first-person convo, keep track of the owner and 
		// play time so we can prevent multiple radius-induced conversations
		// from playing without a pause (we don't want them to run into 
		// each other).

		/*
		if (con.bFirstPerson)
		{
			player.lastFirstPersonConvoActor = invokeActor;
			player.lastFirstPersonConvoTime  = con.lastPlayedTime;
		}
		else
		{
			player.lastThirdPersonConvoActor = invokeActor;
			player.lastThirdPersonConvoTime  = con.lastPlayedTime;
		}
		*/
	}
}

// ----------------------------------------------------------------------
// StringToName()
// ----------------------------------------------------------------------

function Name StringToName( string Str )
{
	return Class'HXMutator'.static.StringToName( Str );
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bGameRelevant=True
}
