//=============================================================================
// HXClothesRack.
//=============================================================================
class HXClothesRack extends HXHangingDecoration;

enum ESkinColor
{
	SC_Blue,
	SC_Yellow,
	SC_Green,
	SC_Black
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_Blue:   Skin = Texture'ClothesRackTex1'; break;
			case SC_Yellow: Skin = Texture'ClothesRackTex2'; break;
			case SC_Green:  Skin = Texture'ClothesRackTex3'; break;
			case SC_Black:  Skin = Texture'ClothesRackTex4'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local ClothesRack OtherClothesRack;

	// Call Super.
	Super.Succeeds( Other );

	// Special HackableDevices Init.
	OtherClothesRack = ClothesRack(Other);
	if ( OtherClothesRack!=None )
	{
		SetPropertyText("SkinColor", OtherClothesRack.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	FragType=PaperFragment
	ItemName="Hanging Clothes"
	Mesh=ClothesRack
	Skin=ClothesRackTex1
	PrePivot=(Z=24.75)
	CollisionRadius=13.00
	//CollisionHeight=24.75
	CollisionHeight=24.00
	Mass=60.0
	Buoyancy=70.0
}
