//=============================================================================
// HXCoffeeTable.
//=============================================================================
class HXCoffeeTable extends HXFurniture;

enum ESkinColor
{
	SC_WhiteMarble,
	SC_BlackMarble,
	SC_GrayMarble
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_WhiteMarble: Skin = Texture'CoffeeTableTex1'; break;
			case SC_BlackMarble: Skin = Texture'CoffeeTableTex2'; break;
			case SC_GrayMarble:  Skin = Texture'CoffeeTableTex3'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local CoffeeTable OtherCoffeeTable;

	// Call Super.
	Super.Succeeds( Other );

	// Special CoffeeTable Init.
	OtherCoffeeTable = CoffeeTable(Other);
	if ( OtherCoffeeTable!=None )
	{
		SetPropertyText( "SkinColor", OtherCoffeeTable.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bCanBeBase=True
	ItemName="Coffee Table"
	Mesh=CoffeeTable
	Skin=CoffeeTableTex1
	CollisionRadius=34.75
	//CollisionHeight=13.68
	CollisionHeight=14.93
	Mass=80.0
	Buoyancy=25.0
}
