//=============================================================================
// HXComputerPublic.
//=============================================================================
class HXComputerPublic extends HXComputers;

var() name bulletinTag;

// ----------------------------------------------------------------------------
// network replication
// ----------------------------------------------------------------------------

replication
{
	//server to client
	reliable if (Role == ROLE_Authority)
		bulletinTag;
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local ComputerPublic OtherComputerPublic;

	// Call Super.
	Super.Succeeds( Other );

	// Special ComputerPublic Init.
	OtherComputerPublic = ComputerPublic(Other);
	if ( OtherComputerPublic!=None )
	{
		BulletinTag = OtherComputerPublic.BulletinTag;	
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	BindName="ComputerPublic"
	TerminalType=HXNetworkTerminalPublic
	ItemName="Public Computer Terminal"
	Physics=PHYS_None
	Mesh=ComputerPublic
	ScaleGlow=2.0
	CollisionRadius=22.00
	//CollisionHeight=49.14
	CollisionHeight=48.39
}
