//=============================================================================
// HXComputerScreenATMWithdraw
//=============================================================================
class HXComputerScreenATMWithdraw expands HXComputerUIWindow;

var MenuUILabelWindow        winInstructions;
var MenuUISmallLabelWindow   winInfo;

var MenuUIActionButtonWindow btnWithdraw;
var MenuUIActionButtonWindow btnClose;
var MenuUIEditWindow         editBalance;
var MenuUIEditWindow         editWithdraw;

var HXATM atmOwner;				// what ATM owns this window?
var float balanceModifier;
var float disabledDelay;		// Amount of time before ATM disabled when hacking

var localized String ButtonLabelWithdraw;
var localized String ButtonLabelClose;
var localized String BalanceLabel;
var localized String WithdrawAmountLabel;
var localized String InstructionText;
var localized String InvalidAmountLabel;
var localized String InsufficientCreditsLabel;
var localized String CreditsWithdrawnLabel;
var localized String StatusText;
var localized String HackedText;

// ----------------------------------------------------------------------
// CreateControls()
// ----------------------------------------------------------------------

function CreateControls()
{
	Super.CreateControls();

	btnWithdraw = winButtonBar.AddButton(ButtonLabelWithdraw, HALIGN_Right);
	btnClose    = winButtonBar.AddButton(ButtonLabelClose,  HALIGN_Right);

	CreateMenuLabel(20, 91, BalanceLabel, winClient);
	CreateMenuLabel(20, 121, WithdrawAmountLabel, winClient);

	editBalance  = CreateMenuEditWindow(231, 89, 143, 10, winClient);
	editBalance.SetSensitivity(False);	// cannot edit balance!!
	editWithdraw = CreateMenuEditWindow(231, 119, 143, 10, winClient);

	CreateInstructionsWindow();
	CreateInfoWindow();

	TitleWindow.SetTitle(Title);
	winStatus.SetText(StatusText);
}

// ----------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------

function Tick(float deltaTime)
{
	disabledDelay -= deltaTime;

	if (disabledDelay <= 0.0)
	{
		bTickEnabled = False;

		// Go to the ATM Disabled screen
		CloseScreen("ATMDISABLED");
	}
}

// ----------------------------------------------------------------------
// CreateInstructionsWindow()
// ----------------------------------------------------------------------

function CreateInstructionsWindow()
{
	winInstructions = MenuUILabelWindow(winClient.NewChild(Class'MenuUILabelWindow'));

	winInstructions.SetPos(8, 10);
	winInstructions.SetSize(381, 50);
	winInstructions.SetTextAlignments(HALIGN_Center, VALIGN_Center);
	winInstructions.SetTextMargins(0, 0);
}

// ----------------------------------------------------------------------
// CreateInfoWindow()
// ----------------------------------------------------------------------

function CreateInfoWindow()
{
	winInfo = MenuUISmallLabelWindow(winClient.NewChild(Class'MenuUISmallLabelWindow'));

	winInfo.SetPos(8, 152);
	winInfo.SetSize(385, 25);
	winInfo.SetTextAlignments(HALIGN_Center, VALIGN_Center);
	winInfo.SetTextMargins(0, 0);
}

// ----------------------------------------------------------------------
// SetCompOwner()
// ----------------------------------------------------------------------

function SetCompOwner(HXComputers newCompOwner)
{
	local String test;

	Super.SetCompOwner(newCompOwner);
	atmowner = HXATM(compOwner);

	balanceModifier = winTerm.GetSkillLevel() * 0.5;
	UpdateBalance();

	if (winTerm.bHacked)
	{
		// Once hacked, an ATM can't be returned to
		atmOwner.bSuckedDryByHack = True;
		test = Sprintf(InstructionText, HackedText);
	}
	else
	{
		test = Sprintf(InstructionText, GetATMAccountNumber(atmOwner, winTerm.GetUserIndex()));
	}

	winInstructions.SetText(test);

	EnableButtons();
	SetFocusWindow(editWithdraw);
}

// ----------------------------------------------------------------------
// UpdateBalance()
// ----------------------------------------------------------------------

function UpdateBalance()
{
	if (winTerm.bHacked)
		editBalance.SetText(String(GetBalance(atmOwner, -1, balanceModifier)));
	else
		editBalance.SetText(String(GetBalance(atmOwner, winTerm.GetUserIndex(), balanceModifier)));
}

// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;

	bHandled = True;

	switch( buttonPressed )
	{
		case btnWithdraw:
			WithdrawCredits();
			break;

		case btnClose:
			CloseScreen("LOGOUT");
			break;

		default:
			bHandled = False;
			break;
	}

	if (bHandled)
		return True;
	else
		return Super.ButtonActivated(buttonPressed);
}

// ----------------------------------------------------------------------
// EditActivated()
// ----------------------------------------------------------------------

event bool EditActivated(window edit, bool bModified)
{
	WithdrawCredits();
}

// ----------------------------------------------------------------------
// WithdrawCredits()
// ----------------------------------------------------------------------

function WithdrawCredits()
{
	local float Ratio;
	local int NumCredits;
	local int Balance;

	NumCredits = int(EditWithdraw.GetText());

	// Withdrawal.
	if ( NumCredits>0 )
	{
		if ( WinTerm.bHacked )
			Balance = GetBalance( AtmOwner, -1, BalanceModifier );
		else
			Balance = GetBalance( AtmOwner, WinTerm.GetUserIndex(), BalanceModifier );

		if ( Balance>=NumCredits )
		{
			if ( WinTerm.bHacked )
			{
				Ratio = float(NumCredits)/float(Balance);
				PlayerPawn.WithdrawCreditsAndModBalance( AtmOwner, -1, NumCredits, True, Ratio );
			}
			else
			{
				PlayerPawn.WithdrawCreditsAndModBalance( AtmOwner, WinTerm.GetUserIndex(), NumCredits, True, 1.0 );
			}

			WinInfo.SetText(String(numCredits) @ CreditsWithdrawnLabel);

			// If the user withdrew *ALL* the money and this ATM machine 
			// was hacked, then set a timer which will cause the 
			// ATM Disabled screen to come up after a few seconds.
			if ( WinTerm.bHacked && (Balance-numCredits)<=0 )
			{
				bTickEnabled = True;
				//AtmOwner.bSuckedDryByHack = True;
			}
		}
		else
		{
			WinInfo.SetText( InsufficientCreditsLabel );
		}
	}
	else
	{
		WinInfo.SetText( InvalidAmountLabel );
	}

	// Blank withdraw box and reset focus to that window
	EditWithdraw.SetText("");
	
	//UpdateBalance();
	if ( (Balance-NumCredits)<= 0 )
		EditBalance.SetText( String(0) );
	else
		EditBalance.SetText( String(Balance-NumCredits) );

	SetFocusWindow( EditWithdraw );
}

// ----------------------------------------------------------------------
// TextChanged() 
// ----------------------------------------------------------------------

event bool TextChanged(window edit, bool bModified)
{
	EnableButtons();

	return False;
}

// ----------------------------------------------------------------------
// EnableButtons()
// ----------------------------------------------------------------------

function EnableButtons()
{
	local float balance;

	// Only allow withdraw if there's money to be withdrawn and the user has typed
	// something into the editWithdraw field

	if (winTerm.bHacked)
		balance = GetBalance(atmOwner, -1, balanceModifier);
	else
		balance = GetBalance(atmOwner, winTerm.GetUserIndex(), balanceModifier);

	btnWithdraw.SetSensitivity((editWithdraw.GetText() != "") && (balance > 0));
}


// ----------------------------------------------------------------------
// NumATMUsers()
// ----------------------------------------------------------------------

function int NumATMUsers(HXATM atm)
{
	local int i;

	for (i=0; i<ArrayCount(atm.ATMUserList); i++)
		if (atm.ATMUserList[i].accountNumber == "")
			break;

	return i;
}

// ----------------------------------------------------------------------
// GetBalance()
// ----------------------------------------------------------------------

function int GetBalance(HXATM atm, int userIndex, float mod)
{
	local int i, sum;

	sum = 0;

	if ((userIndex >= 0) && (userIndex < ArrayCount(atm.ATMUserList)))
		sum = atm.ATMUserList[userIndex].balance;
	else if (userIndex == -1)
	{
		// if we've been hacked, sum all the accounts
		for (i=0; i<ArrayCount(atm.ATMUserList); i++)
			sum += atm.ATMUserList[i].balance;
		sum *= mod;
	}

	return sum;
}

// ----------------------------------------------------------------------
// GetATMAccountNumber()
// ----------------------------------------------------------------------

function string GetATMAccountNumber(HXATM atm, int userIndex)
{
	if ((userIndex >= 0) && (userIndex < ArrayCount(atm.ATMUserList)))
		return Caps(atm.ATMUserList[userIndex].accountNumber);
	else if (userIndex == -1)
		return "HACKED";

	return "ERR";
}

// ----------------------------------------------------------------------
// GetATMPIN()
// ----------------------------------------------------------------------

function string GetATMPIN(HXATM atm, int userIndex)
{
	if ((userIndex >= 0) && (userIndex < ArrayCount(atm.ATMUserList)))
		return Caps(atm.ATMUserList[userIndex].PIN);
	else if (userIndex == -1)
		return "HACKED";

	return "ERR";
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     disabledDelay=5.000000
     ButtonLabelWithdraw="|&Withdraw"
     ButtonLabelClose="|&Close"
     BalanceLabel="Current Balance:"
     WithdrawAmountLabel="Amount to Withdraw:"
     InstructionText="Account #: %d|nPlease enter the amount of|ncredits you wish to withdraw."
     InvalidAmountLabel="INVALID AMOUNT ENTERED"
     InsufficientCreditsLabel="INSUFFICIENT CREDITS"
     CreditsWithdrawnLabel="CREDITS WITHDRAWN"
     StatusText="PNGBS//GLOBAL//PUB:3902.9571[wd]"
     HackedText="TERMINAL HACKED"
     escapeAction="LOGOUT"
     Title="PageNet Global Banking System"
     ClientWidth=403
     ClientHeight=211
     verticalOffset=30
     clientTextures(0)=Texture'DeusExUI.UserInterface.ComputerGBSWithdrawBackground_1'
     clientTextures(1)=Texture'DeusExUI.UserInterface.ComputerGBSWithdrawBackground_2'
     textureRows=1
     textureCols=2
     bAlwaysCenter=True
     statusPosY=186
     ComputerNodeFunctionLabel="ATMWD"
}
