//=============================================================================
// HXComputerSecurity.
//=============================================================================
class HXComputerSecurity extends HXComputers;

struct sViewInfo
{
	var() localized string	titleString;
	var() name				cameraTag;
	var() name				turretTag;
	var() name				doorTag;
};

var() localized sViewInfo Views[3];
var int team;

// ----------------------------------------------------------------------------
// network replication
// ----------------------------------------------------------------------------
replication
{
   //server to client
   reliable if (Role == ROLE_Authority)
      Views, team;
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local ComputerSecurity OtherComputerSecurity;
	local int i;

	// Call Super.
	Super.Succeeds( Other );

	// Special ComputerSecurity Init.
	OtherComputerSecurity = ComputerSecurity(Other);
	if ( OtherComputerSecurity!=None )
	{
		for ( i=0; i<3; i++ )
		{
			Views[i].TitleString	= OtherComputerSecurity.Views[i].TitleString;
			Views[i].CameraTag		= OtherComputerSecurity.Views[i].CameraTag;
			Views[i].TurretTag		= OtherComputerSecurity.Views[i].TurretTag;
			Views[i].DoorTag			= OtherComputerSecurity.Views[i].DoorTag;
		}
	}
}

// ----------------------------------------------------------------------------
// SetControlledObjectOwners
// Used to enhance network replication.
// ----------------------------------------------------------------------------

function SetControlledObjectOwners(DeusExPlayer PlayerWhoOwns)
{
	local int cameraIndex;
	local name tag;
	local SecurityCamera camera;
   local HXAutoTurret turret;
   local DeusExMover door;

	for (cameraIndex=0; cameraIndex<ArrayCount(Views); cameraIndex++)
	{
		tag = Views[cameraIndex].cameraTag;
		if (tag != '')
			foreach AllActors(class'SecurityCamera', camera, tag)
				camera.SetOwner(PlayerWhoOwns);

		tag = Views[cameraIndex].turretTag;
		if (tag != '')
			foreach AllActors(class'HXAutoTurret', turret, tag)
            turret.SetOwner(PlayerWhoOwns);
				
		tag = Views[cameraIndex].doorTag;
		if (tag != '')
			foreach AllActors(class'DeusExMover', door, tag)
				door.SetOwner(PlayerWhoOwns);

	}

}

// ----------------------------------------------------------------------------
// AdditionalActivation()
// Called for subclasses to do any additional activation steps.
// ----------------------------------------------------------------------------

function AdditionalActivation(DeusExPlayer ActivatingPlayer)
{
   if (Level.NetMode != NM_Standalone)
      SetControlledObjectOwners(ActivatingPlayer);
   
   Super.AdditionalActivation(ActivatingPlayer);
}

// ----------------------------------------------------------------------------
// AdditionalDeactivation()
// ----------------------------------------------------------------------------

function AdditionalDeactivation(DeusExPlayer DeactivatingPlayer)
{
   if (Level.NetMode != NM_Standalone)
      SetControlledObjectOwners(None);
   
   Super.AdditionalDeactivation(DeactivatingPlayer);
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	BindName="ComputerSecurity"
	TerminalType=Class'HX.HXNetworkTerminalSecurity'
	LockoutDelay=120.0
	UserList(0)=(UserName="SECURITY",Password="SECURITY")
	ItemName="Security Computer Terminal"
	Physics=PHYS_None
	Mesh=ComputerSecurity
	Team=-1
	SoundRadius=8
	SoundVolume=255
	SoundPitch=96
	AmbientSound=SecurityL
	CollisionRadius=11.59
	//CollisionHeight=10.10
	CollisionHeight=9.35
	bCollideWorld=False
}
