//=============================================================================
// HXComputerSecurityChoice_DoorAccess
//=============================================================================
class HXComputerSecurityChoice_DoorAccess extends HXComputerCameraUIChoice;

// ----------------------------------------------------------------------
// SetCameraView()
// ----------------------------------------------------------------------

function SetCameraView(HXComputerSecurityCameraWindow newCamera)
{
	local bool bLocked;

	Super.SetCameraView(newCamera);

	if (winCamera != None)
	{
		if (winCamera.door != None)
		{
			EnableWindow();		// In case was previously disabled

			if ( winCamera.door.isA('HXMover') )
				bLocked = HXMover(winCamera.door).bLocked;
			else
				bLocked = DeusExMover(winCamera.door).bLocked;

			if ( bLocked )
				SetValue(0);
			else
				SetValue(1);
		}
		else
		{
			// Disable!
			DisableWindow();
			btnInfo.SetButtonText("");
		}
	}
	else
	{
		// Disable!
		DisableWindow();
		btnInfo.SetButtonText("");
	}
}

// ----------------------------------------------------------------------
// ButtonActivated()
//
// If the action button was pressed, cycle to the next available
// choice (if any)
// ----------------------------------------------------------------------

function bool ButtonActivated( Window buttonPressed )
{
	Super.ButtonActivated(buttonPressed);
	securityWindow.ToggleDoorLock();
	return True;
}

// ----------------------------------------------------------------------
// ButtonActivatedRight()
// ----------------------------------------------------------------------

function bool ButtonActivatedRight( Window buttonPressed )
{
	Super.ButtonActivated(buttonPressed);
	securityWindow.ToggleDoorLock();
	return True;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     enumText(0)="Locked"
     enumText(1)="Unlocked"
     actionText="Door |&Access"
}
