//=============================================================================
// HXConCamera
//=============================================================================
class HXConCamera extends ConCamera
	native;

var HXPlayerPawn Player;
/*
// ----------------------------------------------------------------------
// SetupCameraFromEvent()
//
// Sets up the ConCamera structure that will be used to place the 
// camera in the PlayerCalcView() function of the DeusExPlayer class.
// ----------------------------------------------------------------------

function SetupCameraFromEvent( ConEventMoveCamera event )
{
	Super.SetupCameraFromEvent( event );

	//if ( player != none )
		//player.bInThirdPersonCameraOverride = CalculateCameraPosition( player.ThirdPersonCameraViewActor, player.ThirdPersonCameraLocation, player.ThirdPersonCameraRotation );
}

// ----------------------------------------------------------------------
// SetupRandomCameraPosition()
//
// Picks from one of the various predefined camera positions.  There is
// logic in this routine to track how often we're changing the camera.
// We don't want to move the camera each time the actors change, 
// especially if the camera view (such as a side view) shows both 
// actors.  
// ----------------------------------------------------------------------

function SetupRandomCameraPosition()
{
	Super.SetupRandomCameraPosition();

	//if ( player != none )
		//player.bInThirdPersonCameraOverride = CalculateCameraPosition( player.ThirdPersonCameraViewActor, player.ThirdPersonCameraLocation, player.ThirdPersonCameraRotation );
}

// ----------------------------------------------------------------------
// SetupSpeakersCamera()
//
// Sets up the camera with info contained in the event structure
// ----------------------------------------------------------------------

function SetupSpeakersCamera( ConEventMoveCamera event )
{
	Super.SetupSpeakersCamera( event );

	//if ( player != none )
		//player.bInThirdPersonCameraOverride = CalculateCameraPosition( player.ThirdPersonCameraViewActor, player.ThirdPersonCameraLocation, player.ThirdPersonCameraRotation );
}

// ----------------------------------------------------------------------
// SetupActorCamera()
//
// Sets up the camera with info contained in the event structure
// ----------------------------------------------------------------------

function SetupActorCamera( ConEventMoveCamera event )
{
	Super.SetupActorCamera( event );

	//if ( player != none )
		//player.bInThirdPersonCameraOverride = CalculateCameraPosition( player.ThirdPersonCameraViewActor, player.ThirdPersonCameraLocation, player.ThirdPersonCameraRotation );
}

// ----------------------------------------------------------------------
// SetActors()
// 
// Sets the actors to be used for placing the camera
// ----------------------------------------------------------------------

function SetActors( Actor newFirstActor, Actor newSecondActor )
{
	Super.SetActors( newFirstActor, newSecondActor );

	//if ( player != none )
		//player.bInThirdPersonCameraOverride = CalculateCameraPosition( player.ThirdPersonCameraViewActor, player.ThirdPersonCameraLocation, player.ThirdPersonCameraRotation );

}

// ----------------------------------------------------------------------
// SetCameraValues()
//
// Sets up the camera values for each different camera position
// ----------------------------------------------------------------------

function SetCameraValues()
{
	Super.SetCameraValues();

	//if ( player != none )
		//player.bInThirdPersonCameraOverride = CalculateCameraPosition( player.ThirdPersonCameraViewActor, player.ThirdPersonCameraLocation, player.ThirdPersonCameraRotation );

}

// ----------------------------------------------------------------------
// InitializeCameraValues()
//
// Sets up the camera with default values
// ----------------------------------------------------------------------

function InitializeCameraValues(Actor cameraOwner)
{
	Super.InitializeCameraValues( cameraOwner );

	//if ( player != none )
		//player.bInThirdPersonCameraOverride = CalculateCameraPosition( player.ThirdPersonCameraViewActor, player.ThirdPersonCameraLocation, player.ThirdPersonCameraRotation );
}

// ----------------------------------------------------------------------
// SwitchCameraMode()
//
// Switches camera modes between CT_Speakers and CT_Actor
// ----------------------------------------------------------------------

function SwitchCameraMode()
{
	Super.SwitchCameraMode();

	//if ( player != none )
		//player.bInThirdPersonCameraOverride = CalculateCameraPosition( player.ThirdPersonCameraViewActor, player.ThirdPersonCameraLocation, player.ThirdPersonCameraRotation );
}

// ----------------------------------------------------------------------
// IncCameraMode()
//
// There must be a better way to do enum math 
// ----------------------------------------------------------------------

function IncCameraMode()
{
	Super.IncCameraMode();

	//if ( player != none )
		//player.bInThirdPersonCameraOverride = CalculateCameraPosition( player.ThirdPersonCameraViewActor, player.ThirdPersonCameraLocation, player.ThirdPersonCameraRotation );
}

// ----------------------------------------------------------------------
// DecCameraMode()
//
// There must be a better way to do enum math 
// ----------------------------------------------------------------------

function DecCameraMode()
{
	Super.DecCameraMode();

	//if ( player != none )
		//player.bInThirdPersonCameraOverride = CalculateCameraPosition( player.ThirdPersonCameraViewActor, player.ThirdPersonCameraLocation, player.ThirdPersonCameraRotation );
}

// ----------------------------------------------------------------------
// SetupSameActorFallbackCamera()
// ----------------------------------------------------------------------

function SetupSameActorFallbackCamera()
{
	Super.SetupSameActorFallbackCamera();

	//if ( player != none )
		//player.bInThirdPersonCameraOverride = CalculateCameraPosition( player.ThirdPersonCameraViewActor, player.ThirdPersonCameraLocation, player.ThirdPersonCameraRotation );
}

// ----------------------------------------------------------------------
// SetupFallbackCamera()
//
// Fallback camera, used in case the selected camera position fails
// because it is obstructed by terrain or another actor
// ----------------------------------------------------------------------

function SetupFallbackCamera()
{
	Super.SetupFallbackCamera();

	//if ( player != none )
		//player.bInThirdPersonCameraOverride = CalculateCameraPosition( player.ThirdPersonCameraViewActor, player.ThirdPersonCameraLocation, player.ThirdPersonCameraRotation );
}

// ----------------------------------------------------------------------
// SetupHeightFallbackCamera()
//
// Sets a suitable fallback camera to be used when there is a signficant
// height difference between two acors
// ----------------------------------------------------------------------

function bool SetupHeightFallbackCamera()
{
	local bool RetVal;

	RetVal = Super.SetupHeightFallbackCamera();

	//if ( player != none )
		//player.bInThirdPersonCameraOverride = CalculateCameraPosition( player.ThirdPersonCameraViewActor, player.ThirdPersonCameraLocation, player.ThirdPersonCameraRotation );

	return RetVal;
}

// ----------------------------------------------------------------------
// ResetFallbackPosition()
// ----------------------------------------------------------------------

function ResetFallbackPosition()
{
	Super.ResetFallbackPosition();

	//if ( player != none )
		//player.bInThirdPersonCameraOverride = CalculateCameraPosition( player.ThirdPersonCameraViewActor, player.ThirdPersonCameraLocation, player.ThirdPersonCameraRotation );
}


// ----------------------------------------------------------------------
// ActorObstructed()
//
// Performs a trace from the actor's location to the camera position
// to make sure it's not obstructed by anything.  If so, then we try
// to move the camera in a bit closer.  If that still fails, then 
// punt and return True and let the caller deal with the problem.
// ----------------------------------------------------------------------

function bool ActorObstructed(
	Actor actorToTrace,
	Actor ignoreActor,
	out   vector  CameraLocation, 
	out   rotator CameraRotation,
	float   ViewDist)
{
	local bool    bActorObstructed;
	local vector  HitLocation, HitNormal;
	local Actor   HitActor;

	// Used for texture trace
	local vector  EndTrace, StartTrace;
	local actor   target;
	local int     texFlags;
	local name    texName, texGroup;
	local bool    bInvisibleWall;
	local Texture Tex;

	// Used to test angle between speakers and camera
	// to make sure both actors onscreen
	local Vector  vector1, vector2;
	local Float   allowableCosAngle;
	local Float   dp;

	bActorObstructed = True;

	if (actorToTrace == None)
		return bActorObstructed;

	HitActor = actorToTrace.Trace(
		HitLocation, HitNormal, 
		actorToTrace.Location,	CameraLocation, False);

	if ((HitActor != None) && (bDebug)) 
		log("  HitActor = " $ HitActor);

	// Only do this if we don't have the interactive camera on

	// Perform a trace from the camera location to the actors speaking and 
	// (optionally) being spoken to.  If something other than the actors
	// is hit, then first attempt to pull the camera in a little closer.
	// If that doesn't work, then punt and use a default camera view.
		
	if ((HitActor != None) && (HitActor != actorToTrace) && ((ignoreActor != None) && (HitActor != ignoreActor)))
	{
		// Pull the camera in a little closer, but only within 25% of the original
		// desired location
		if (bDebug) log("  VSize(CameraLocation - HitLocation) = " $ VSize(CameraLocation - HitLocation));
		if (bDebug) log("  ViewDist = " $ ViewDist);

		if (VSize(CameraLocation - HitLocation) < (ViewDist / 3))
		{
			if (bDebug) log("  CameraLocation = " $ CameraRotation);
			if (bDebug) log("  HitLocation    = " $ HitLocation);
			if (bDebug) log("  CameraRotation = " $ CameraRotation);

			ViewDist = ViewDist - (VSize(CameraLocation - HitLocation)) - 25;
			CameraLocation = (HitLocation + (vector(CameraRotation) * 25));

			HitActor = actorToTrace.Trace( 
				HitLocation, HitNormal, 
				actorToTrace.Location, CameraLocation, False);

			if (bDebug) log("  CameraLocation = " $ CameraRotation);
			if (bDebug) log("  HitLocation    = " $ HitLocation);
			if (bDebug) log("  CameraRotation = " $ CameraRotation);
			if (bDebug) log("  ViewDist = " $ ViewDist);
			if (bDebug) log("  HitActor = " $ HitActor);
		}
	}

	// If HitActor is still not None then check to see if we're behind an 
	// invisble wall.  If so, then return False, as the invisible wall
	// won't be drawn and we should be safe with this camera shot.

	if ((HitActor != None) && (HitActor != actorToTrace) && ((ignoreActor != None) && (HitActor != ignoreActor)) && (!AllFallbackPositionsExhausted()))
	{
		bInvisibleWall = True;

		//foreach HitActor.TraceTexture(class'Actor', target, texName, texGroup, texFlags, HitLocation, HitNormal, actorToTrace.Location, CameraLocation)
		foreach Class'HXActor'.Static.StaticTraceTextures( HitActor, Class'Actor', target, Tex, texName, texGroup, texFlags, HitLocation, HitNormal, actorToTrace.Location, CameraLocation )
		{
			if ((texFlags & 1) !=0)		// 1 = PF_Invisible
			{
				bActorObstructed = False;
				break;
			}
		}
	}
	else
	{
		bActorObstructed = False;
	}

	// If this is a Side camera shot, then check to see if both actors are 
	// visible in the scene
	
	if (!bActorObstructed)
	{
		allowableCosAngle = 0.50;

		switch(cameraPosition)
		{
			case CP_SideTight:
			case CP_SideMid:
			case CP_SideAbove:
			case CP_SideAbove45:
				vector1 = actorToTrace.Location - CameraLocation;
				vector2 = ignoreActor.Location - CameraLocation;
				
				dp = vector1 dot vector2;
				cosangle = dp / (VSize(vector1) * VSize(vector2));

				if (cosangle < allowableCosAngle)
					bActorObstructed = True;

				break;
		}
	}
	return bActorObstructed;
}
*/

// ----------------------------------------------------------------------
// CreateHighlight()
// 
// Creates a highlight above the actor or actors talking.  This is done
// since sometimes it's difficult to see the actors' faces.
// ----------------------------------------------------------------------

function CreateHighlights( Actor CameraOwner )
{
	ConLightSpeaker    = CameraOwner.Spawn( class'HXConLight' );
	ConLightSpeakingTo = CameraOwner.Spawn( class'HXConLight' );
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
