//=============================================================================
// HXConLight.
//
// If !bMovable, then the light causes actors to flash for some fucked up reason.
//  -- Original ION comment. I have no idea --han
//=============================================================================
class HXConLight extends ConLight;

var int ActorDistance;

// ----------------------------------------------------------------------------
// Spawned()
// ----------------------------------------------------------------------------

simulated event Spawned()
{
	Super.Spawned();

	Log( Self$".Spawned()", 'DevConPlay' );
}

// ----------------------------------------------------------------------------
// Spawned()
// ----------------------------------------------------------------------------

simulated event PostNetBeginPlay()
{
	Super.PostNetBeginPlay();

	Log( Self$".PostNetBeginPlay()", 'DevConPlay' );
}

// ----------------------------------------------------------------------
// TurnOn()
// ----------------------------------------------------------------------

function TurnOn()
{
	LightType = LT_Steady;
}

// ----------------------------------------------------------------------
// TurnOff()
// ----------------------------------------------------------------------

function TurnOff()
{
	LightType = LT_None;
}

// ----------------------------------------------------------------------
// UpdateLocation()
// ----------------------------------------------------------------------

function UpdateLocation( Actor LightActor )
{
	local Vector DirVect;
	local Vector EyeVect;
	local float EyeHeight;

	if ( LightActor==None )
	{
		TurnOff();
	}
	else
	{
		TurnOn();

//		if ( LightActor.bIsPawn )
//			DirVect = Vector(LightActor.Rotation + Pawn(LightActor).AIAddViewRotation) * ActorDistance;
//		else

		DirVect = Vector(LightActor.Rotation) * ActorDistance;

		EyeHeight = float(LightActor.GetPropertyText("BaseEyeHeight"));

		EyeVect = vect(0,0,1)*EyeHeight + LightActor.Location;
		DirVect += EyeVect;

		SetLocation( DirVect );
		SetRotation( Rotator(EyeVect-DirVect) );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bGameRelevant=True
	ActorDistance=50
	bStatic=False
	bNoDelete=False
	bMovable=True
	LightType=LT_None
	LightEffect=LE_NonIncidence
	LightRadius=3
	LightCone=32
	RemoteRole=ROLE_DumbProxy
	NetPriority=4.000000
	bAlwaysRelevant=True
}
