//=============================================================================
// HXConPlay
//=============================================================================
class HXConPlay expands ConPlay;

var transient HXGameInfo Game;

// Copied from Barkmanager.
var int MaxAllowableRadius;
var int MaxHiddenHeightDifference;
var int MaxVisibleHeightDifference;

var ConChoice SavedChoices[10];
var int SavedChoicesCount;

// ----------------------------------------------------------------------------
// Spawned()
// ----------------------------------------------------------------------------

event Spawned()
{
	// Save precasted GameInfo.
	Game = HXGameInfo(Level.Game);
}

// ----------------------------------------------------------------------------
// CreateConCamera()
// ----------------------------------------------------------------------------

// FIX-ME: Appears to be never deleted!
function ConCamera CreateConCamera()
{
	local HXConCamera Cam;

	// None as Outer creates it under GObjTransientPkg.
	Cam = new(None,'',RF_Transient) class'HXConCamera';
	Cam.Player = HXPlayerPawn(Player);

	return Cam;
}

// ----------------------------------------------------------------------------
// ConCheckActors()
// -- Copied from Conversation.CheckActors()
//
// Checks to see if all the actors doing speaking in the conversation
// actually exist.
// ----------------------------------------------------------------------------

function bool ConCheckActors( Conversation CheckCon )
{
	local ConEvent Event;
	local ConEventSpeech EventSpeech;
	local bool bSpeakerPresent, bSpeakingToPresent;

	for ( Event=CheckCon.EventList; Event!=None; Event=Event.NextEvent )
	{
		EventSpeech = ConEventSpeech(Event);
		if ( EventSpeech!=None )
		{
			// Remap Player. GameInfo.BindName defaults to JCDenton.
			if ( EventSpeech.SpeakerName~=Game.BindName )
				bSpeakerPresent = Con.bFirstPerson || Player!=None;
			else
				bSpeakerPresent = EventSpeech.Speaker!=None;

			if ( EventSpeech.SpeakingToName~=Game.BindName )
				bSpeakingToPresent = Con.bFirstPerson || Player!=None;
			else
				bSpeakingToPresent = EventSpeech.SpeakingTo!=None;

			// Check if we either have no player or speaker.
			if ( !bSpeakerPresent || !bSpeakingToPresent )
				return false;
		}
	}

	// Passed.
	return true;
}

// ----------------------------------------------------------------------------
// ConCheckActorDistances 
// -- Copied from Conversation.CheckActorDistances()
//
// Checks to see how far all the actors are away from each other 
// to make sure it's reasonable to start a conversation.
// Ignore the player in these checks.
//
// Not called for Con.bFirstPerson.
// ----------------------------------------------------------------------------

function bool ConCheckActorDistances( Conversation CheckCon )
{
	local ConEvent Event;
	local ConEventSpeech EventSpeech;
	local Actor Speaker, SpeakingTo;
	local float Distance;

	// First fill up our array of actors
	for ( Event=CheckCon.EventList; Event!=None; Event=Event.NextEvent )
	{
		// Check further events? --han
		EventSpeech = ConEventSpeech(Event);
		if ( EventSpeech!=None )
		{
			// Distance checks to Player are not performed here.
			if ( EventSpeech.SpeakerName~=Game.BindName || EventSpeech.SpeakingToName~=Game.BindName )
				continue;

			// Check the distance between the two actors.
			if ( EventSpeech.Speaker!=None && EventSpeech.SpeakingTo!=None )
			{
				Distance = VSize(EventSpeech.Speaker.Location-EventSpeech.SpeakingTo.Location);

				if ( Distance>300.0 )
				{
					Log( Self $ ".ConCheckActorDistances( " $ checkCon $ " ) failed for:", 'DevConPlay' );
					Log( "Distance = " $ Distance, 'DevConPlay' );
					Log( "EventSpeech = " $ EventSpeech, 'DevConPlay' );
					Log( "EventSpeech.Speaker = " $ EventSpeech.Speaker, 'DevConPlay' );
					Log( "EventSpeech.SpeakingTo = " $ EventSpeech.SpeakingTo, 'DevConPlay' );

					return false;
				}
			}
		}
	}

	return true;
}

// ----------------------------------------------------------------------------
// StartConversation()
//
// Starts a conversation.  
//
// 1.  Initializes the Windowing system
// 2.  Gets a pointer to the first Event
// 3.  Jumps into the 'PlayEvent' state
// ----------------------------------------------------------------------------

function bool StartCoopConversation( optional Actor NewInvokeActor, optional bool bForcePlay)
{
	local DeusExLevelInfo aDeusExLevelInfo;

	//if ( Super.StartConversation(newPlayer, newInvokeActor, bForcePlay) == False )
		//return False;

	// Super.StartConversation() start.

	Log( Self $ ".StartCoopConversation( " $ Game $ ", " $ newInvokeActor $ ", " $ bForcePlay $ " )", 'DevConPlay' );
	Log( "Con: " $ Con, 'DevConPlay' );

	// Make sure we have a conversation and a valid HXGameInfo.
	if ( Con==None || Game==None )
	{
		Log( "Aborting ( Con==None || Game==None )", 'DevConPlay' );
		return false;
	}

	// Make sure the player isn't, uhhrr, you know, DEAD!
	//if (newPlayer.IsInState('Dying'))
		//return False;

	// Keep a pointer to the player in third person conversation
	if ( !con.bFirstPerson )
	{
		player = HXPlayerPawn(newInvokeActor);
		InvokeActor = startActor;
	}
	else
	{
		if (newInvokeActor != None) 
			InvokeActor = NewInvokeActor;
		else
			InvokeActor = startActor;
	}

	// Bind the conversation events
	//con.BindEvents(ConActorsBound, invokeActor);
	class'HXActor'.static.BindConsersationEvents( con, ConActorsBound, invokeActor, XLevel );

	// Check to see if the conversation has multiple owners, in which case we 
	// want to rebind all the events with this owner.  This allows conversations
	// to be shared by more than one owner.
	if ((con.ownerRefCount > 1) && (invokeActor != None))
		con.BindActorEvents(invokeActor);

	//Log( "A", 'DevConPlay' );

	// Check to see if all the actors are on the level.
	// Don't check this for InfoLink conversations, since oftentimes
	// the person speaking via InfoLink *won't* be on the map.
	//
	// If a person speaking on the conversation can't be found 
	// (say, they were ruthlessly MURDERED!) then abort.
	//
	// Hi Ken!

	if ( !bForcePlay && !Con.bDataLinkCon )
	{
		if ( !ConCheckActors(Con) )
		{
			Log( "Aborting ConCheckActors failed.", 'DevConPlay' );
			return false;
		}
	}

	//Log( "B", 'DevConPlay' );

	// Now check to make sure that all the actors are a reasonable distance
	// from one another (excluding the player)

	if ( !con.bFirstPerson )
		if ((!bForcePlay) && (!ConCheckActorDistances(Con)))
			return false;
	//Log( Self $ ".StartCoopConversation() readd CheckActorDistances() ", 'DevConPlay' );

	// Save the mission number and location.
	if ( Game.DeusExLevelInfo!=None ) // For what is this actually needed?
	{
		MissionNumber   = Game.DeusExLevelInfo.MissionNumber;
		MissionLocation = Game.DeusExLevelInfo.MissionLocation;
	}

	// Save the conversation radius
	saveRadiusDistance = con.radiusDistance;

	bConversationStarted = True;

	// Super.StartConversation() end.

	bEndingConversation = False;

	// Check to see if this conversation uses random camera placement
	randomCamera = con.bRandomCamera;

	// Based on whether we're in first-person or third-person mode, 
	// we need to derive our conversation window differently.  First-person
	// conversation mode is non-interactive and only allows speech, for
	// the most part.

	if ( con.bFirstPerson )
	{
		displayMode = DM_FirstPerson;

//		conWinFirst = rootWindow.hud.CreateConWindowFirst();

		// Initialize Windowing System
//		conWinFirst.conPlay = Self;
	}
	else
	{
		displayMode = DM_ThirdPerson;

		// Hide the hud display if this is a third-person convo
		//rootWindow.hud.Hide();

		//conWinThird = ConWindowActive(rootWindow.NewChild(Class'ConWindowActive', False));
		//conWinThird.SetForcePlay(bForcePlay);

		// Setup default camera information, but only if bForcePlay is set to false
		if (!bForcePlay)
		{
			//cameraInfo = con.CreateConCamera();
			cameraInfo = CreateConCamera();
			cameraInfo.InitializeCameraValues(Self);

			if ( randomCamera )
				cameraInfo.SetupRandomCameraPosition();

			if ( player != none )
				HXPlayerPawn(player).bInThirdPersonCameraOverride = cameraInfo.CalculateCameraPosition( HXPlayerPawn(player).ThirdPersonCameraViewActor, HXPlayerPawn(player).ThirdPersonCameraLocation, HXPlayerPawn(player).ThirdPersonCameraRotation );
		}

		// Initialize Windowing System
		//conWinThird.conPlay = Self;

		// Align the conversation window
		//conWinThird.SetWindowAlignments(HALIGN_Full, VALIGN_Full);
		//conWinThird.Show();

		HXPlayerPawn(player).ClientCreateConWinThird( bForcePlay );
	}

	// Check to see if this is a passive or interactive conversation
	// Passive conversations are beyond the PC's control and do not have
	// things like Choices, etc. in them.

	if ( con.bNonInteractive )
		playMode = PM_Passive;
	else
		playMode = PM_Active;

	// Grab the first event!
	currentEvent = con.eventList;

	// Create a ConHistory object
//	if (!bForcePlay)
//		SetupHistory(player.GetDisplayName(startActor, True));

	// Play this event!
	GotoState('PlayEvent');

	return true;
}

// ----------------------------------------------------------------------------
// TerminateConversation()
//
// Time to go away to that nice happy place!
// ----------------------------------------------------------------------------

function TerminateConversation( optional bool bContinueSpeech, optional bool bNoPlayedFlag )
{
	// Save this for when we call Super.TerminateConversation() later
	bSaveContinueSpeech = bContinueSpeech;
	bSaveNoPlayedFlag   = bNoPlayedFlag;

	// Some protection to make sure this doesn't happen 
	// more than once.

	if (!bEndingConversation)
	{
		bEndingConversation = True;

		// Tell the Conversation Window to shut down
		//if ((conWinThird != None) && (!bForcePlay))
			//GotoState('WaitForConWin');
		//else
			// HX_NOTE: call it directly
			ConWinFinished();
	}
}

// ----------------------------------------------------------------------------
// State WaitForConWin()
// ----------------------------------------------------------------------------

state WaitForConWin
{
	function Timer()
	{
		if ( (( displayMode == DM_FirstPerson ) && (conWinFirst != None) && ( !conWinFirst.IsVisible())) || 
			 (( displayMode == DM_ThirdPerson ) && (conWinThird != None) && ( !conWinThird.IsVisible())) )
		{
			SetTimer(0, False);
			ConWinFinished();
		}
		else
		{
			SetTimer(0.2, True);
		}
	}

	function PlayNextEvent()
	{
		SetTimer(0, False);
		ConWinFinished();
	}

	function CloseConWindow()
	{
		if ( displayMode == DM_FirstPerson ) 
		{
			if (conWinFirst != None )
				conWinFirst.Close();
		}
		else
		{
			if (conWinThird != None)
				conWinThird.Close();
		}

		// Wait for the window to finish
		SetTimer(0.2, True);
	}

	function BeginState()
	{
		// Allow input
		if (conWinThird != None)
			conWinThird.RestrictInput(False);

		CloseConWindow();
	}
}

// ----------------------------------------------------------------------------
// ConWinFinished()
//
// Called when the conversation window has finished moving and we 
// can destroy the ConPlay actor.
// ----------------------------------------------------------------------------

function ConWinFinished()
{
	// Nuke the conversation window
	if (displayMode == DM_FirstPerson)
	{
		//if (conWinFirst != None)
			//conWinFirst.Destroy();
	}
	else
	{
		//if (conWinThird != None)
			//conWinThird.Destroy();

		// Show the hud display if this was a third-person convo
		//if (!bForcePlay)
			//rootWindow.hud.Show();

		HXPlayerPawn(player).ClientDestroyConWinThird();
	}

	PostTerminateConversation();
 
	// Now nuke ourself.
	Destroy();
}

// ----------------------------------------------------------------------------
// JumpToConversation()
//
// Jumps to another conversation
// ----------------------------------------------------------------------------

function JumpToConversation( Conversation jumpCon, String startLabel )
{
	assert( jumpCon != None );

	// If this is a new conversation, assign it to our "Con" variable
	// and set the con.conName $ "_Played" flag to True.
	if (jumpCon != con)
	{
		SetPlayedFlag();

		// Some cleanup for the existing conversation
		con.ClearBindEvents();
		con.radiusDistance = saveRadiusDistance;

		// Assign the new conversation and bind the events
		con = jumpCon;

		//con.BindEvents(ConActorsBound, startActor);
		class'HXActor'.static.BindConsersationEvents( con, ConActorsBound, startActor, XLevel );
	}

	// Get the event to start at, or the beginning if one wasn't
	// passed in.  However, if a label is passed in *and* it's not 
	// found, then abort the conversation!!

	currentEvent = con.GetEventFromLabel( startLabel );

	if (( currentEvent == None ) && ( startLabel != "" ))
	{
		Log("ConPlay::JumpToConversation() --------------------------------------");
		Log("  WARNING!  Label [" $ startLabel $ "] NOT FOUND in Conversation [" $ jumpCon.conName $ "]");
		log("  Conversation Terminated.");
		TerminateConversation();
		return;
	}

	if ( currentEvent == None )
		currentEvent = con.eventList;

	// Start the conversation!
	GotoState('PlayEvent');
}

// ----------------------------------------------------------------------------
// PostTerminateConversation()
// ----------------------------------------------------------------------------

function PostTerminateConversation()
{
	// Notify the player we're no longer inside 
	// a conversation

	Game.EndConversation();

	// Remove the highlights
	if (cameraInfo != None)
		cameraInfo.DestroyHighlights();

	if ( player != none )
		HXPlayerPawn(player).bInThirdPersonCameraOverride = false;

	// Save the conversation history
//	if ( history != None )
//	{
//		history.next = player.conHistory;
//		player.conHistory = history;
//		history = None;		// in case we get called more than once!!
//	}

	// If the player was holding something when 
	// the conversation started, put the item back 
	// in his hand.
//	if (playerInHand != None)
//		player.PutInHand(playerInHand);

	//Super.TerminateConversation(bSaveContinueSpeech, bSaveNoPlayedFlag);

	// Make sure there's no audio playing
	if (!bSaveContinueSpeech)
		//player.StopSound(playingSoundID);
		Game.BroadcastActorStopSpeech( playingSoundID );

	// Set the played flag
	if (!bSaveNoPlayedFlag)
		SetPlayedFlag();

	// Clear the bound event actors
	con.ClearBindEvents();

	// Reset the conversation radious
	con.radiusDistance = saveRadiusDistance;

	// Notify the conversation participants to go about their
	// business.
	EndConActorStates();

	// HX_NOTE: players seems not to be called by EndConActorStates();
	if ( player != None )
		player.EndConversation();

	con          = None;
	currentEvent = None;
	lastEvent    = None;
}

// ----------------------------------------------------------------------------
// SetPlayedFlag()
// ----------------------------------------------------------------------------

function SetPlayedFlag()
{
	local Name flagName;

	if (con != None)
	{
		// Make a note of when this conversation ended
		con.lastPlayedTime = Level.TimeSeconds;

		flagName = StringToName( con.conName $ "_Played" );

		// Only set the Played flag if it doesn't already exist 
		// (some conversations set this intentionally with a longer expiration
		// date so they can be relied up on in future missions)

		if (!Game.Steve.flagbase.GetBool(flagName))
		{
			// Add a flag noting that we've finished this conversation.  
			Game.Steve.flagbase.SetBool(flagName, True);

			// HX_NOTE: idk if this is really *that* good idea
			Game.FlagReplicationInfo.SetBoolFlag(flagName, True);
		}

		// If this was a third-person convo, keep track of when the conversation
		// ended and who it was with (this is used to prevent radius convos
		// from playing immediately after letterbox convos).
		//
		// If this was a first-person convo, keep track of the owner and 
		// play time so we can prevent multiple radius-induced conversations
		// from playing without a pause (we don't want them to run into 
		// each other).

		if (con.bFirstPerson)
		{
			Game.lastFirstPersonConvoActor = invokeActor;
			Game.lastFirstPersonConvoTime  = con.lastPlayedTime;
		}
		else
		{
			if ( player != None )
			{
				player.lastThirdPersonConvoActor = invokeActor;
				player.lastThirdPersonConvoTime  = con.lastPlayedTime;
			}
		}
	}
}

// ----------------------------------------------------------------------------
// SetInterruptedFlag()
// ----------------------------------------------------------------------------

function SetInterruptedFlag()
{
	local Name flagName;

	if (con != None)
	{
		flagName = StringToName( con.conName $ "_Interrupted" );

		// Add a flag noting that we've finished this conversation.  

		Game.Steve.flagbase.SetBool(flagName, True);
	}
}

// ----------------------------------------------------------------------------
// PlaySpeech()
// ----------------------------------------------------------------------------

function PlaySpeech( int soundID, Actor speaker )
{
	local Sound speech;

	speech = con.GetSpeechAudio(soundID);

	Log( "con.GetSpeechAudio( "$ soundID $ " ) = " $ speech, 'DevConPlay' );

	// Keep a pointer to the current speaking pawn so we can stop 
	// the speech animation when we're finished.

	if ( speaker != None && speaker.IsA('HXPlayerPawn') && speaker != player && player != None )
	{
		speaker = player;
	}

	if (speech != None)
	{
		// If this is an intro/endgame, force speech to play through
		// the player so we can *hear* it.
		if (bForcePlay)
		{
			// Check how close the player is to this actor.  If the player is 
			// close enough to the speaker, play through the speaker.
			if ((speaker == None) || (VSize(player.Location - speaker.Location) > 400))
			{
				//playingSoundID = player.PlaySound(speech, SLOT_Talk,,,65536.0);
				playingSoundID = Game.BroadcastActorSpeech( speech $ "", player, 65536.0 );
			}
			else
			{
				//playingSoundID = speaker.PlaySound(speech, SLOT_Talk,,,65536.0);
				playingSoundID = Game.BroadcastActorSpeech( speech $ "", speaker, 65536.0 );
			}
		}

		// HX_NOTE: won't care for intro/endgame for now
		else
		{
			// If this is a forced conversation (bCannotBeInterrupted = True)
			// then set the radius higher.  This is a hack.  Yes, a hack, 
			// in some situations where the PC is far from one or more speaking
			// NPCs but needs to be able to overhear them.  Also, want to make
			// this reasonably loud for letterbox convos

			if ((con.bCannotBeInterrupted) || (!con.bFirstPerson))
				//playingSoundID = speaker.PlaySound(speech, SLOT_Talk,,,65536.0); 
				playingSoundID = Game.BroadcastActorSpeech( speech $ "", speaker, 65536.0 );
			else
				//playingSoundID = speaker.PlaySound(speech, SLOT_Talk,,,512.0 + initialRadius);
				playingSoundID = Game.BroadcastActorSpeech( speech $ "", speaker, 512.0 + initialRadius );
		}
	}

	StartSpeakingAnimation();
}

// ----------------------------------------------------------------------------
// StopSpeech()
// ----------------------------------------------------------------------------

function StopSpeech()
{
	//player.StopSound(playingSoundID);
	// HX_NOTE: stop sould is probably just passed to USoundSystem,
	// so Actor won't matter
	// but StopSound is never replicated, so pushing sound of crates
	// loops playing, etc.
	//StopSound(playingSoundID);
	Game.BroadcastActorStopSpeech( playingSoundID );

	StopSpeakingAnimation();
}

// ----------------------------------------------------------------------------
// StartSpeakingAnimation()
//
// Start the speaking animation.  We only have animations for Pawns, so if a 
// decoration is speaking there's nothing to animate (this may change).
//
// If this is a speech event, then grab ahold of the speaker.  Otherwise,
// if it's a choice event that's playing the selected choice, the PC 
// is speaking.
// ----------------------------------------------------------------------------

function StartSpeakingAnimation()
{
	local ConEventSpeech CurrentEventSpeech;

	CurrentEventSpeech = ConEventSpeech(CurrentEvent);
	if ( CurrentEventSpeech!=None )
	{
		// Remap Player. GameInfo.BindName defaults to JCDenton.
		if ( CurrentEventSpeech.SpeakerName~=Game.BindName )
			SpeakingActor = Player;
		else
			SpeakingActor = Pawn(CurrentEventSpeech.Speaker);
	}
	else
		SpeakingActor = Player;

	if ( SpeakingActor!=None )
	{
		Pawn(SpeakingActor).bIsSpeaking  = true;
		Pawn(SpeakingActor).bWasSpeaking = true;
		SpeakingActor.SetPropertyText( "bClientIsSpeaking", "True" ); // As bIsSpeaking is not replicated.
	}
}

// ----------------------------------------------------------------------------
// StopSpeakingAnimation()
//
// Stop the speaking animation
// ----------------------------------------------------------------------------

function StopSpeakingAnimation()
{
	if ( Pawn(SpeakingActor)!=None )
	{
		Pawn(SpeakingActor).bIsSpeaking = false;
		SpeakingActor.SetPropertyText( "bClientIsSpeaking", "False" );
		SpeakingActor = None;
	}
}

// ----------------------------------------------------------------------------
// SetupEventSetFlag()
// ----------------------------------------------------------------------------

function EEventAction SetupEventSetFlag( ConEventSetFlag Event, out String NextLabel )
{
	local ConFlagRef Ref;

	Log( "SetupEventSetFlag()------------------------------------------", 'DevConPlay' );
	Log( "  Event = " $ Event, 'DevConPlay' );

	// Just follow the chain of flag references and set the flags to the proper value!
	for ( Ref=Event.FlagRef; Ref!=None; Ref=Ref.NextFlagRef )
	{
		Game.Steve.FlagBase.SetBool( Ref.FlagName, Ref.Value,/*true*/, Ref.Expiration );
		Game.FlagReplicationInfo.SetBoolFlag( Ref.FlagName, Ref.Value );		
	}

	NextLabel = "";
	return EA_NextEvent;
}

// ----------------------------------------------------------------------------
// SetupEventCheckFlag()
// ----------------------------------------------------------------------------

function EEventAction SetupEventCheckFlag( ConEventCheckFlag Event, out String NextLabel )
{
	local ConFlagRef Ref;
	local EEventAction Action;

	Log( "SetupEventCheckFlag()------------------------------------------", 'DevConPlay' );
	Log( "  Event = " $ Event, 'DevConPlay' );
	
	// Loop through our list of FlagRef's, checking the value of each.
	// If we hit a bad match, then we'll stop right away since there's no point of continuing.
	for ( Ref=Event.FlagRef; Ref!=None; Ref=Ref.NextFlagRef )
	{
		if ( Game.Steve.FlagBase.GetBool(Ref.FlagName)!=Ref.Value )
		{
			// Failed to pass.
			NextLabel = "";
			return EA_NextEvent;
		}		
	}

	// Passed.
	NextLabel = Event.SetLabel;
	return EA_JumpToLabel;
}

// ----------------------------------------------------------------------------
// SetupEventSpeechPost()
//
// Display the speech and wait for feedback.
// ----------------------------------------------------------------------------

function EEventAction SetupEventSpeechPost( ConEventSpeech Event, out String NextLabel )
{
	local EEventAction NextAction;
	local Actor Speaker, SpeakingTo;

	local ConEvent checkEvent;
	local String speech;
	local bool bHaveSpeechAudio;
	local HXPlayerPawn			 RelevantPlayers[32];
	local int					 RelevantPlayerCount;
	local Pawn P;
	local int i;
	local string displayName;

	// Remap Player. GameInfo.BindName defaults to JCDenton.
	if ( Event.SpeakerName~=Game.BindName )
		Speaker = Player;
	else
		Speaker = Event.Speaker;
	if ( Event.SpeakingToName~=Game.BindName )
		SpeakingTo = Player;
	else
		SpeakingTo = Event.SpeakingTo;

	Log( "SetupEventSpeechPost()------------------------------------------", 'DevConPlay' );
	Log( "  Event = " $ Event, 'DevConPlay' );
	Log( "  Event.Speaker        = " $ Event.Speaker,        'DevConPlay' );
	Log( "  Event.SpeakerName    = " $ Event.SpeakerName,    'DevConPlay' );
	Log( "  Event.SpeakingTo     = " $ Event.SpeakingTo,     'DevConPlay' );
	Log( "  Event.SpeakingToName = " $ Event.SpeakingToName, 'DevConPlay' );
	Log( "  Event.ConSpeech      = " $ Event.ConSpeech,      'DevConPlay' );
	Log( "  Event.bContinued     = " $ Event.bContinued,     'DevConPlay' );
	Log( "  Event.bBold          = " $ Event.bBold,          'DevConPlay' );
	Log( "  Event.SpeechFont     = " $ Event.SpeechFont,     'DevConPlay' );
	Log( "  Speaker              = " $ Speaker,              'DevConPlay' );
	Log( "  SpeakingTo           = " $ SpeakingTo,           'DevConPlay' );

	bActorsTurned = false;

	// Restrict input until we've finished setting up this event
//	if (conWinThird != None)
//		conWinThird.RestrictInput(True);

	// Keep track of the current speaker and speaking to actors
	if ((currentSpeaker != Speaker) || (currentSpeakingTo != SpeakingTo))
	{
		// If we're in "Random Camera" mode, then we want to 
		// pick a new camera position.

		if ((randomCamera) && (cameraInfo != None))
			cameraInfo.SetupRandomCameraPosition();

		// Update our actor variables
		currentSpeaker    = Speaker;
		currentSpeakingTo = SpeakingTo;

		UpdateCameraInfo();

	}

	// HX: walk through pawn list instead
	for( P = Level.PawnList; P != None; P = P.nextPawn )
		//if ( P.bIsPlayer && CheckRadius( HXPlayerPawn(P), currentSpeaker ) && CheckHeightDifference( HXPlayerPawn(P), currentSpeaker ) )
		if ( P.bIsPlayer && CheckRadius( HXPlayerPawn(P), currentSpeaker ) /* && CheckHeightDifference( HXPlayerPawn(P), currentSpeaker ) */ )
			RelevantPlayers[RelevantPlayerCount++] = HXPlayerPawn(P);

	// Update the Actors used by the camera
	SetCameraActors();

	// Cause the speaking actor to turn towards the person he is
	// speaking to.
	TurnSpeakingActors(Speaker, SpeakingTo);

	// Calculate the length of the text string, this is used later
	speech = event.conSpeech.speech;

	bHaveSpeechAudio = (event.conSpeech.soundID != -1);

	lastSpeechTextLength = len(speech);

	// Display the speech text, if:
	// 
	// 1.  Player has bSubtitles flag on
	// 2.  No speech audio exists for the speech

	if ((Game.bSubtitles) || (!bHaveSpeechAudio))
	{			
//		if ( displayMode == DM_FirstPerson )
//			conWinFirst.Show();

		displayName = Game.GetDisplayName(Speaker);

		// If we're continuing from the last speech, then we want to Append 
		// and not Display the first chunk.
		if ( event.bContinued == True )
		{
			if ( displayMode == DM_FirstPerson )
			{
//				conWinFirst.AppendText( speech );
				if ( speech != "" )
					for ( i = 0; i < RelevantPlayerCount; i ++ )
						RelevantPlayers[i].ClientAddBarkDisplay( speech, FMax(lastSpeechTextLength * perCharDelay, minimumTextPause), displayName );
			}
			else
			{
				//conWinThird.AppendText( speech );
				HXPlayerPawn(player).ClientAddConWinThirdLine( speech );
			}
		}
		else
		{
			if ( displayMode == DM_FirstPerson )
			{
				// Clear the window
//				conWinFirst.Clear();

//				conWinFirst.DisplayName( player.GetDisplayName(Speaker) );
//				conWinFirst.DisplayText( speech, currentSpeaker );

				if ( speech != "" )
					for ( i = 0; i < RelevantPlayerCount; i ++ )
						RelevantPlayers[i].ClientAddBarkDisplay(speech, FMax(lastSpeechTextLength * perCharDelay, minimumTextPause), displayName );
			}
			else
			{
				// Clear the window
				//conWinThird.Clear();

				//conWinThird.DisplayName(  );
				//conWinThird.DisplayText( speech, currentSpeaker );

				HXPlayerPawn(player).ClientDisplayConWinThirdLine( displayName, speech, currentSpeaker );

				if ( speech != "" )
					for ( i = 0; i < RelevantPlayerCount; i ++ )
						if ( RelevantPlayers[i] != player )
							RelevantPlayers[i].ClientAddBarkDisplay(speech, FMax(lastSpeechTextLength * perCharDelay, minimumTextPause), displayName );
			}
		}
	}
	else if (displayMode == DM_FirstPerson)
	{
//		conWinFirst.Hide();
	}

	// Save this event in the history
//	AddHistoryEvent(player.GetDisplayName(Speaker, True), event.conSpeech);

	if ( player != none && displayMode == DM_ThirdPerson )
		HXPlayerPawn(player).bInThirdPersonCameraOverride = cameraInfo.CalculateCameraPosition( HXPlayerPawn(player).ThirdPersonCameraViewActor, HXPlayerPawn(player).ThirdPersonCameraLocation, HXPlayerPawn(player).ThirdPersonCameraRotation );


	// If we have speech audio, play it!
	if (bHaveSpeechAudio)
	{
		nextAction = EA_WaitForSpeech;
	}
	else
	{
		// Otherwise, we'll wait for the text to play (either in passive mode, which
		// means the text will continue on its own, or in ACTIVE mode, in which case
		// we'll wait for a keypress before continuing.

		if (( playMode == PM_PASSIVE ) || ( displayMode == DM_FirstPerson ))
		{
			nextAction = EA_WaitForText;
		}
		else
		{
			// If we're here, we either have no speech or we're in a text-only mode
			//
			// We want to wait for input unless the next event is a 
			// speech event and has the "Continued" flag set, which 
			// allows for additional speech and choices to 
			// appear immediately after the current speech.
			//
			// Choices automatically continue unless they have the "Clear Screen"
			// flag set.

			checkEvent = GetNextEvent();

			if ( (( ConEventChoice(checkEvent) != None ) && ( !ConEventChoice(checkEvent).bClearScreen )) || 
			   (( ConEventSpeech(checkEvent) != None ) && ( ConEventSpeech(checkEvent).bContinued )) )
				nextAction = EA_NextEvent;
			else
				nextAction = EA_WaitForInput;
		}
	}

	nextLabel = "";
	return nextAction;
}

// ----------------------------------------------------------------------------
// SetupEventChoice()
// ----------------------------------------------------------------------------

function EEventAction SetupEventChoice( ConEventChoice Event, out String NextLabel )
{
	local ConChoice choice;
	//local ButtonWindow newButton;
	local int choiceCount;
	local EEventAction nextAction;
	local int choiceMask;
	local class<Actor> SkillNeeded;

	Log( "SetupEventChoice()------------------------------------------", 'DevConPlay' );
	Log( "  Event = " $ Event, 'DevConPlay' );
	Log( "  Event.bClearScreen = " $ Event.bClearScreen, 'DevConPlay' );

	// Notify the conversation window to ignore input until we're done
	// creating the choices (this is done to prevent the user from being
	// able to make a choice while drawing, only a problem on slow machines)

	//if (conWinThird != None)
		//conWinThird.RestrictInput(True);

	// For choices, the speaker is always the player.  The person being 
	// spoken to, well, that's more complicated (unless I force that to be
	// set in ConEdit).  For now we'll assume that the owner of the 
	// conversation is the person being spoken to.

	currentSpeaker    = player;
	currentSpeakingTo = startActor;
	
	// Update the Actors used by the camera
	SetCameraActors();

	// Clear the screen if need be
	//if ( event.bClearScreen )
		//conWinThird.Clear();

	// Okay, we want to create as many buttons as we have choices
	// and display them.  We'll then return and let conPlay get some
	// user input.  

	ClearSavedChoices();

	choice = event.ChoiceList;
	choiceCount = 0;

	while( choice != None )
	{	
		// Before we blindly display this choice, we first need to check a 
		// few things.  Specifically: 
		// 
		// 1.  Check to see if any flags are associated with this choice.
		// 2.  Check to see if this choice is skill-based.
		// 3.  If there are *NO* valid choices, skip to the next event
		//     as a failsafe
		//
		// If the above conditions are met, then display the choice.
		
		if ( Game.CheckFlagRefs( choice.flagRef ) )
		{			
			// Now check the skills.
			SkillNeeded = class<Actor>(Choice.SkillNeeded);
			if ( SkillNeeded!=None )
			{
				Game.ModifyActorClass( SkillNeeded );

				Log( "SkillNeeded is " $ SkillNeeded, 'DevConPlay' );

				// Does player have it?
				if ( Player.SkillSystem.IsSkilled(SkillNeeded,Choice.SkillLevelNeeded) )
				{
					// Display the choice with some feedback!
					//conWinThird.DisplaySkillChoice( choice );
					choiceMask += 1 << choiceCount;
					SavedChoices[SavedChoicesCount++] = choice;
				}
			}
			else
			{
				// Plain old vanilla choice
				//conWinThird.DisplayChoice(choice);
				choiceMask += 1 << choiceCount;
				SavedChoices[SavedChoicesCount++] = choice;
			}
		}

		choiceCount++;
		choice = choice.nextChoice;
	}

	HXPlayerPawn(player).ClientDisplayConWinThirdChoice( event, choiceMask );

	if ( player != none && displayMode == DM_ThirdPerson )
		HXPlayerPawn(player).bInThirdPersonCameraOverride = cameraInfo.CalculateCameraPosition( HXPlayerPawn(player).ThirdPersonCameraViewActor, HXPlayerPawn(player).ThirdPersonCameraLocation, HXPlayerPawn(player).ThirdPersonCameraRotation );

	nextLabel = "";

	//if ( choiceCount > 0 ) 
	if ( choiceMask != 0 )
		nextAction = EA_WaitForInput;
	else
		nextAction = EA_NextEvent;

	// Okay to accept user input again
	//if (conWinThird != None)
		//conWinThird.RestrictInput(False);

	return nextAction;
}

// ----------------------------------------------------------------------------
// PlayChoiceByIndex()
// ----------------------------------------------------------------------------

function PlayChoiceByIndex( int Index )
{
	local ConChoice TempChoice;

	if ( Index<0 || Index>=SavedChoicesCount )
	{
		Warn( "PlayChoiceByIndex: Invalid index." ); // !! Terminate conversation ??
		return;
	}

	TempChoice = SavedChoices[Index];

	if ( TempChoice==None )
	{
		Warn( "PlayChoiceByIndex: TempChoice is None." );  // !! Terminate conversation ??
		return; 
	}

	ClearSavedChoices();

	PlayChoice( TempChoice );
}

// ----------------------------------------------------------------------------
// PlayChoice()
//
// Called from ConWindow object when a choice is selected
// ----------------------------------------------------------------------------

function PlayChoice( ConChoice choice )
{
	local ConSpeech choiceSpeech;
	local Pawn P;

	// First, save the choice text, but only if the DisplayAsSpeech 
	// flag isn't set, in which case the speech will be setup as a 
	// speech event and saved that way.

	if ( !choice.bDisplayAsSpeech )
	{
		choiceSpeech = new(None) Class'ConSpeech';
		choiceSpeech.speech = choice.choiceText;	
		choiceSpeech.soundID = choice.soundID;

		// HX: walk through pawn list instead
		for( P = Level.PawnList; P != None; P = P.nextPawn )
			//if ( P.bIsPlayer && CheckRadius( HXPlayerPawn(P), currentSpeaker ) && CheckHeightDifference( HXPlayerPawn(P), currentSpeaker ) )
			if ( P.bIsPlayer && CheckRadius( HXPlayerPawn(P), currentSpeaker ) /* && CheckHeightDifference( HXPlayerPawn(P), currentSpeaker ) */ )
				if ( P != Player )
					HXPlayerPawn(P).ClientAddBarkDisplay( choice.choiceText, FMax(Len(choice.choiceText) * perCharDelay, minimumTextPause), "JC Denton" );

		//AddHistoryEvent(player.GetDisplayName(player, True), choiceSpeech );
	}

	// If this choice has a label, then jump to it.  Otherwise just
	// continue with the conversation.

	if ( choice.choiceLabel != "" ) 
		ProcessAction( EA_JumpToLabel, choice.choiceLabel );
	else
		ProcessAction( EA_NextEvent, "" );
}

// ----------------------------------------------------------------------------
// ClearSavedChoices()
// ----------------------------------------------------------------------------

function ClearSavedChoices()
{
	local int i;

	for ( i = 0; i < 10; i++ )
		SavedChoices[i] = None;

	SavedChoicesCount = 0;
}

// ----------------------------------------------------------------------------
// SetupEventMoveCamera()
// ----------------------------------------------------------------------------

function EEventAction SetupEventMoveCamera( ConEventMoveCamera Event, out String NextLabel )
{
	Log( "SetupEventMoveCamera()------------------------------------------", 'DevConPlay' );
	Log( "  Event = " $ Event, 'DevConPlay' );

	PendingCameraEvent = Event;

	NextLabel = "";
	return EA_NextEvent;
}

// ----------------------------------------------------------------------------
// SetupEventAddGoal()
//
// TODO: Add support for goals longer than 255 characters.  
// ----------------------------------------------------------------------------

function EEventAction SetupEventAddGoal( ConEventAddGoal Event, out String NextLabel )
{
	Log( "SetupEventAddGoal()------------------------------------------", 'DevConPlay' );
	Log( "  Event = " $ Event, 'DevConPlay' );
	Log( "  Event.GoalName       = " $ Event.GoalName,       'DevConPlay' );
	Log( "  Event.GoalText       = " $ Event.GoalText,       'DevConPlay' );
	Log( "  Event.bPrimaryGoal   = " $ Event.bPrimaryGoal,   'DevConPlay' );
	Log( "  Event.bGoalCompleted = " $ Event.bGoalCompleted, 'DevConPlay' );

	if ( !Event.bGoalCompleted )
	{
		// add goal
		Game.AddGoal( Event.GoalName, Event.bPrimaryGoal, Event.GoalText );
	}
	else
	{
		// mark as completed
		Game.GoalCompleted( Event.goalName ); 
	}
	return EA_NextEvent;
}

// ----------------------------------------------------------------------------
// SetupEventAddNote()
//
// TODO: Add support for notes longer than 255 characters.  
// ----------------------------------------------------------------------------

function EEventAction SetupEventAddNote( ConEventAddNote Event, out String NextLabel )
{
	Log( "SetupEventAddNote()------------------------------------------", 'DevConPlay' );
	Log( "  Event = " $ Event, 'DevConPlay' );
	Log( "  Event.NoteText   = " $ Event.NoteText,   'DevConPlay' );
	Log( "  Event.bNoteAdded = " $ Event.bNoteAdded, 'DevConPlay' );

	// Only add the note if it hasn't been added already (in case the PC has the same conversation more than once)
	if ( !Event.bNoteAdded )
	{
		// Add the note to the player's list of notes
		Game.AddNote( Event.NoteText, False, True );
		Event.bNoteAdded = True;
	}
	return EA_NextEvent;
}

// ----------------------------------------------------------------------------
// SetupEventAddSkillPoints()
// ----------------------------------------------------------------------------

function EEventAction SetupEventAddSkillPoints( ConEventAddSkillPoints Event, out String NextLabel )
{
	Log( "SetupEventAddSkillPoints()------------------------------------------", 'DevConPlay' );
	Log( "  Event = " $ Event, 'DevConPlay' );
	Log( "  Event.PointsToAdd  = " $ Event.PointsToAdd,  'DevConPlay' );
	Log( "  Event.AwardMessage = " $ Event.AwardMessage, 'DevConPlay' );

	Game.SkillPointsAdd( Event.PointsToAdd, "(Conversation)" );
	NextLabel = "";
	return EA_NextEvent;
}

// ----------------------------------------------------------------------------
// SetupEventCheckObject()
//
// Checks to see if the player has the given object.  If so, then we'll
// just fall through and continue running code.  Otherwise we'll jump
// to the supplied label.
// ----------------------------------------------------------------------------

function EEventAction SetupEventCheckObject( ConEventCheckObject Event, out String NextLabel )
{
	local EEventAction NextAction;
	local Name KeyName;
	local bool bHasObject;
	local Class<Inventory> CheckObject;
	local HXScriptedPawn ScriptedPawn;
	local HXPlayerPawn CheckPlayer;

	Log( "SetupEventCheckObject()------------------------------------------", 'DevConPlay' );
	Log( "  Event = " $ Event, 'DevConPlay' );
	Log( "  Event.CheckObject = " $ Event.CheckObject, 'DevConPlay' );
	Log( "  Event.ObjectName  = " $ Event.ObjectName,  'DevConPlay' );

	// No Object. Either NanoKey or bug.
	if ( Event.CheckObject==None )
	{
		// Okay this is some HackyHack stuff here.  We want the ability to check if the players have a particular nanokey. Sooooooo.
		if ( Left(Event.ObjectName,3)~="NK_" )
		{
			// Look for key
			KeyName    = StringToName( Right(Event.ObjectName,Len(Event.ObjectName)-3) );
			bHasObject = Game.HasKey( KeyName );
		}
		else
		{
			// This gets a little to philosophical for me, but an empty set is subset of any set. --han
			bHasObject = false;
		}
	}
	else
	{
		// Let GameInfo/Mutator logic modify the item class.
		CheckObject = Event.CheckObject;
		Game.ModifyInventoryClass( CheckObject );

		// Special case for first person conversations. Set it to the nearest player.
		// This is needed for training trooper giving the player LAMs. !! Sure?
		if ( DisplayMode==DM_FirstPerson )
		{
			// Staged attempts to get pawn.
			ScriptedPawn = HXScriptedPawn(StartActor);
			if ( ScriptedPawn==None )
				ScriptedPawn = HXScriptedPawn(InvokeActor);

			// Set to closest player.
			if ( ScriptedPawn!=None )
				CheckPlayer = ScriptedPawn.GetNearestPlayer();
		}
		else
		{
			CheckPlayer = HXPlayerPawn(Player);
		}
		Log( "  CheckPlayer       = " $ CheckPlayer,       'DevConPlay' );

		bHasObject = CheckObject!=None && CheckPlayer.FindInventoryType(CheckObject)!=None;
	}

	// Now branch appropriately.
	if ( bHasObject )
	{
		NextAction = EA_NextEvent;
		NextLabel  = "";
	}
	else
	{
		NextAction = EA_JumpToLabel;
		NextLabel  = Event.FailLabel;
	}
	return NextAction;
}

// ----------------------------------------------------------------------------
// SetupEventTransferObject()
//
// Gives a Pawn the specified object.  The object will be created out of
// thin air (spawned) if there's no "fromActor", otherwise it's 
// transfered from one pawn to another.
//
// We now allow this to work without the From actor, which can happen
// in InfoLinks, since the FromActor may not even be on the map.
// This is useful for tranferring DataVaultImages.
// ----------------------------------------------------------------------------

function EEventAction SetupEventTransferObject( ConEventTransferObject Event, out String NextLabel )
{
	local EEventAction NextAction;
	local HXScriptedPawn ScriptedPawn;
	local HXPlayerPawn ToPlayer, FromPlayer;
	local Pawn ToPawn, FromPawn;
	local int i, NumCredits, TempX, TempY, TransferCount, ItemsTransferred, TransferAmmoCount;
	local class<Inventory> GiveObject;
	local Inventory InvItemFrom, InvItemTo;
	local class<HXPickup> PickupClass;
	local HXPickup PickupFrom, PickupTo;
	local class<HXWeapon> WeaponClass;
	local HXWeapon WeaponFrom, WeaponTo;
	local class<HXAmmo> AmmoClass;
	local HXAmmo AmmoFrom, AmmoTo, WeaponAmmoTo;
	local class<HXCredits> CreditsClass;

	// Needed later on?
	local HXAmmo AmmoType;
	local bool bSpawnedItem;
	local bool bSplitItem;

	// Hackfix for FordSchick in Mission08.
	if ( Event.GiveObject==None && Event.ObjectName=="AugmentationUpgrade" )
		Event.GiveObject = Class'AugmentationUpgradeCannister';

	if ( Event.GiveObject==None )
		Warn( "(Event.GiveObject=None,Event.ObjectName="$Event.ObjectName$")" );

	// Create local copy of GiveObject and let GameInfo/Mutator logic modify it.
	GiveObject = Event.GiveObject;
	if ( GiveObject!=None )
		Game.ModifyInventoryClass( GiveObject );
	// What about overriding Event.GiveObject? --han

	Log( "SetupEventTransferObject()------------------------------------------", 'DevConPlay' );
	Log( "  Event = " $ Event, 'DevConPlay' );
	Log( "  Event.ObjectName = " $ Event.ObjectName, 'DevConPlay' );
	Log( "  Event.GiveObject = " $ Event.GiveObject, 'DevConPlay' );
	Log( "  Event.FromActor  = " $ Event.FromActor,  'DevConPlay' );
	Log( "  Event.ToActor    = " $ Event.ToActor,    'DevConPlay' );
	Log( "  GiveObject       = " $ GiveObject,       'DevConPlay' );

	// Event.FromActor and Event.ToActor are not always the right player in mp.
	if ( Event.FromActor!=None && Event.FromActor.IsA('HXPlayerPawn') && Event.FromActor!=Player )
	{
		Log( Sprintf("SetupEventTransferObject: Fixed wrong Player FromActor (Old=%s,New=%s).",Event.FromActor,Player), 'DevConPlay' );

		Event.FromActor = Player;
	}
	if ( Event.ToActor!=None && Event.ToActor.IsA('HXPlayerPawn') )
	{
		// Special case for first person conversations. Set it to the nearest player.
		// This is needed for training trooper giving the player LAMs.
		if ( DisplayMode==DM_FirstPerson )
		{
			// Staged attempts to get pawn.
			ScriptedPawn = HXScriptedPawn(Event.FromActor);
			if ( ScriptedPawn==None )
				ScriptedPawn = HXScriptedPawn(StartActor);
			if ( ScriptedPawn==None )
				ScriptedPawn = HXScriptedPawn(InvokeActor);

			// Set to closest player.
			if ( ScriptedPawn!=None )
			{
				Event.ToActor = ScriptedPawn.GetNearestPlayer();

				Log( Sprintf("SetupEventTransferObject: Set Event.ToActor to nearest player for DM_FirstPerson (Event.ToActor=%s).",Event.ToActor), 'DevConPlay' );
			}
			else
			{
				// Avoid sending it to a random player... Maybe not ideal, but.. Fail here?
				Event.ToActor = None;

				Log( Sprintf("SetupEventTransferObject: Couldn't set Event.ToActor to nearest player for DM_FirstPerson: No ScriptedPawn. Setting it to None."), 'DevConPlay' );
			}
		}
		else
		{
			if ( Event.ToActor!=Player )
				Log( Sprintf("SetupEventTransferObject: Fixed wrong Player ToActor (Old=%s,New=%s).",Event.ToActor,Player), 'DevConPlay' );

			Event.ToActor = Player;
		}
	}

	// Setup FailLabel.
	if ( Event.FailLabel!="" )
	{
		NextAction = EA_JumpToLabel;
		NextLabel  = Event.FailLabel;
	}
	else
	{
		NextAction = EA_NextEvent;
		NextLabel  = "";
	}

	// First verify that the receiver exists!
	if ( Event.ToActor==None )
	{
		Warn( "SetupEventTransferObject: ToActor does not exist!" );
		Log( "  Conversation = " $ Con.ConName, 'DevConPlay' );
		return NextAction;
	}

	//
	// Transfer item to Player.
	//
	if ( Event.ToActor!=None && Event.ToActor.IsA('HXPlayerPawn') )
	{
		Log( "  Giving item from pawn to player. ", 'DevConPlay' );

		FromPawn = Pawn(Event.FromActor);
		ToPlayer = HXPlayerPawn(Event.ToActor);
		
		Log("  FromPawn = " $ FromPawn, 'DevConPlay' );
		Log("  ToPlayer = " $ ToPlayer, 'DevConPlay' );

		// Figure out if the item alreadys exists in inventory.
		InvItemTo = ToPlayer.FindInventoryType( GiveObject );
		if ( FromPawn!=None )
			InvItemFrom = FromPawn.FindInventoryType( GiveObject );

		Log("  InvItemFrom = " $ InvItemFrom, 'DevConPlay' );
		Log("  InvItemTo   = " $ InvItemTo,   'DevConPlay' );

		// Special handling for DataVaultImages.
		if ( ClassIsChildOf(GiveObject,class'DataVaultImage') )
		{
			Game.AddImage( class<DataVaultImage>(GiveObject), true );

			// Cleanup in case the pawn had the DataVaultImage.
			if ( InvItemFrom!=None )
				InvItemFrom.Destroy();

			//
			// TODO -- ADD RECEIVED DISPLAY -- (GiveObject,1)
			//

			NextLabel = "";
			return EA_NextEvent;
		}

		// Special handling for credits.
		else if ( ClassIsChildOf(GiveObject,Class'HXCredits') )
		{
			// Check if the credits chit exist.
			if ( InvItemFrom!=None )
			{
				NumCredits += HXCredits(InvItemFrom).NumCredits;
				InvItemFrom.Destroy();
			}
			else
			{
				CreditsClass = class<HXCredits>(GiveObject);

				// No need to spawn a new actor.
				NumCredits += CreditsClass.default.NumCredits;

				Warn( "No Credits item found to transfer, transfering default class amount!" );
			}

			if ( NumCredits>0 )
			{
				ToPlayer.Credits += NumCredits;

				//
				// TODO -- ADD RECEIVED DISPLAY (And maybe a ClientMessage) -- (Credits,NumCredits)
				//
			}
			else
			{
				Warn( "Wanted to transfer " $ NumCredits $ "!" );
			}
			
			NextLabel = "";
			return EA_NextEvent;
		}

		// Special handling for nanokeys.
		else if ( ClassIsChildOf(GiveObject,Class'HXNanoKey') )
		{
			// Maybe put a warning and fail if the Key doesn't exist? --han

			Game.PickupNanoKey( HXNanoKey(InvItemFrom) );
			InvItemFrom.Destroy();

			//
			// TODO -- ADD RECEIVED DISPLAY (And maybe a ClientMessage) -- (NanoKey,1)
			//

			NextLabel = "";
			return EA_NextEvent;
		}

		// Special handling for Pickups.
		else if ( ClassIsChildOf(GiveObject,Class'HXPickup') )
		{
			PickupClass = class<HXPickup>(GiveObject);
			PickupFrom  = HXPickup(InvItemFrom);
			PickupTo    = HXPickup(InvItemTo);

			Log( "  PickupClass = " $ PickupClass, 'DevConPlay' );
			Log( "  PickupFrom  = " $ PickupFrom,  'DevConPlay' );
			Log( "  PickupTo    = " $ PickupTo,    'DevConPlay' );

			// Transfer at least one item.
			TransferCount = Max(Event.TransferCount,1);

			// Non stackable Pickups (DeusEx always just transferes one item in this case).
			// Maybe make a loop and transfer multiple if that ever happens?
			if ( !PickupClass.Default.bCanHaveMultipleCopies )
			{
				// Notify if this actually happens.
				if ( Event.TransferCount!=1 )
					Warn( "Wanted to transfer " $ Event.TransferCount $ " items of class " $ PickupClass $ "but !bCanHaveMultipleCopies forced 1." );

				// Check if there is enough space in grid inventory for a new item.
				if ( PickupClass.Default.InvSlotsX>0 && PickupClass.Default.InvSlotsY>0 && !ToPlayer.FindInventorySpace(PickupClass.Default.InvSlotsX,PickupClass.Default.InvSlotsY,TempX,TempY) )
				{
					Log( "  Aborting (No free inventory space).", 'DevConPlay' );
					return NextAction;
				}

				// If Pawn doesn't have this item, spawn it.
				if ( PickupFrom==None )
				{
					PickupFrom = Spawn( PickupClass, ToPlayer );
					PickupFrom.Frob( ToPlayer, None );
					if ( Level.Game.ShouldRespawn(PickupFrom) )
						PickupFrom.Destroy();
				}
				else // PickupFrom!=None
				{
					GivePlayerInventory( ToPlayer, PickupFrom );
				}

				ItemsTransferred = 1;
			}
			// Stackable Pickups.
			else // PickupClass.Default.bCanHaveMultipleCopies
			{
				// Transfer MaxCopies at most.
				TransferCount = Min(Event.TransferCount,PickupClass.Default.MaxCopies);

				// Check if there is enough space in grid inventory for a new item.
				if ( PickupTo==None )
					if ( PickupClass.Default.InvSlotsX>0 && PickupClass.Default.InvSlotsY>0 && !ToPlayer.FindInventorySpace(PickupClass.Default.InvSlotsX,PickupClass.Default.InvSlotsY,TempX,TempY) )
						return NextAction;

				// Make sure Player is not a Maximum amount of copies.
				if ( PickupTo!=None )
					if ( PickupTo.NumCopies>=PickupTo.MaxCopies )
						return NextAction;

				// Player and Pawn do not have this item
				if ( PickupTo==None && PickupFrom==None )
				{
					PickupFrom = Spawn( PickupClass, ToPlayer );
					PickupFrom.NumCopies = TransferCount;
					PickupFrom.Frob( ToPlayer, None );
					if ( Level.Game.ShouldRespawn(PickupFrom) )
						PickupFrom.Destroy();

					ItemsTransferred = TransferCount;
				}
				// Just Pawn has this item.
				else if ( PickupTo==None ) // PickupFrom!=None
				{
					Log( "  PickupTo==None => PickupFrom.NumCopies = " $ PickupFrom.NumCopies, 'DevConPlay' );
					Log( "  PickupTo==None => TransferCount        = " $ TransferCount,  'DevConPlay' );

					// Pawn has more copies then are going to be transfered, so split it.
					if ( PickupFrom.NumCopies>TransferCount )
					{
						PickupFrom.NumCopies -= TransferCount;

						PickupTo = Spawn( PickupClass, ToPlayer );
						PickupTo.NumCopies = TransferCount;
						PickupTo.Frob( ToPlayer, None );
						if ( Level.Game.ShouldRespawn(PickupTo) )
							PickupTo.Destroy();
					}
					// Pawn has less or equal the TransferCount copies. Set NumCopies to TransferCount.
					// TODO: Check if DeusEx actually does it this way.
					else
					{
						PickupFrom.NumCopies = TransferCount;
						GivePlayerInventory( ToPlayer, PickupFrom );
					}

					ItemsTransferred = TransferCount;
				}
				// Just Player has this item.
				else if ( PickupFrom==None ) // PickupTo!=None
				{
					// Transfer just up to (MaxCopies-NumCopies).
					TransferCount       = Min(TransferCount,PickupTo.MaxCopies-PickupTo.NumCopies);
					PickupTo.NumCopies += TransferCount;
					ItemsTransferred    = TransferCount;
				}
				// Player and Pawn have this item.
				else // PickTo!=None && PickupFrom!=None
				{
					// Transfer just up to (MaxCopies-NumCopies).
					TransferCount         = Min(TransferCount,PickupTo.MaxCopies-PickupTo.NumCopies);
					PickupTo.NumCopies   += TransferCount;
					PickupFrom.NumCopies -= TransferCount;
					ItemsTransferred      = TransferCount;

					// Destroy the Pawns item if it's empty.
					if ( PickupFrom.NumCopies<=0 )
						PickupFrom.Destroy();
				}
			}

			//
			// TODO -- ADD RECEIVED DISPLAY -- (PickupClass,ItemsTransferred).
			//

			NextLabel = "";
			return EA_NextEvent;
		}

		// Special handling for Weapons. If Player has already this weapon, just add the Ammo.
		else if ( ClassIsChildOf(GiveObject,Class'HXWeapon') )
		{
			WeaponClass = Class<HXWeapon>(GiveObject);
			WeaponFrom  = HXWeapon(InvItemFrom);
			WeaponTo    = HXWeapon(InvItemTo);

			Log( "  WeaponClass = " $ WeaponClass, 'DevConPlay' );
			Log( "  WeaponFrom  = " $ WeaponFrom,  'DevConPlay' );
			Log( "  WeaponTo    = " $ WeaponTo,    'DevConPlay' );

			// Check if there is enough space in grid inventory for a new weapon.
			if ( WeaponTo==None )
			{
				if ( WeaponClass.Default.InvSlotsX>0 && WeaponClass.Default.InvSlotsY>0 && !ToPlayer.FindInventorySpace(WeaponClass.Default.InvSlotsX,WeaponClass.Default.InvSlotsY,TempX,TempY) )
				{
					Log( "  Aborting (No free inventory space).", 'DevConPlay' );
					return NextAction;
				}
			}
			// If Player owns the Weapon. Check if the default Ammo is not at max.
			else // WeaponTo!=None
			{
				WeaponAmmoTo = HXAmmo(ToPlayer.FindInventoryType(WeaponClass.Default.AmmoName));
				if ( WeaponAmmoTo.AmmoAmount>=WeaponAmmoTo.MaxAmmo )
				{
					Log( "  Aborting (MaxAmmo reached).", 'DevConPlay' );
					return NextAction;
				}
			}

			// Transfer at least one weapon.
			TransferCount     = Max(Event.TransferCount,1);
			TransferAmmoCount = TransferCount * WeaponClass.Default.PickupAmmoCount;

			Log( "  TransferCount     = " $ TransferCount,     'DevConPlay' );
			Log( "  TransferAmmoCount = " $ TransferAmmoCount, 'DevConPlay' );

			// Player and Pawn do not have this Weapon.
			if ( WeaponTo==None && WeaponFrom==None )
			{
				// Just spawn a new Weapon and give it the to the Player.
				WeaponTo = Spawn( WeaponClass, ToPlayer );
				WeaponTo.PickupAmmoCount = TransferAmmoCount;
				WeaponTo.Frob( ToPlayer, None );
				if ( Level.Game.ShouldRespawn(WeaponTo) )
					WeaponTo.Destroy();
			}
			// Just Pawn has this Weapon.
			else if ( WeaponTo==None ) // PickupFrom!=None
			{
				WeaponFrom.PickupAmmoCount = TransferAmmoCount;
				WeaponFrom.AmmoType        = None; // !! Just to be sure.

				GivePlayerInventory( ToPlayer, WeaponFrom );
			}
			// Just Player has this Weapon.
			else if ( WeaponFrom==None ) // WeaponTo!=None
			{
				// Player should have the default ammo type for this weapon.
				if ( WeaponAmmoTo!=None )
				{
					WeaponAmmoTo.AddAmmo( TransferAmmoCount );
				}
				// This should actually never happend.
				else
				{
					AmmoTo = HXAmmo( Spawn(WeaponClass.Default.AmmoName,ToPlayer) );
					AmmoTo.AmmoAmount = TransferAmmoCount;
					AmmoTo.Frob( ToPlayer, None );
					if ( Level.Game.ShouldRespawn(AmmoTo) )
						AmmoTo.Destroy();
				}
			}
			// Player and Pawn have this Weapon.
			else // WeaponTo!=None && WeaponFrom!=None
			{
				// Player should have the default ammo type for this weapon.
				if ( WeaponAmmoTo!=None )
				{
					WeaponAmmoTo.AddAmmo( TransferAmmoCount );
				}
				// This should actually never happend.
				else
				{
					AmmoTo = HXAmmo( Spawn(WeaponClass.Default.AmmoName,ToPlayer) );
					AmmoTo.AmmoAmount = TransferAmmoCount;
					AmmoTo.Frob( ToPlayer, None );
					if ( Level.Game.ShouldRespawn(AmmoTo) )
						AmmoTo.Destroy();
				}

				// Delete Pawns Weapon. What about Ammo?
				WeaponFrom.Destroy();
			}

			//
			// TODO -- ADD RECEIVED DISPLAY -- (WeaponClass,1?).
			//

			NextLabel = "";
			return EA_NextEvent;
		}

		// Special handling for Ammo. Kinda sucks that this is the whole carried ammo in case InvItemFrom!=None. --han
		else if ( ClassIsChildOf(GiveObject,Class'HXAmmo') )
		{
			AmmoClass = Class<HXAmmo>(GiveObject);
			AmmoFrom  = HXAmmo(InvItemFrom);
			AmmoTo    = HXAmmo(InvItemTo);

			Log( "  AmmoClass = " $ AmmoClass, 'DevConPlay' );
			Log( "  AmmoFrom  = " $ AmmoFrom,  'DevConPlay' );
			Log( "  AmmoTo    = " $ AmmoTo,    'DevConPlay' );

			// Check if AmmoAmount is at Max.
			if ( AmmoTo!=None )
				if ( AmmoTo.AmmoAmount>=AmmoTo.MaxAmmo )
					return NextAction;

			// DeusEx seems to transfer exactly one Ammo item.
			ItemsTransferred = 1;

			// Player and Pawn do not have this Ammo.
			if ( AmmoTo==None && AmmoFrom==None )
			{
				AmmoFrom = Spawn( AmmoClass, ToPlayer );
				AmmoFrom.Frob( ToPlayer, None );
				if ( Level.Game.ShouldRespawn(AmmoFrom) )
					AmmoFrom.Destroy();
			}
			// Just Pawn has this Ammo.
			else if ( AmmoTo==None ) // AmmoFrom!=None
			{
				AmmoTo = Spawn( AmmoClass, ToPlayer );
				AmmoTo.AmmoAmount = AmmoFrom.AmmoAmount;
				AmmoTo.Frob( ToPlayer, None );
				if ( Level.Game.ShouldRespawn(AmmoTo) )
					AmmoTo.Destroy();

				// See comment under else.
				AmmoFrom.AmmoAmount = AmmoClass.Default.AmmoAmount;
			}
			// Just Player has this Ammo.
			else if ( AmmoFrom==None ) // AmmoTo!=None
			{
				// Just add default AmmoAmount.
				AmmoTo.AddAmmo( AmmoClass.Default.AmmoAmount );
			}
			// Player and Pawn have this Ammo.
			else // AmmoTo!=None && AmmoFrom!=None
			{
				AmmoTo.AddAmmo( AmmoFrom.AmmoAmount );
				// DeusEx seems to call Destroy. However that is probably
				// not that great idea if the pawn has a weapon which uses that ammo.
				//AmmoFrom.Destroy();
				// Kaplan should continue carry and use his Pistol.
				// Setting it zero is probably no good idea either.
				//AmmoFrom.AmmoAmount = 0;
				// Maybe scan through inventory and add the default Weapon.PickupAmmoCount.
				// I wouldn't be suprised if original code added either Default.AmmoAmout
				// or Weapon.PickupAmmoCount if no Ammo was found..
				AmmoFrom.AmmoAmount = AmmoClass.Default.AmmoAmount;
			}

			//
			// TODO -- ADD RECEIVED DISPLAY -- (AmmoClass,1).
			//

			NextLabel = "";
			return EA_NextEvent;
		}

		// Unhandled inventory type.
		else
		{
			Warn( "[Pawn->Player] Unhandled Inventory class" $ GiveObject $ "!" );

			// Pretend everything is fine.
			NextLabel = "";
			return EA_NextEvent;
		}
	}

	//
	// Transfer item from player to pawn.
	//
	else if ( Event.FromActor!=None && Event.FromActor.IsA('HXPlayerPawn') )
	{
		Log( "  Giving item from player to pawn. ", 'DevConPlay' );

		FromPlayer = HXPlayerPawn(Event.FromActor);
		ToPawn     = Pawn(Event.ToActor);

		// Figure out if the item alreadys exists in inventory.
		InvItemFrom = FromPlayer.FindInventoryType( GiveObject );
		InvItemTo   = ToPawn.FindInventoryType( GiveObject );

		Log("  InvItemFrom = " $ InvItemFrom, 'DevConPlay' );
		Log("  InvItemTo   = " $ InvItemTo,   'DevConPlay' );

		// Special handling for Pickups.
		if ( ClassIsChildOf(GiveObject,Class'HXPickup') )
		{
			PickupClass = Class<HXPickup>(GiveObject);
			PickupFrom  = HXPickup(InvItemFrom);
			PickupTo    = HXPickup(InvItemTo);

			Log( "  PickupClass = " $ PickupClass, 'DevConPlay' );
			Log( "  PickupFrom  = " $ PickupFrom,  'DevConPlay' );
			Log( "  PickupTo    = " $ PickupTo,    'DevConPlay' );

			// Transfer at least one item.
			TransferCount = Max(Event.TransferCount,1);

			// Non stackable Pickups (DeusEx always just transferes one item in this case).
			// Maybe make a loop and transfer multiple is that ever happens?
			if ( !PickupClass.Default.bCanHaveMultipleCopies )
			{
				// Notify if this actually happens.
				if ( Event.TransferCount!=1 )
					Warn( "Wanted to transfer " $ Event.TransferCount $ " items of class " $ PickupClass $ "but !bCanHaveMultipleCopies forced 1." );

				// If Player doesn't have this item, spawn it.
				if ( PickupFrom==None )
				{
					PickupFrom = Spawn( PickupClass, ToPawn );
					PickupFrom.GiveTo( ToPawn );
					if ( Level.Game.ShouldRespawn(PickupFrom) )
						PickupFrom.Destroy();
				}
				else // PickupFrom!=None
				{
					GivePawnInventory( ToPawn, PickupFrom );
				}

				ItemsTransferred = 1;
			}
			// Stackable Pickups.
			else // PickupClass.Default.bCanHaveMultipleCopies
			{
				// Transfer MaxCopies at most.
				TransferCount = Min(Event.TransferCount,PickupClass.Default.MaxCopies);

				// Make sure Pawn is not a Maximum amount of copies.
				if ( PickupTo!=None )
					if ( PickupTo.NumCopies>=PickupTo.MaxCopies )
						return NextAction;

				// Pawn and Player do not have this item.
				if ( PickupTo==None && PickupFrom==None )
				{
					Log( "  PickupTo==None && PickupFrom==None", 'DevConPlay' );

					PickupFrom = Spawn( PickupClass, ToPawn );
					PickupFrom.NumCopies = TransferCount;
					PickupFrom.GiveTo( ToPawn );
					if ( Level.Game.ShouldRespawn(PickupFrom) )
						PickupFrom.Destroy();

					ItemsTransferred = TransferCount;
				}
				// Just Player has this item.
				else if ( PickupTo==None ) // PickupFrom!=None
				{
					// Player has more copies then are going to be transfered, so split it.
					if ( PickupFrom.NumCopies>TransferCount )
					{
						PickupFrom.NumCopies -= TransferCount;

						PickupTo = Spawn( PickupClass, ToPawn );
						PickupTo.NumCopies = TransferCount;
						PickupTo.GiveTo( ToPawn );
						if ( Level.Game.ShouldRespawn(PickupTo) )
							PickupTo.Destroy();
					}
					// Player has less or equal the TransferCount copies. Set NumCopies to TransferCount.
					// TODO: Check if DeusEx actually does it this way.
					else
					{
						PickupFrom.NumCopies = TransferCount;
						GivePawnInventory( ToPawn, PickupFrom );
					}

					ItemsTransferred = TransferCount;
				}
				// Just Pawn has this item.
				else if ( PickupFrom==None ) // PickupTo!=None
				{
					// Transfer just up to (MaxCopies-NumCopies).
					TransferCount       = Min(TransferCount,PickupTo.MaxCopies-PickupTo.NumCopies);
					PickupTo.NumCopies += TransferCount;
					ItemsTransferred    = TransferCount;
				}
				// Pawn and Player have this item.
				else // PickTo!=None && PickupFrom!=None
				{
					// Transfer just up to (MaxCopies-NumCopies).
					TransferCount         = Min(TransferCount,PickupTo.MaxCopies-PickupTo.NumCopies);
					PickupTo.NumCopies   += TransferCount;
					PickupFrom.NumCopies -= TransferCount;
					ItemsTransferred      = TransferCount;

					// Destroy the Players item if it's empty.
					if ( PickupFrom.NumCopies<=0 )
						PickupFrom.Destroy();
				}
			}

			//
			// TODO -- ADD FORFEIT DISPLAY -- (PickupClass,ItemsTransferred).
			//

			NextLabel = "";
			return EA_NextEvent;
		}
		// Special handling for Weapons. If Pawn has already this weapon, just add the Ammo.
		else if ( ClassIsChildOf(GiveObject,Class'HXWeapon') )
		{
			WeaponClass = Class<HXWeapon>(GiveObject);
			WeaponFrom  = HXWeapon(InvItemFrom);
			WeaponTo    = HXWeapon(InvItemTo);

			Log( "  WeaponClass = " $ WeaponClass, 'DevConPlay' );
			Log( "  WeaponFrom  = " $ WeaponFrom,  'DevConPlay' );
			Log( "  WeaponTo    = " $ WeaponTo,    'DevConPlay' );

			// If Pawn owns the Weapon. Check if the default Ammo is not at max.
			if ( WeaponTo!=None )
			{
				WeaponAmmoTo = HXAmmo(ToPawn.FindInventoryType(WeaponClass.Default.AmmoName));
				if ( WeaponAmmoTo.AmmoAmount>=WeaponAmmoTo.MaxAmmo )
				{
					Log( "  Aborting (MaxAmmo reached).", 'DevConPlay' );
					return NextAction;
				}
			}

			// Transfer at least one weapon.
			TransferCount     = Max(Event.TransferCount,1);
			TransferAmmoCount = TransferCount * WeaponClass.Default.PickupAmmoCount;

			Log( "  TransferCount     = " $ TransferCount,     'DevConPlay' );
			Log( "  TransferAmmoCount = " $ TransferAmmoCount, 'DevConPlay' );

			// Pawn and Player do not have this Weapon.
			if ( WeaponTo==None && WeaponFrom==None )
			{
				// Just spawn a new Weapon and give it the to the Pawn.
				WeaponTo = Spawn( WeaponClass, ToPawn );
				WeaponTo.PickupAmmoCount = TransferAmmoCount;
				WeaponTo.GiveTo( ToPawn );
				if ( Level.Game.ShouldRespawn(WeaponTo) )
					WeaponTo.Destroy();
			}
			// Just Player has this Weapon.
			else if ( WeaponTo==None ) // PickupFrom!=None
			{
				WeaponFrom.PickupAmmoCount = TransferAmmoCount;
				WeaponFrom.AmmoType        = None; // !! Just to be sure.

				GivePawnInventory( ToPawn, WeaponFrom );
			}
			// Just Pawn has this Weapon.
			else if ( WeaponFrom==None ) // WeaponTo!=None
			{
				// Pawn should have the default ammo type for this weapon.
				if ( WeaponAmmoTo!=None )
				{
					WeaponAmmoTo.AddAmmo( TransferAmmoCount );
				}
				// This should actually never happend.
				else
				{
					AmmoTo = HXAmmo( Spawn(WeaponClass.Default.AmmoName,ToPawn) );
					AmmoTo.AmmoAmount = TransferAmmoCount;
					AmmoTo.GiveTo( ToPawn );
					if ( Level.Game.ShouldRespawn(AmmoTo) )
						AmmoTo.Destroy();
				}
			}
			// Pawn and Player have this Weapon.
			else // WeaponTo!=None && WeaponFrom!=None
			{
				// Player should have the default ammo type for this weapon.
				if ( WeaponAmmoTo!=None )
				{
					WeaponAmmoTo.AddAmmo( TransferAmmoCount );
				}
				// This should actually never happend.
				else
				{
					AmmoTo = HXAmmo( Spawn(WeaponClass.Default.AmmoName,ToPawn) );
					AmmoTo.AmmoAmount = TransferAmmoCount;
					AmmoTo.GiveTo( ToPawn );
					if ( Level.Game.ShouldRespawn(AmmoTo) )
						AmmoTo.Destroy();
				}

				// Delete Player Weapon. But keep Ammo.
				WeaponFrom.Destroy();
			}

			//
			// TODO -- ADD FORFEIT DISPLAY -- (WeaponClass,1?).
			//

			NextLabel = "";
			return EA_NextEvent;
		}
		// Special handling for Ammo. Kinda sucks that this is the whole carried ammo in case InvItemFrom!=None. --han
		else if ( ClassIsChildOf(GiveObject,Class'HXAmmo') )
		{
			AmmoClass = Class<HXAmmo>(GiveObject);
			AmmoFrom  = HXAmmo(InvItemFrom);
			AmmoTo    = HXAmmo(InvItemTo);

			Log( "  AmmoClass = " $ AmmoClass, 'DevConPlay' );
			Log( "  AmmoFrom  = " $ AmmoFrom,  'DevConPlay' );
			Log( "  AmmoTo    = " $ AmmoTo,    'DevConPlay' );

			// Check if AmmoAmount is at Max.
			if ( AmmoTo!=None )
				if ( AmmoTo.AmmoAmount>=AmmoTo.MaxAmmo )
					return NextAction;

			// DeusEx seems to transfer exactly one Ammo item.
			ItemsTransferred = 1;

			// Pawn and Player do not have this Ammo.
			if ( AmmoTo==None && AmmoFrom==None )
			{
				AmmoFrom = Spawn( AmmoClass, ToPawn );
				AmmoFrom.GiveTo( ToPawn );
				if ( Level.Game.ShouldRespawn(AmmoFrom) )
					AmmoFrom.Destroy();
			}
			// Just Player has this Ammo, but let Player keep his Ammo Actor.
			else if ( AmmoTo==None ) // AmmoFrom!=None
			{
				AmmoTo = Spawn( AmmoClass, ToPawn );
				AmmoTo.AmmoAmount = AmmoFrom.AmmoAmount;
				AmmoFrom.GiveTo( ToPawn );
				if ( Level.Game.ShouldRespawn(AmmoTo) )
					AmmoTo.Destroy();

				AmmoFrom.AmmoAmount = 0; // Does this require an addtional update on equiped Weapons?
			}
			// Just Pawn has this Ammo.
			else if ( AmmoFrom==None ) // AmmoTo!=None
			{
				// Just add default AmmoAmount.
				AmmoTo.AddAmmo( AmmoClass.Default.AmmoAmount );
			}
			// Player and Pawn have this Ammo.
			else // AmmoTo!=None && AmmoFrom!=None
			{
				AmmoTo.AddAmmo( AmmoFrom.AmmoAmount );
				AmmoFrom.AmmoAmount = 0; // Does this require an addtional update on equiped Weapons?
			}

			//
			// TODO -- ADD FORFEIT DISPLAY -- (AmmoClass,1).
			//

			NextLabel = "";
			return EA_NextEvent;
		}
		// Unhandled inventory type.
		else
		{
			Warn( "[Player->Pawn] Unhandled Inventory class" $ GiveObject $ "!" );

			// Pretend everything is fine.
			NextLabel = "";
			return EA_NextEvent;
		}
	}
	else
	{
		Warn( "Unhandled pawn to pawn transfer!" );

		// Pretend everything is fine.
		NextLabel = "";
		return EA_NextEvent;
	}

	// Probably never reached later on.
	NextLabel  = "";
	return EA_NextEvent;
}

// ----------------------------------------------------------------------------
// GivePlayerInventory()
// ----------------------------------------------------------------------------

function GivePlayerInventory( HXPlayerPawn Player, Inventory Item )
{
	local Actor A;

	if ( Pawn(Item.Owner)!=None )
		Pawn(Item.Owner).DeleteInventory( Item );
	Item.Inventory = None;
	Item.SetOwner( None );

	// make sure nothing is based on us if we're an inventory
	//foreach Item.BasedActors( class'Actor', A )
		//A.SetBase( None );

	//if ( !Item.IsInState('Pickup') )
		Item.GotoState('Pickup');

	Item.Frob( Player, None );

	// if the object destroyed itself, get out
	if ( /*Item==None ||*/ Item.bDeleteMe )
		return;

	if ( Level.Game.ShouldRespawn(Item) )
	{
		Item.Destroy();
		return;
	}

	// if the inventory item aborted it's own pickup, get out
	//if ( Item.Owner!=Player )
		//return;

	// set the base so the inventory follows us around correctly
	//Item.SetBase( Player );
}

function GivePawnInventory( Pawn Pawn, Inventory Item )
{
	local Actor A;

	if ( Pawn(Item.Owner)!=None )
		Pawn(Item.Owner).DeleteInventory( Item );
	Item.Inventory = None;
	Item.SetOwner( None );

	if ( !Item.IsInState('Pickup') )
		Item.GotoState('Pickup');

	Item.GiveTo( Pawn );

	// if the object destroyed itself, get out
	if ( Item==None || Item.bDeleteMe )
		return;

	if ( Level.Game.ShouldRespawn(Item) )
	{
		Item.Destroy();
		return;
	}
}

// ----------------------------------------------------------------------------
// RemoveItemFromPlayer()
//
// Check if this item was in the player's hand
// ----------------------------------------------------------------------------

function RemoveItemFromPlayer(Inventory item)
{
	if ((player != None) && (item != None))
		player.RemoveItemDuringConversation(item);
}

// ----------------------------------------------------------------------------
// CheckRadius()
//
// Returns True if this conversation can be invoked given the 
// invoking actor and the distance between the actor and the player
// ----------------------------------------------------------------------------

function bool CheckRadius(Actor Player, Actor invokePawn)
{
	local Int  invokeRadius;
	local Int  dist;

	dist = VSize(Player.Location - invokePawn.Location);

	return (dist <= MaxAllowableRadius);
}

// ----------------------------------------------------------------------------
// CheckHeightDifference()
// ----------------------------------------------------------------------------

function bool CheckHeightDifference(HXPlayerPawn Player, Actor invokeActor)
{
	// If the ScriptedPawn can see the player, than allow a taller height difference.
	// Otherwise make it pretty small (this is done especially to prevent the 
	// bark from playing through ceilings).

	if (Player.FastTrace(invokeActor.Location))
		return Player.CheckConversationHeightDifference(invokeActor, MaxVisibleHeightDifference);
	else
		return Player.CheckConversationHeightDifference(invokeActor, MaxHiddenHeightDifference);
}

// ----------------------------------------------------------------------------
// TurnActor()
// ----------------------------------------------------------------------------

function TurnActor(Actor turnActor, Actor turnTowards)
{
	// Check to see if each Actor is already in the conversation
	// state.  If not, they need to be in that state.  Just don't 
	// add the player

	if (HXPlayerPawn(turnActor) == None)
	{
		AddConActor(turnActor, con.bFirstPerson);

		if ((turnActor != None) && (turnActor.IsA('HXScriptedPawn')))
			HXScriptedPawn(turnActor).ConversationActor = turnTowards;
	}
	else
		HXPlayerPawn(turnActor).ConversationActor = turnTowards;
}

// ----------------------------------------------------------------------------
// ActorDestroyed()
//
// Called when an actor gets destroyed via some external process.
// Check our list of ConActors, if the destroyed actors is in this list,
// then:
//
// 1) Remove the actor from the ConActors array
// 2) Immediately abort the conversation (this is done to prevent a 
//    crash by referencing a destroyed object)
// ----------------------------------------------------------------------------

function ActorDestroyed( Actor DestroyedActor ) // !! FIX-ME !! REF CLEANUP IN CONS !!
{
	local int ConActorIndex;

	Log( "ActorDestroyed(" @ DestroyedActor @ ")", 'DevConPlay' );

	// Special handling for DM_ThirdPerson and Player vanishing.
	if ( DestroyedActor==Player )
	{
		// Remove from List.
		IsConActorInList( DestroyedActor, true );

		// Abort the conversation!!!
		TerminateConversation();

		Log( "TerminatedConversation() because Player involved in conversation was destroyed (" $ DestroyedActor $ ").", 'DevConPlay' );
		return;
	}

	for( ConActorIndex=0; ConActorIndex<ArrayCount(ConActorsBound); ConActorIndex++ )
	{
		if ( ConActorsBound[conActorIndex]==DestroyedActor )
		{
			// First check to see if it's in the ConActors list, in 
			// which case it needs to be removed before we abort
			// (so it doesn't try to do anything with that variable)
			IsConActorInList( DestroyedActor, true );

			// Abort the conversation!!!
			TerminateConversation();

			Log( "TerminatedConversation() because Actor involved in conversation was destroyed (" $ DestroyedActor $ ").", 'DevConPlay' );
			return;
		}
	}
}

// ----------------------------------------------------------------------------
// SkipCurrent()
//
// User request on skipping a certain dialogue end here.
// We need to apply some filtering to make sure we just skip events the
// user is allowed too.
// ----------------------------------------------------------------------------

function SkipCurrent()
{
	if ( IsInState('WaitForSpeech') || IsInState('WaitForText') )
	{
		PlayNextEvent();
	}
}

// ----------------------------------------------------------------------------
// StringToName()
// ----------------------------------------------------------------------------

final static function Name StringToName( string Str )
{
	return class'HXActor'.static.StringToName( Str );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bGameRelevant=True
	MaxAllowableRadius=1000
	MaxHiddenHeightDifference=100
	MaxVisibleHeightDifference=500
}
