//=============================================================================
// HXContainers.
//=============================================================================
class HXContainers extends HXDecoration
	abstract;

var() travel int  NumThings;
var() travel bool bGenerateTrash;
var() travel Class<Decoration> TrashClass;
var() travel Class<Pawn>       VerminClass;

// ----------------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------------

simulated function PreBeginPlay()
{
	local class<Actor> ActorClass;
	local class<Inventory> InventoryClass;

	Super.PreBeginPlay();

	if ( bDeleteMe || IsInRelevant() )
		return;

	if ( Level.NetMode!=NM_Client )
	{
		// Mutators had their chance to modify TrashClass and VerminClass,
		// now translate those classes to HX ones if needed.
		if ( TrashClass!=None )
		{
			ActorClass = TrashClass;
			Game.ModifyActorClass( ActorClass );
			TrashClass = Class<Decoration>(ActorClass);

			// Enforce HXDecoration subclass.
			if ( !ClassIsChildOf(TrashClass,class'HXDecoration') )
			{
				Warn( "Rejected non HX TrashClass"@TrashClass@"for"@Self );
			
				TrashClass = None;
			}
		}
		if ( VerminClass!=None )
		{
			ActorClass = VerminClass;
			Game.ModifyActorClass( ActorClass );
			VerminClass = Class<Pawn>(ActorClass);

			// Enforce HXScriptedPawn subclass.
			if ( !ClassIsChildOf(VerminClass,class'HXScriptedPawn') )
			{
				Warn( "Rejected non HX VerminClass"@VerminClass@"for"@Self );
			
				VerminClass = None;
			}
		}
	}
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Containers OtherContainers;

	// Call Super.
	Super.Succeeds( Other );

	// Special  Init.
	OtherContainers = Containers(Other);
	if ( OtherContainers!=None )
	{
		NumThings				= OtherContainers.NumThings;
		bGenerateTrash	= OtherContainers.bGenerateTrash;

		// Prevent Other from spawning trash in Destroyed()
		OtherContainers.bGenerateTrash = False;
	}
}

// ----------------------------------------------------------------------------
// SpawnContents()
// ----------------------------------------------------------------------------

function SpawnContents()
{
	local Class<Inventory> SpawnClass;
	local int i;
	local Inventory Dropped;
	local Rotator SpawnRot;
	local Vector SpawnLoc;

	if( !bContentsSpawned && Contents!=None && !Level.bStartup && Role==Role_Authority )
	{
		SpawnClass = Contents;
		if ( Content2!=None && FRand()<0.3 )
			SpawnClass = Content2;
		if ( Content3!=None && FRand()<0.3)
			SpawnClass = Content3;

		for ( i=0; i<NumThings; i++ )
		{
			SpawnLoc   = Location + VRand() * CollisionRadius;
			SpawnLoc.Z = Location.Z;
			SpawnRot = Rot(0,0,0);
			SpawnRot.Yaw = FRand() * 65535.0;

			Dropped = Spawn( SpawnClass, None, '', SpawnLoc, SpawnRot );
			if ( Dropped!=None )
			{
				Dropped.RemoteRole = ROLE_DumbProxy;
				Dropped.SetPhysics(PHYS_Falling);
				Dropped.bCollideWorld = True;
				Dropped.Velocity = VRand() * 50;
				//if ( Inventory(dropped)!=None )
					//Inventory(dropped).GotoState( 'Pickup', 'Dropped' );
				Dropped.GotoState( 'Pickup', 'Dropped' );
			}
		}
		bContentsSpawned = true;
	}
}

// ----------------------------------------------------------------------------
// Destroyed()
// ----------------------------------------------------------------------------

simulated function Destroyed()
{
	local Actor          Vermin;
	local HXDecoration   Trash;
	local Rotator SpawnRot;
	local Vector  SpawnLoc;
	local int i;

	if ( Role==ROLE_Authority )
	{
		// Trace down to see if we are sitting on the ground.
		SpawnLoc    = Location;
		SpawnLoc.Z -= CollisionHeight + 8.0;

		// Only generate trash and vermin if we are on the ground.
		if ( bGenerateTrash && !Level.bStartup && !bVanished && !FastTrace(SpawnLoc) )
		{
			// Maybe spawn some trash (paper by default).
			if ( TrashClass!=None )
			{
				for ( i=0; i<4; i++ )
				{
					if ( FRand()<0.75 )
					{
						SpawnLoc    = Location;
						SpawnLoc.X += (CollisionRadius / 2) - FRand() * CollisionRadius;
						SpawnLoc.Y += (CollisionRadius / 2) - FRand() * CollisionRadius;
						SpawnLoc.Z += (CollisionHeight / 2) - FRand() * CollisionHeight;
						SpawnRot    = RotRand(True);

						Trash = HXDecoration(Spawn( TrashClass, None, '', SpawnLoc, SpawnRot ));

						// Init needed for SinglePlayer, ListenServer.
						if ( Trash!=None )
							Trash.InitTrash( true, false );
					}
				}
			}

			// Maybe spawn a vermin (rat by default).
			if ( VerminClass!=None )
			{
				if ( FRand()<0.5 )
				{
					SpawnLoc     = Location;
					SpawnLoc.Z  -= CollisionHeight;
					SpawnRot     = Rot(0,0,0);
					SpawnRot.Yaw = FRand() * 65535.0;
					Vermin = Spawn( VerminClass, None, '', SpawnLoc );
					if ( Vermin!=None)
						Vermin.bTransient = True;
				}
			}
		}
	}

	Super.Destroyed();
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	NumThings=1
	bFlammable=True
	bCanBeBase=True
	bIsContainer=True
	TrashClass=TrashPaper
	VerminClass=Rat
}
