//=============================================================================
// HXCoopStart.
//=============================================================================
class HXCoopStart extends HXInfo
	native;

#exec Texture Import File=Textures\S_CoopPlayer.pcx Name=S_CoopPlayer Mips=Off Flags=2050

var(CoopStart) bool bInitiallyEnabled; // Whether to start enabled or not.
var            bool bEnabled;          // Is it enabled right now?
var(CoopStart) bool bDefaultStart;     // Whether to use this spawnpoint if portal is empty.

// If !bInitiallyEnabled and the coop start is touched it gets enabled among
// all other coop starts having the same non empty EnableTag. At the same time all coop starts
// Having this DisabledTag as EnableTag gets disabled.
// You need to set bCollideActors to make use of this feature.
var(CoopStart) Name EnableTag;
var(CoopStart) Name DisableTag;

// Used to prioritize SpawnPoints. Higher values equals higher priority.
// HX added SpawnPoints for DeusEx use the Range 0-1000 and SpawnPoint selection
// code assumes these range too. So don't get over 1000.
var(CoopStart) int Priority;

// TeamNumber. Intended for teamplay mods which want to use different spawn
// locations for different teams of players.
var(CoopStart) byte TeamNumber;

var(CoopStart) String EnabledMessage; // Message to broadcast when enabled.

// ----------------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------------

event PreBeginPlay()
{
	Super.PreBeginPlay();

	bEnabled = bInitiallyEnabled;
}

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

event Touch( Actor Other )
{
	local HXCoopStart CoopStart;

	//Log( Self $ ".Touch( " $ Other $ " )" );
	//Log( "  EnableTag=" $ EnableTag );
	//Log( "  DisableTag=" $ DisableTag );

	// Do nothing if already enabled.
	if ( bEnabled )
		return;

	// Just players should be able to enable this.
	if ( !Other.bIsPawn || !Pawn(Other).bIsPlayer )
		return;

	// Enable this teleporter.
	bEnabled = True;

	// Notify players.
	BroadcastMessage( EnabledMessage );

	// Check if we need to enable/disable other teleporters.
	if ( EnableTag=='' && DisableTag=='' )
		return;

	// Enable all teleporters with same EnabledTag and disable those with same disable tag
	foreach AllActors( Class'HXCoopStart', CoopStart )
	{
		if ( EnableTag!='' && CoopStart.EnableTag==EnableTag )
		{
			CoopStart.bEnabled = True;
		}
		else if ( DisableTag!='' && CoopStart.EnableTag==DisableTag )
		{
			CoopStart.bEnabled = False;
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	EnabledMessage="Enabled new CoopStart."
	bInitiallyEnabled=True
	bDirectional=True
	bHidden=True
	bCollideActors=False
	bCollideWorld=False
	bBlockActors=False
	bBlockPlayers=False
	RemoteRole=ROLE_None
	Texture=Texture'HX.S_CoopPlayer'
	CollisionRadius=20.000000
	CollisionHeight=47.500000
}
