//=============================================================================
// HXCouchLeather.
//=============================================================================
class HXCouchLeather extends HXSeat;

enum ESkinColor
{
	SC_Black,
	SC_Blue,
	SC_Brown,
	SC_LitGray,
	SC_Tan
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local CouchLeather OtherCouchLeather;

	// Call Super.
	Super.Succeeds( Other );

	// Special CouchLeather Init.
	OtherCouchLeather = CouchLeather(Other);
	if ( OtherCouchLeather!=None )
	{
		SetPropertyText( "SkinColor", OtherCouchLeather.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	//
	// The original code here always used CouchLeatherTex1 for any SkinColor.
	// 
	// I do believe this way intentional and not a bug, as the other Skins
	// frankly do look awful. Also I regard it as unlikely that this bug
	// would have slipped through. --han
	//
	//if ( Role==ROLE_Authority && !IsInRelevant() )
	//{
	//	switch ( SkinColor )
	//	{
	//		case SC_Black:   Skin = Texture'CouchLeatherTex1'; break;
	//		case SC_Blue:    Skin = Texture'CouchLeatherTex2'; break;
	//		case SC_Brown:   Skin = Texture'CouchLeatherTex3'; break;
	//		case SC_LitGray: Skin = Texture'CouchLeatherTex4'; break;
	//		case SC_Tan:     Skin = Texture'CouchLeatherTex5'; break;
	//	}
	//}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	SitPoint(0)=(X=-18.0,Y=-8.0,Z=0.0)
	SitPoint(1)=(X=18.0,Y=-8.0,Z=0.0)
	ItemName="Leather Couch"
	Skin=CouchLeatherTex1
	Mesh=CouchLeather
	CollisionRadius=47.88
	//CollisionHeight=23.25
	CollisionHeight=22.50
	Mass=100.0
	Buoyancy=110.0
}
