//=============================================================================
// HXCredits.
//=============================================================================
class HXCredits extends HXDeusExPickup;

var() int NumCredits;

var localized String MsgCreditsAdded;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Credits OtherCredits;

	// Call Super.
	Super.Succeeds( Other );

	// Special Credits Init.
	OtherCredits = Credits(Other);
	if ( OtherCredits!=None )
	{
		// Credits.
		NumCredits = OtherCredits.NumCredits;
	}
}

// ----------------------------------------------------------------------------
// auto state Pickup
// ----------------------------------------------------------------------------

auto state Pickup
{
	function Frob(Actor Frobber, Inventory frobWith)
	{
		local HXPlayerPawn Player;

		Super.Frob( Frobber, FrobWith );

		// Add these credits to the player's credits count
		Player = HXPlayerPawn(Frobber);
		if ( Player!=None )
		{
			Player.Credits += NumCredits;
			Player.ClientMessage( Sprintf(MsgCreditsAdded,NumCredits) );
			Player.FrobTarget = None;

			Destroy();
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bDisplayableInv=False
	NumCredits=100
	MsgCreditsAdded="%d credits added"
	ItemName="Credit Chit"
	PlayerViewOffset=(X=30.0,Y=0.0,Z=-12.0)
	PlayerViewMesh=Credits
	PickupViewMesh=Credits
	ThirdPersonMesh=Credits
	LandSound=PlasticHit1
	Icon=BeltIconCredits
	BeltDescription="CREDITS"
	Mesh=Credits
	CollisionRadius=7.00
	CollisionHeight=0.55
	Mass=2.0
	Buoyancy=3.0
}
