//=============================================================================
// HXDamageTrigger.
//
// TODO:
//  * FIX-ME: Not suitable for multiple actors.
//=============================================================================
class HXDamageTrigger extends HXTrigger;

var() float DamageAmount;
var() float DamageInterval;
var() Name  DamageType;
var() bool  bConstantDamage;

var Actor Damagee;
var bool bIsOn;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local DamageTrigger OtherDamageTrigger;

	// Call Super.
	Super.Succeeds( Other );

	// Special DamageTrigger Init.
	OtherDamageTrigger = DamageTrigger(Other);
	if ( OtherDamageTrigger!=None )
	{
		DamageAmount    = OtherDamageTrigger.DamageAmount;
		DamageInterval  = OtherDamageTrigger.DamageInterval;
		DamageType      = OtherDamageTrigger.DamageType;
		bConstantDamage = OtherDamageTrigger.bConstantDamage;
	}
}

// ----------------------------------------------------------------------------
// Timer()
// ----------------------------------------------------------------------------

function Timer()
{
	if ( !bIsOn )
	{
		SetTimer( 0.1, false );
		return;
	}

	if ( Damagee!=None )
		Damagee.TakeDamage( DamageAmount, None, Location, vect(0,0,0), DamageType );
}

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

function Touch( Actor Other )
{
	if ( !bIsOn )
		return;

	// Should we even pay attention to this actor?
	if ( !IsRelevant(Other) )
		return;

	Damagee = Other;

	SetTimer( DamageInterval, bConstantDamage );

	Super.Touch( Other );
}

// ----------------------------------------------------------------------------
// UnTouch()
// ----------------------------------------------------------------------------

function UnTouch( Actor Other )
{
	if ( !bIsOn )
		return;

	Damagee = None;
	SetTimer( 0.1, false );
}

// ----------------------------------------------------------------------------
// Trigger()
//
// If we are triggered, turn us on.
// ----------------------------------------------------------------------------

function Trigger( Actor Other, Pawn Instigator )
{
	bIsOn = true;

	Super.Trigger(Other, Instigator);
}

// ----------------------------------------------------------------------------
// UnTrigger()
//
// If we are untriggered, turn us off.
// ----------------------------------------------------------------------------

function UnTrigger(Actor Other, Pawn Instigator)
{
	bIsOn = false;

	Super.UnTrigger( Other, Instigator );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	DamageAmount=5.0
	bConstantDamage=True
	DamageInterval=0.5
	DamageType=Burned
	bIsOn=True
}
