//=============================================================================
// HXDataLinkDryRunner
//=============================================================================
class HXDataLinkDryRunner extends DataLinkPlay;

// Save the DatalinkTrigger so we can notify the trigger when 
// the datalink has finished playing.
var HXDatalinkTrigger HXDatalinkTrigger;
var HXGameInfo info;

// ----------------------------------------------------------------------
// SetTrigger()
// ----------------------------------------------------------------------

function SetHXTrigger(HXDatalinkTrigger newDatalinkTrigger)
{
	HXDatalinkTrigger = newDatalinkTrigger;
}

// ----------------------------------------------------------------------
// StartDryConversation()
//
// Starts a conversation.  
//
// 1.  Initializes the Windowing system
// 2.  Gets a pointer to the first Event
// 3.  Jumps into the 'PlayEvent' state
// ----------------------------------------------------------------------

//function Bool StartDryConversation(HXGameInfo newInfo, optional Actor newInvokeActor, optional bool bForcePlay)
function Bool StartDryConversation(HXGameInfo newInfo)
{
	local DeusExLevelInfo aDeusExLevelInfo;
	local Actor tempActor;

	// Make sure we have a conversation and a valid Player
	if (( con == None ) || ( newInfo == None ))
		return False;

	// Make sure the player isn't, uhhrr, you know, DEAD!
	//if (newPlayer.IsInState('Dying'))
		//return False;

	// Keep a pointer to the player and invoking actor
	info      = newInfo;

	//if (newInvokeActor != None) 
		//invokeActor = newInvokeActor;
	//else
		//invokeActor = startActor;

	// Bind the conversation events
	//con.BindEvents(ConActorsBound, invokeActor);
	//con.BindEvents(ConActorsBound, None); // HX_NOTE: useless?
	class'HXActor'.static.BindConsersationEvents( con, ConActorsBound, None, XLevel );

	// Check to see if the conversation has multiple owners, in which case we 
	// want to rebind all the events with this owner.  This allows conversations
	// to be shared by more than one owner.
	//if ((con.ownerRefCount > 1) && (invokeActor != None))
		//con.BindActorEvents(invokeActor);

	// Check to see if all the actors are on the level.
	// Don't check this for InfoLink conversations, since oftentimes
	// the person speaking via InfoLink *won't* be on the map.
	//
	// If a person speaking on the conversation can't be found 
	// (say, they were ruthlessly MURDERED!) then abort.
	//
	// Hi Ken!

	//if ((!bForcePlay) && (!con.bDataLinkCon) && (!con.CheckActors()))
		//return False;

	// Now check to make sure that all the actors are a reasonable distance
	// from one another (excluding the player)
	// HX_NOTE: useless for dryrunner
	//if ((!bForcePlay) && (!con.CheckActorDistances(player)))
		//return False;

	// Save the mission number and location
	foreach AllActors(class'DeusExLevelInfo', aDeusExLevelInfo)
	{
		if (aDeusExLevelInfo != None)
		{
			missionNumber   = aDeusExLevelInfo.missionNumber;
			missionLocation = aDeusExLevelInfo.MissionLocation;
			break;
		}
	}

	// Save the conversation radius
	saveRadiusDistance = con.radiusDistance;

	// Initialize Windowing System
	//rootWindow = HXRootWindow(player.rootWindow);

	bConversationStarted = True;

	//return True;

	// END OF ConPlayBase.StartConversation()

	//if ( Super.StartDryConversation(newInfo, newInvokeActor, bForcePlay) == False )
		//return False;

	// Create the DataLink display if necessary.  If it already exists,
	// then we're presently in a DataLink and need to queue this one up
	// for play after the current DataLink is finished.
	//
	// Don't play the DataLink if 
	//
	// 1.  A First-person conversation is currently playing 
	// 2.  Player is rooting around inside a computer
	//
	// In these cases we'll just queue it up instead

	//if ( ( dataLink == None ) && ( (player.conPlay == None) && 	(NetworkTerminal(rootWindow.GetTopWindow()) == None) ) 	)
	if ( info.conPlay == None )
	{
		lastSpeechTextLength = 0;
		bEndTransmission = False;
		eventTimer = 0;

		//datalink = rootWindow.hud.CreateInfoLinkWindow();

		//if ( dataLinkQueue[0] != None )
			//dataLink.MessageQueued(True);
	}
	else
	{
		return True;
	}

	// Grab the first event!
	currentEvent = con.eventList;

	// Create the history object.  Passing in True means
	// this is an InfoLink conversation.
	//SetupHistory(GetDisplayName(con.GetFirstSpeakerDisplayName()), True);

	// Play a sound and wait a few seconds before starting
	//datalink.ShowTextCursor(False);
	//player.PlaySound(startSound, SLOT_None); 

	bStartTransmission = True;
	SetTimer(blinkRate, True);

	return True;
}

// ----------------------------------------------------------------------
// TerminateConversation()
// ----------------------------------------------------------------------

function TerminateConversation(optional bool bContinueSpeech, optional bool bNoPlayedFlag)
{
	// Make sure sound is no longer playing
	//player.StopSound(playingSoundId);

	// Save the DataLink history
	//if ((history != None) && (player != None))
	//{
		//history.next = player.conHistory;
		//player.conHistory = history;
		//history = None;		// in case we get called more than once!!
	//}

	SetTimer(blinkRate, True);

	//if ((dataLink != None) && (datalink.winName != None))
		//datalink.winName.SetText(EndTransmission);

	bEndTransmission = True;

	// Notify the trigger that we've finished
	NotifyDatalinkTrigger();

	//Super(ConPlayBase).TerminateConversation(True, bNoPlayedFlag);

	// ConPlayBase

	// Make sure there's no audio playing
	//if (!bContinueSpeech)
		//player.StopSound(playingSoundID);

	// Set the played flag
	if (!bNoPlayedFlag)
		SetPlayedFlag();

	if ( con != none )
	{
		// Clear the bound event actors
		con.ClearBindEvents();

		// Reset the conversation radious
		con.radiusDistance = saveRadiusDistance;
	}

	// Notify the conversation participants to go about their
	// business.
	EndConActorStates();

	con          = None;
	currentEvent = None;
	lastEvent    = None;
}

// ----------------------------------------------------------------------
// NotifyDatalinkTrigger()
// ----------------------------------------------------------------------

function NotifyDatalinkTrigger()
{
	if (HXDatalinkTrigger != None)
		HXDatalinkTrigger.DatalinkFinished();
}

// ----------------------------------------------------------------------
// AbortDataLink()
//
// Aborts the current datalink playing immediately
// ----------------------------------------------------------------------

function AbortDataLink()
{
	// Make sure there's no audio playing
	//player.StopSound(playingSoundId);

	GotoState('');

	SetTimer(0.0, False);

	if (dataLink != None)
	{
		rootWindow.hud.DestroyInfoLinkWindow();
		dataLink = None;

		// Put the currently playing DataLink at the front of the queue,
		// but *only* if the bEndTransmission flag isn't set (which means
		// we're just waiting for the "END TRANSMISSION" pause at the end
		// of a DataLink).

		if (!bEndTransmission)
			InsertDataLink(con);	
	}

	con          = None;
	currentEvent = None;
	lastEvent    = None;
}

// ----------------------------------------------------------------------
// ResumeDataLinks()
//
// Resumes aborted and queued DataLinks
// ----------------------------------------------------------------------

function ResumeDataLinks()
{
	SetConversation(PopDataLink());

	if ( con != None )
	{
		//StartDryConversation(info, invokeActor);
		StartDryConversation( info );
	}
	else
	{
		if (dataLink != None)
		{
			//rootWindow.hud.DestroyInfoLinkWindow();
			dataLink = None;
		}
		info.dataLinkPlay = None;
		Destroy();
	}
}

// ----------------------------------------------------------------------
// FireNextDataLink()
//
// Checks to see if there's another DataLink that needs to be triggered,
// and if so, starts it off.
//
// Returns True if we found a DataLink
// ----------------------------------------------------------------------

function Bool FireNextDataLink()
{
	local Bool bResult;

	bResult = False;

	con      = PopDataLink();
	startCon = con;

	if ( con != None )
	{
		//StartDryConversation(info, invokeActor);
		StartDryConversation( info );
		bResult = True;
	}

	return bResult;
}

// ----------------------------------------------------------------------
// AbortAndSaveHistory()
// ----------------------------------------------------------------------

function AbortAndSaveHistory()
{
	bSilent = True;

	// Make sure no sound playing
	//player.StopSound(playingSoundId);

	if ((!bEndTransmission) && (bStartTransmission))
	{
		bStartTransmission = False;
		GotoState('PlayEvent');
		SetTimer(0.0, False);
	}
	else
	{
		PlayNextEvent();
	}
}

// ----------------------------------------------------------------------
// Timer()
//
// Used to provide some flash at the beginning and end of the 
// transmission
// ----------------------------------------------------------------------

function Timer()
{
	eventTimer += blinkRate;

	if ((!bEndTransmission) && (bStartTransmission))
	{
		//datalink.ShowDatalinkIcon(!datalink.winPortrait.IsVisible());

		if ( eventTimer > startDelay )
		{
			bStartTransmission = False;
			eventTimer = 0.0;
			SetTimer(0.0, False);

			//datalink.ShowTextCursor(True);

			// Play this event!
			GotoState('PlayEvent');
		}
	}
	else if (bEndTransmission)
	{
		//datalink.winName.Show(!datalink.winName.IsVisible());

		if ( eventTimer > endDelay )
		{
			SetTimer(0.0, False);
			bEndTransmission = False;
			//rootWindow.hud.DestroyInfoLinkWindow();
			dataLink = None;

			// Check to see if there's another DataLink to trigger
			if ( FireNextDataLink() == False )
			{
				info.dataLinkPlay = None;
				Destroy();
			}
		}
	}
}

// ----------------------------------------------------------------------
// SetPlayedFlag()
// ----------------------------------------------------------------------

function SetPlayedFlag()
{
	local Name flagName;

	if (con != None)
	{
		// Make a note of when this conversation ended
		con.lastPlayedTime = info.Level.TimeSeconds;

		flagName = StringToName( con.conName $ "_Played" );

		// Only set the Played flag if it doesn't already exist 
		// (some conversations set this intentionally with a longer expiration
		// date so they can be relied up on in future missions)

		if ( !info.Steve.flagBase.GetBool(flagName) && con.bDisplayOnce )
		{
			// Add a flag noting that we've finished this conversation.  
			info.Steve.flagBase.SetBool(flagName, True);

			// HX_NOTE: idk if this is really *that* good idea
			HXGameInfo(Level.Game).FlagReplicationInfo.SetBoolFlag(flagName, True);
		}

		// If this was a third-person convo, keep track of when the conversation
		// ended and who it was with (this is used to prevent radius convos
		// from playing immediately after letterbox convos).
		//
		// If this was a first-person convo, keep track of the owner and 
		// play time so we can prevent multiple radius-induced conversations
		// from playing without a pause (we don't want them to run into 
		// each other).

		//if (con.bFirstPerson)
		//{
			//player.lastFirstPersonConvoActor = invokeActor;
			//player.lastFirstPersonConvoTime  = con.lastPlayedTime;
		//}
		//else
		//{
			//player.lastThirdPersonConvoActor = invokeActor;
			//player.lastThirdPersonConvoTime  = con.lastPlayedTime;
		//}

	}
}

// ----------------------------------------------------------------------
// SetInterruptedFlag()
// ----------------------------------------------------------------------

function SetInterruptedFlag()
{
	local Name flagName;

	if (con != None)
	{
		flagName = StringToName( con.conName $ "_Interrupted" );

		// Add a flag noting that we've finished this conversation.  

		info.Steve.flagBase.SetBool(flagName, True);
	}
}

// ----------------------------------------------------------------------
// PlaySpeech()
//
// All speech eminates from the player in DataLink transmissions
// ----------------------------------------------------------------------

function PlaySpeech( int soundID )
{
	//local Sound speech;

	//speech = con.GetSpeechAudio(soundID);

	//if (speech != None)
		//playingSoundID = player.PlaySound(speech, SLOT_Talk); 
}

// ----------------------------------------------------------------------
// StopSpeech()
// ----------------------------------------------------------------------

function StopSpeech()
{
	//player.StopSound(playingSoundID);
}

// ----------------------------------------------------------------------------
// All the unique Setup routines for each event type are located here
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------
// SetupEventSpeech()
//
// Display the speech and wait for feedback.
// ----------------------------------------------------------------------

function EEventAction SetupEventSpeech( ConEventSpeech event, out String nextLabel )
{
	local EEventAction nextAction;
	local ConEvent checkEvent;
	local String speech;

	// Keep track of the last speaker
	lastActor = event.speaker;

	// Display the first speech chunk.
	speech = event.conSpeech.speech;

	if (!bSilent)
	{
		// If we're continuing from the last speech, then we want to Append 
		// and not Display the first chunk.
		if ( event.bContinued == True )
		{
			//datalink.AppendText(speech);
		}
		else
		{
			// Clear the window, set the name of the currently speaking
			// actor and then start displaying the speech.

			//datalink.ClearScreen();
			//datalink.SetSpeaker(event.speakerName, GetDisplayName(event.speakerName));
			//datalink.ShowPortrait();
			//datalink.DisplayText(speech);

			lastSpeechTextLength = len(speech);
		}
	}

	// Save this event in the history
	//AddHistoryEvent(GetDisplayName(event.speakerName), event.conSpeech );

	nextAction = EA_WaitForSpeech;
	nextLabel = "";
	return nextAction;
}

// ----------------------------------------------------------------------
// SetupEventSetFlag()
// ----------------------------------------------------------------------

function EEventAction SetupEventSetFlag( ConEventSetFlag event, out String nextLabel )
{
	local ConFlagRef currentRef;

	// Just follow the chain of flag references and set the flags to
	// the proper value!

	currentRef = event.flagRef;

	while( currentRef != None )
	{
		info.Steve.flagBase.SetBool(currentRef.flagName, currentRef.value);
		info.Steve.flagBase.SetExpiration(currentRef.flagName, FLAG_Bool, currentRef.expiration); 

		HXGameInfo(Level.Game).FlagReplicationInfo.SetBoolFlag(currentRef.flagName, currentRef.value );

		currentRef = currentRef.nextFlagRef;

	}

	nextLabel = "";
	return EA_NextEvent;
}

// ----------------------------------------------------------------------
// SetupEventCheckFlag()
// ----------------------------------------------------------------------

function EEventAction SetupEventCheckFlag( ConEventCheckFlag event, out String nextLabel )
{
	local ConFlagRef currentRef;
	local EEventAction action;

	// Default values if we actually make it all the way 
	// through the while loop below.

	nextLabel = event.setLabel;
	action = EA_JumpToLabel;
	
	// Loop through our list of FlagRef's, checking the value of each.
	// If we hit a bad match, then we'll stop right away since there's
	// no point of continuing.

	currentRef = event.flagRef;

	while( currentRef != None )
	{
		if ( info.Steve.flagBase.GetBool(currentRef.flagName) != currentRef.value )
		{
			nextLabel = "";
			action = EA_NextEvent;
			break;
		}
		currentRef = currentRef.nextFlagRef;
	}
	
	return action;
}

// ----------------------------------------------------------------------
// SetupEventTrade()
// ----------------------------------------------------------------------

function EEventAction SetupEventTrade( ConEventTrade event, out String nextLabel )
{
	nextLabel = "";
	return EA_NextEvent;
}

// ----------------------------------------------------------------------
// SetupEventCheckObject()
//
// Checks to see if the player has the given object.  If so, then we'll
// just fall through and continue running code.  Otherwise we'll jump
// to the supplied label.
// ----------------------------------------------------------------------

function EEventAction SetupEventCheckObject( ConEventCheckObject Event, out String NextLabel )
{
	local EEventAction NextAction;
	local Name KeyName;
	local bool bHasObject;
	local class<Inventory> InvClass;

	// Okay this is some HackyHack stuff here.  We want the ability to
	// check if the player has a particular nanokey.  Sooooooo.
	if ( Event.CheckObject==None && Left(Event.ObjectName,3)~="NK_" )
	{
		// Look for key
		KeyName    = StringToName( Right(Event.ObjectName,Len(Event.ObjectName)-3) );
		bHasObject = Info.HasKey( keyName );
	}
	else
	{
		// Since we have no real player return false for now.
		Log( Self $ ".SetupEventCheckObject() called for Event.CheckObject=" $ Event.CheckObject, 'DevDataLinkPlay' );
		bHasObject = False;
	}

	// Now branch appropriately
	if ( bHasObject )
	{
		NextAction = EA_NextEvent;
		NextLabel  = "";
	}
	else
	{
		NextAction = EA_JumpToLabel;
		NextLabel  = Event.FailLabel;
	}
	return NextAction;
}

// ----------------------------------------------------------------------
// SetupEventTransferObject()
//
// Gives a Pawn the specified object.  The object will be created out of
// thin air (spawned) if there's no "fromActor", otherwise it's 
// transfered from one pawn to another.
//
// We now allow this to work without the From actor, which can happen
// in InfoLinks, since the FromActor may not even be on the map.
// This is useful for tranferring DataVaultImages.
// ----------------------------------------------------------------------

function EEventAction SetupEventTransferObject( ConEventTransferObject event, out String nextLabel )
{
	local EEventAction nextAction;
	local Inventory invItemFrom;
	local Inventory invItemTo;
	local ammo AmmoType;
	local bool bSpawnedItem;
	local bool bSplitItem;
	local int itemsTransferred;

/*
log("SetupEventTransferObject()------------------------------------------", 'DevDataLinkPlay' );
log("  event = " $ event, 'DevDataLinkPlay' );
log("  event.giveObject = " $ event.giveObject, 'DevDataLinkPlay' );
log("  event.fromActor  = " $ event.fromActor, 'DevDataLinkPlay' );
log("  event.toActor    = " $ event.toActor, 'DevDataLinkPlay' );
*/
	// HX_NOTE: special handling for DataVaultImages
	if ( ClassIsChildOf( event.giveObject, class'DataVaultImage' ) )
	{
		HXGameInfo(Level.Game).AddImage( class<DataVaultImage>(event.giveObject), true );

		nextAction = EA_NextEvent;
		nextLabel = "";

		return nextAction;
	}

	itemsTransferred = 1;

	if ( event.failLabel != "" )
	{
		nextAction = EA_JumpToLabel;
		nextLabel  = event.failLabel;
	}
	else
	{
		nextAction = EA_NextEvent;
		nextLabel = "";
	}

	// First verify that the receiver exists!
	if (event.toActor == None)
	{
		log("SetupEventTransferObject:  WARNING!  toActor does not exist!", 'DevDataLinkPlay' );
		log("  Conversation = " $ con.conName, 'DevDataLinkPlay' );
		return nextAction;
	}

	// First, check to see if the giver actually has the object.  If not, then we'll
	// fabricate it out of thin air.  (this is useful when we want to allow
	// repeat visits to the same NPC so the player can restock on items in some
	// scenarios).
	//
	// Also check to see if the item already exists in the recipient's inventory

	if (event.fromActor != None)
		invItemFrom = Pawn(event.fromActor).FindInventoryType(event.giveObject);

	invItemTo   = Pawn(event.toActor).FindInventoryType(event.giveObject);

//log("  invItemFrom = " $ invItemFrom, 'DevDataLinkPlay' );
//log("  invItemTo   = " $ invItemTo, 'DevDataLinkPlay' );

	// If the player is doing the giving, make sure we remove it from 
	// the object belt.

	// If the giver doesn't have the item then we must spawn a copy of it
	if (invItemFrom == None)
	{
		invItemFrom = Spawn(event.giveObject);
		bSpawnedItem = True;
	}

	// If we're giving this item to the player and he does NOT yet have it,
	// then make sure there's enough room in his inventory for the 
	// object!

	if ((invItemTo == None) &&
		(DeusExPlayer(event.toActor) != None) && 
	    (DeusExPlayer(event.toActor).FindInventorySlot(invItemFrom, True) == False))
	{
		// First destroy the object if we previously Spawned it
		if (bSpawnedItem)
			invItemFrom.Destroy();
				
		return nextAction;
	}

	// Okay, there's enough room in the player's inventory or we're not 
	// transferring to the player in which case it doesn't matter.
	//
	// Now check if the recipient already has the item.  If so, we are just
	// going to give it to him, with a few special cases.  Otherwise we
	// need to spawn a new object.

	if (invItemTo != None)
	{
		// Check if this item was in the player's hand, and if so, remove it
		RemoveItemFromPlayer(invItemFrom);

		// If this is ammo, then we want to just increment the ammo count
		// instead of adding another ammo to the inventory

		if (invItemTo.IsA('Ammo'))
		{
			// If this is Ammo and the player already has it, make sure the player isn't
			// already full of this ammo type! (UGH!)
			if (!Ammo(invItemTo).AddAmmo(Ammo(invItemFrom).AmmoAmount))
			{
				invItemFrom.Destroy();
				return nextAction;
			}

			// Destroy our From item
			invItemFrom.Destroy();		
		}

		// Pawn cannot have multiple weapons, but we do want to give the 
		// player any ammo from the weapon
		else if ((invItemTo.IsA('Weapon')) && (DeusExPlayer(event.ToActor) != None))
		{

			AmmoType = Ammo(DeusExPlayer(event.ToActor).FindInventoryType(Weapon(invItemTo).AmmoName));

			if ( AmmoType != None )
			{
				// Special case for Grenades and LAMs.  Blah.
				if ((AmmoType.IsA('AmmoEMPGrenade')) || 
				    (AmmoType.IsA('AmmoGasGrenade')) || 
					(AmmoType.IsA('AmmoNanoVirusGrenade')) ||
					(AmmoType.IsA('AmmoLAM')))
				{
					if (!AmmoType.AddAmmo(event.TransferCount))
					{
						invItemFrom.Destroy();
						return nextAction;
					}
				}
				else
				{
					if (!AmmoType.AddAmmo(Weapon(invItemTo).PickUpAmmoCount))
					{
						invItemFrom.Destroy();
						return nextAction;
					}

					event.TransferCount = Weapon(invItemTo).PickUpAmmoCount;
					itemsTransferred = event.TransferCount;
				}

				//if (event.ToActor.IsA('DeusExPlayer'))
					//DeusExPlayer(event.ToActor).UpdateAmmoBeltText(AmmoType);

				// Tell the player he just received some ammo!
				invItemTo = AmmoType;
			}
			else
			{
				// Don't want to show this as being received in a convo
				invItemTo = None;
			}

			// Destroy our From item
			invItemFrom.Destroy();
			invItemFrom = None;
		}

		// Otherwise check to see if we need to transfer more than 
		// one of the given item
		else
		{
			itemsTransferred = AddTransferCount(invItemFrom, invItemTo, event, Pawn(event.toActor), False);

			// If no items were transferred, then the player's inventory is full or 
			// no more of these items can be stacked, so abort.
			if (itemsTransferred == 0)
				return nextAction;

			// Now destroy the originating object (which we either spawned
			// or is sitting in the giver's inventory), but check to see if this 
			// item still has any copies left first

			if (((invItemFrom.IsA('HXPickup')) && (HXPickup(invItemFrom).bCanHaveMultipleCopies) && (HXPickup(invItemFrom).NumCopies <= 0)) ||
			   ((invItemFrom.IsA('HXPickup')) && (!HXPickup(invItemFrom).bCanHaveMultipleCopies)) ||
			   (!invItemFrom.IsA('HXPickup')))
			{
				invItemFrom.Destroy();
				invItemFrom = None;
			}
		}
	}

	// Okay, recipient does *NOT* have the item, so it must be give
	// to that pawn and the original destroyed
	else
	{
		// If the item being given is a stackable item and the 
		// recipient isn't receiving *ALL* the copies, then we 
		// need to spawn a *NEW* copy and give that to the recipient.
		// Otherwise just do a "SpawnCopy", which transfers ownership
		// of the object to the new owner.

		if ((invItemFrom.IsA('HXPickup')) && (HXPickup(invItemFrom).bCanHaveMultipleCopies) && 
		    (HXPickup(invItemFrom).NumCopies > event.transferCount))
		{
			itemsTransferred = event.TransferCount;
			invItemTo = Spawn(event.giveObject);
			invItemTo.GiveTo(Pawn(event.toActor));
			HXPickup(invItemFrom).NumCopies -= event.transferCount;
			bSplitItem   = True;
			bSpawnedItem = True;
		}
		else
		{
			invItemTo = invItemFrom.SpawnCopy(Pawn(event.toActor));
		}

//log("  invItemFrom = "$  invItemFrom, 'DevDataLinkPlay' );
//log("  invItemTo   = " $ invItemTo, 'DevDataLinkPlay' );

		if (DeusExPlayer(event.toActor) != None)
			DeusExPlayer(event.toActor).FindInventorySlot(invItemTo);

		// Check if this item was in the player's hand *AND* that the player is 
		// giving the item to someone else.
		if ((DeusExPlayer(event.fromActor) != None) && (!bSplitItem))
			RemoveItemFromPlayer(invItemFrom);

		// If this was a DataVaultImage, then the image needs to be 
		// properly added to the datavault

/*
		SHOULD NEVER BE REACHED ANYMORE

		if ((invItemTo.IsA('DataVaultImage')) && (event.toActor.IsA('DeusExPlayer')))
		{
			DeusExPlayer(event.toActor).AddImage(DataVaultImage(invItemTo));
				
			if (conWinThird != None)
				conWinThird.ShowReceivedItem(invItemTo, 1);
			else
				HXRootWindow(player.rootWindow).hud.receivedItems.AddItem(invItemTo, 1);

			invItemFrom = None;
			invItemTo   = None;
		}
*/
		// Special case for Credit Chits also
		/*else*/ if ((invItemTo.IsA('Credits')) && (event.toActor.IsA('DeusExPlayer')))
		{
			if (conWinThird != None)
				conWinThird.ShowReceivedItem(invItemTo, Credits(invItemTo).numCredits);
			else
				HXRootWindow(player.rootWindow).hud.receivedItems.AddItem(invItemTo, Credits(invItemTo).numCredits);

			player.Credits += Credits(invItemTo).numCredits;
			
			invItemTo.Destroy();

			invItemFrom = None;
			invItemTo   = None;
		}

		// Now check to see if the transfer event specified transferring
		// more than one copy of the object
		else
		{
			itemsTransferred = AddTransferCount(invItemFrom, invItemTo, event, Pawn(event.toActor), True);

			// If no items were transferred, then the player's inventory is full or 
			// no more of these items can be stacked, so abort.
			if (itemsTransferred == 0)
			{
				invItemTo.Destroy();
				return nextAction;
			}

			// Update the belt text
			//if (invItemTo.IsA('Ammo'))
				//player.UpdateAmmoBeltText(Ammo(invItemTo));
			//else
				//player.UpdateBeltText(invItemTo);
		}
	}

	// Show the player that he/she/it just received something!
	if ((DeusExPlayer(event.toActor) != None) && (conWinThird != None) && (invItemTo != None))
	{
		if (conWinThird != None)
			conWinThird.ShowReceivedItem(invItemTo, itemsTransferred);
		else
			HXRootWindow(player.rootWindow).hud.receivedItems.AddItem(invItemTo, itemsTransferred);
	}

	nextAction = EA_NextEvent;
	nextLabel = "";

	return nextAction;
}

// ---------------------------------------------------------------------
// AddTransferCount()
// ----------------------------------------------------------------------

function int AddTransferCount(
	Inventory invItemFrom, 
	Inventory invItemTo, 
	ConEventTransferObject event, 
	pawn transferTo, 
	bool bSpawned)
{
	local ammo AmmoType;
	local int itemsTransferred;
	local HXPickup giveItem;

	itemsTransferred = 1;
/*
log("AddTransferCount()-------------------------------", 'DevDataLinkPlay' );
log("  invItemFrom = " $ invItemFrom, 'DevDataLinkPlay' );
log("  invItemTo   = " $ invItemTo, 'DevDataLinkPlay' );
log("  transferTo  = " $ transferTo, 'DevDataLinkPlay' );
log("  bSpawned    = " $ bSpawned, 'DevDataLinkPlay' );
log("  event.transferCount = " $ event.transferCount, 'DevDataLinkPlay' );
*/
	if (invItemTo == None)
		return 0;

	// If this is a Weapon, then we need to just add additional 
	// ammo.
	if (invItemTo.IsA('Weapon'))
	{
		if (event.transferCount > 1)
		{
			AmmoType = Ammo(transferTo.FindInventoryType(Weapon(invItemTo).AmmoName));

			if ( AmmoType != None )
			{
				itemsTransferred = Weapon(invItemTo).PickUpAmmoCount * (event.transferCount - 1);
				AmmoType.AddAmmo(itemsTransferred);

				// For count displayed
				itemsTransferred++;
			}
		}
	}

	// If this is a HXPickup and he already has it, just 
	// increment the count
	else if ((invItemTo.IsA('HXPickup')) && (HXPickup(invItemTo).bCanHaveMultipleCopies))
	{
		// If the item was spawned, then it will already have a copy count of 1, so we
		// only want to add to that if it was specified to transfer > 1 items.

		if (bSpawned)
		{
			itemsTransferred = event.transferCount;
			if (event.transferCount > 1)
			{
				HXPickup(invItemTo).NumCopies += event.transferCount - 1;

				if (HXPickup(invItemTo).NumCopies > HXPickup(invItemTo).maxCopies)
				{
					itemsTransferred = HXPickup(invItemTo).maxCopies;
					HXPickup(invItemTo).NumCopies = HXPickup(invItemTo).maxCopies;
				}
			}
		}

		// Wasn't spawned, so add the appropriate amount (if transferCount
		// isn't specified, just add one).

		else
		{
			if (event.transferCount > 0)
				itemsTransferred = event.transferCount;
			else
				itemsTransferred = 1;

			if ((HXPickup(invItemTo).NumCopies + itemsTransferred) > HXPickup(invItemTo).MaxCopies)
				itemsTransferred = HXPickup(invItemTo).MaxCopies - HXPickup(invItemTo).NumCopies;

			HXPickup(invItemTo).NumCopies += itemsTransferred;

			if ((HXPickup(invItemFrom) != None) && (invItemFrom != InvItemTo))
				HXPickup(invItemFrom).NumCopies -= itemsTransferred;
		}

		// Update the belt text
		//HXPickup(invItemTo).UpdateBeltText();
	}
	else if ((invItemTo.IsA('HXPickup')) && (!bSpawned))
	{
		giveItem = HXPickup(Spawn(invItemTo.Class));
		giveItem.GiveTo(transferTo);
 
		// Just give the player another one of these fucking things
		if ((DeusExPlayer(transferTo) != None) && (DeusExPlayer(transferTo).FindInventorySlot(giveItem)))
			itemsTransferred = 1;
		else
			itemsTransferred = 0;
	}

//log("  return itemsTransferred = " $ itemsTransferred, 'DevDataLinkPlay' );

	return itemsTransferred;
}

// ----------------------------------------------------------------------
// RemoveItemFromPlayer()
//
// Check if this item was in the player's hand
// ----------------------------------------------------------------------

function RemoveItemFromPlayer(Inventory item)
{
	if ((player != None) && (item != None))
		player.RemoveItemDuringConversation(item);
}


// ----------------------------------------------------------------------
// SetupEventAddGoal()
//
// TODO: Add support for goals longer than 255 characters.  
// ----------------------------------------------------------------------

function EEventAction SetupEventAddGoal( ConEventAddGoal event, out String nextLabel )
{
	if ( !Event.bGoalCompleted )
	{
		// add goal
		Info.AddGoal( Event.GoalName, Event.bPrimaryGoal, Event.GoalText );
	}
	else
	{
		// mark as completed
		Info.GoalCompleted( Event.goalName ); 
	}
	return EA_NextEvent;
}

// ----------------------------------------------------------------------
// SetupEventAddNote()
//
// TODO: Add support for notes longer than 255 characters.  
// ----------------------------------------------------------------------

function EEventAction SetupEventAddNote( ConEventAddNote event, out String nextLabel )
{
	// Only add the note if it hasn't been added already (in case the PC has the same conversation more than once)
	if ( !Event.bNoteAdded )
	{
		// Add the note to the player's list of notes
		Info.AddNote( Event.NoteText, False, True );
		Event.bNoteAdded = True;
	}
	return EA_NextEvent;
}

// ----------------------------------------------------------------------
// SetupEventAddSkillPoints()
// ----------------------------------------------------------------------

function EEventAction SetupEventAddSkillPoints( ConEventAddSkillPoints event, out String nextLabel )
{
	Info.SkillPointsAdd( Event.PointsToAdd, "(DataLink)" );
	NextLabel = "";
	return EA_NextEvent;
}

// ----------------------------------------------------------------------
// SetupEventAddCredits()
//
// Adds the specified number of credits to the player.  If the 
// 'creditsToTransfer' variable is negative, this will cause
// the credits to get deducted from the player's credits total.
// ----------------------------------------------------------------------

function EEventAction SetupEventAddCredits( ConEventAddCredits event, out String nextLabel )
{
	//player.credits += event.creditsToAdd;

	// Make sure we haven't gone into the negative
	//player.credits = Max(player.credits, 0);

	Log( Self $ ".SetupEventAddCredits() Not implemented. Solly ;_;", 'DevDataLinkPlay' );

	nextLabel = "";
	return EA_NextEvent;
}

// ----------------------------------------------------------------------
// SetupEventCheckPersona()
// ----------------------------------------------------------------------

function EEventAction SetupEventCheckPersona( ConEventCheckPersona event, out String nextLabel )
{
	local EEventAction action;
	local int personaValue;
	local bool bPass;

	Log( Self$".SetupEventCheckPersona() called.", 'DevDataLinkPlay' );

	// First determine which persona item we're checking
	switch(event.personaType)
	{
		case EP_Credits:
			personaValue = player.Credits;
			break;

		case EP_Health:
			player.GenerateTotalHealth();
			personaValue = player.Health;
			break;

		case EP_SkillPoints:
			personaValue = player.SkillPointsAvail;
			break;
	}

	// Now decide what to do baby!
	switch(event.condition)
	{
		case EC_Less:
			bPass = (personaValue < event.value);
			break;

		case EC_LessEqual:
			bPass = (personaValue <= event.value);
			break;

		case EC_Equal:
			bPass = (personaValue == event.Value);
			break;

		case EC_GreaterEqual:
			bPass = (personaValue >= event.Value);
			break;

		case EC_Greater:
			bPass = (personaValue > event.Value);
			break;
	}

	if (bPass)
	{
		nextLabel = event.jumpLabel;
		action = EA_JumpToLabel;
	}
	else
	{
		nextLabel = "";
		action = EA_NextEvent;
	}

	return action;
}

// ----------------------------------------------------------------------
// StringToName()
// ----------------------------------------------------------------------

function Name StringToName( string Str )
{
	return Class'HXMutator'.static.StringToName( Str );
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bGameRelevant=True
}
