//=============================================================================
// HXDataLinkManager.
//
// Sort of inspired by BarkManager.
//
// TODO:
//  * Figure out how to deal with unplayed datalink on level transitions.
//=============================================================================
class HXDataLinkManager extends HXInfo
	transient;

var transient HXGameInfo Game;

// Localized Strings.
var localized String EndTransmissionString;
var localized string DataLinkTagString;

// ----------------------------------------------------------------------
// Init()
//
// Called by HXGameInfo during InitGame.
// ----------------------------------------------------------------------

function Init( HXGameInfo InGame )
{
	Game = InGame;
}

function bool StartDataLinkTransmission( string DataLinkName, optional HXDataLinkTrigger DataLinkTrigger )
{
	local ConListItem ConListItem;
	local Conversation Con;
	local Name FlagName;
	local Pawn P;
	local bool bDataLinkPlaySpawned;

	local string ConBindClass;
	local int MissionNumber;

	Log( Self $ ".StartDataLinkTransmission( " $ DataLinkName $ ", " $ DataLinkTrigger $ " ) called.", 'DevDataLinkPlay' );

	// Don't allow DataLinks to start if we're in PlayersOnly mode
	if ( Level.bPlayersOnly )
		return false;

	// Try binding List to GameInfo if empty.
	if ( Game.ConListItems==None )
	{
		MissionNumber = Game.DeusExLevelInfo.MissionNumber;

		if ( MissionNumber>=0 && MissionNumber<=9 )
			ConBindClass = "DeusExConText.ConList_Mission0" $ MissionNumber;
		else if ( MissionNumber>=10 && MissionNumber<=99 )
			ConBindClass = "DeusExConText.ConList_Mission" $ MissionNumber;
		else
		{
			Log( "WTF IS THIS MISSION NUMBER " $ MissionNumber, 'DevDataLinkPlay' );
			return false;
		}

		class'HXActor'.Static.BindConversationList( ConBindClass, Game );
	}

	// Return if DataLink has been played already.
	for ( ConListItem=ConListItem(Game.ConListItems); ConListItem!=None; ConListItem=ConListItem.Next )
	{
		Con = ConListItem.Con;

		//if ( Caps(DatalinkName) == Caps(Con.ConName) )
		if ( DatalinkName~=string(Con.ConName) )
		{
			if ( Con.bDisplayOnce )
			{
				FlagName = StringToName( Con.ConName$"_Played" );
				if ( Game.Steve.FlagBase.GetBool(FlagName) )
					return false;
			}
		}
	}

	// TODO: check flag refs here and assume them fulfilled clientside
	// LATER TODO: pass relevant flags for convo in by hand

	// Start DryRunner and clientside Datalink stuff if successful with DryRunner.
	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if( P.bIsPlayer && P.isA('HXPlayerPawn') )
		{
			//HXPlayerPawn(P).ClientStartDataLinkTransmission( DatalinkName, DatalinkTrigger );
			HXPlayerPawn(P).ClientStartDataLinkTransmission( DatalinkName, None ); // Never pass DataLinkTrigger to client!

			Log( "RPC'd DataLink for client"@P, 'DevDataLinkPlay' );
		}
	}
	return StartDataLinkDryRunner( DatalinkName, DatalinkTrigger );
}

// ----------------------------------------------------------------------
// StartDataLinkDryRunner()
//
// Locates and starts the DataLink passed in
// ----------------------------------------------------------------------

function bool StartDataLinkDryRunner( string DataLinkName, optional HXDataLinkTrigger DatalinkTrigger )
{
	local Conversation ActiveDataLink;
	local bool bDataLinkPlaySpawned; // I should probably move to some always spawn DataLinkPlay for GameInfo on startup approach.

	// Don't allow DataLinks to start if we're in PlayersOnly mode.
	if ( Level.bPlayersOnly )
		return false;

	ActiveDataLink = GetActiveDataLink( DataLinkName );

	if ( ActiveDataLink!=None )
	{
		// Search to see if there's an active DataLinkPlay object before creating one.
		if ( Game.DataLinkPlay==None )
		{
			Game.DatalinkPlay = Game.Spawn( class'HXDataLinkDryRunner' );
			bDataLinkPlaySpawned = true;
		}

		// Call SetConversation(), which returns .
		if ( Game.DatalinkPlay.SetConversation(ActiveDataLink) )
		{
			Game.DataLinkPlay.SetHXTrigger(DatalinkTrigger);

			if ( Game.DataLinkPlay.StartDryConversation(Game) )
			{
				return true;
			}
			else
			{
				// Datalink must already be playing, or in queue
				if ( bDataLinkPlaySpawned )
				{
					Game.DataLinkPlay.Destroy();
					Game.DataLinkPlay = None;
				}
				
				return false;
			}
		}
		else
		{
			// Datalink must already be playing, or in queue
			if ( bDataLinkPlaySpawned )
			{
				Game.DataLinkPlay.Destroy();
				Game.DataLinkPlay = None;
			}
			return false;
		}
	}
	else
	{
		return false;
	}
}

// ----------------------------------------------------------------------
// GetActiveDataLink()
// ----------------------------------------------------------------------

function Conversation GetActiveDataLink( string DataLinkName )
{
	local Name flagName;
	local ConListItem ConListItem;
	local Conversation Con;
	local bool bAbortDataLink;
	local bool bDatalinkFound;
	local bool bDataLinkNameFound;

	// Abort immediately if the flagbase isn't yet initialized.
	if ( Game.Steve.FlagBase==None )
		return None;

	// In a loop, go through the conversations, checking each.
	for ( ConListItem=ConListItem(Game.ConListItems); ConListItem!=None; ConListItem=ConListItem.Next )
	{
		Con = ConListItem.Con;

		//if ( Caps(DataLinkName)==Caps(Con.ConName) )
		if ( DataLinkName~=string(Con.ConName) )
		{
			// Now check if this DataLink is only to be played once.
			bDataLinkNameFound = true;
			bAbortDataLink = false;

			if ( Con.bDisplayOnce )
			{
				FlagName = StringToName( Con.ConName$"_Played" );
				bAbortDataLink = Game.Steve.FlagBase.GetBool(FlagName);
			}

			// Check the flags for this DataLink.
			if ( !bAbortDataLink && CheckFlagRefs(Con.FlagRefList) )
			{
				bDatalinkFound = true;
				break;
			}
		}
	}

	// We found it and are happy.
	if ( bDatalinkFound)
		return Con;

	// Debug output if we for example encounter a non existing DL name.
	if ( !bDataLinkNameFound )
	{
		// Print a warning if this DL couldn't be found based on its name
		Log( "WARNING! INFOLINK NOT FOUND!! (DryRunner) Name = " $ DataLinkName );
		BroadcastMessage( "WARNING! INFOLINK NOT FOUND!! (DryRunner) Name = " $ DataLinkName );
	}

	return None;
}

// ----------------------------------------------------------------------
// CheckFlagRefs()
//
// Loops through the flagrefs passed in and sees if the current flag
// settings in the game match this set of flags.  Returns True if so,
// otherwise False.
// ----------------------------------------------------------------------

function bool CheckFlagRefs( ConFlagRef FlagRef )
{
	local ConFlagRef Ref;

	// Loop through our list of FlagRef's, checking the value of each.
	// If we hit a bad match, then we'll stop right away since there's
	// no point of continuing.
	Ref = FlagRef;
	while( Ref!=None )
	{
		if ( Game.Steve.FlagBase.GetBool(Ref.FlagName)!=Ref.Value )
			return False;
		Ref = Ref.NextFlagRef;
	}
	
	// If we made it this far, then the flags check out.
	return True;
}

// ----------------------------------------------------------------------------
// PruneCurrent()
//
// Called before current map progress is saved just before switching level.
// Out parameter can be used to flag or unflag actor as transient.
//
// Be aware that this can break linked lists such as Level.PawnList.
// ----------------------------------------------------------------------------

simulated event PruneCurrent( out byte bTransient )
{
	bTransient = 1;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	//BindName="JCDenton"
	EndTransmissionString="END TRANSMISSION..."
	DataLinkTagString="(DataLink)"
	RemoteRole=ROLE_None
	bHidden=True
	bTravel=False
	bGameRelevant=True
}
