//=============================================================================
// HXDeusExCampaignMutator.
//=============================================================================
class HXDeusExCampaignMutator extends HXCampaignMutator;

// ----------------------------------------------------------------------------
// PreSetupActors()
//
// Apply script side fixes to original Actors inside Maps before they have
// a chance of getting replaced by any other Mutator logic.
// ----------------------------------------------------------------------------

function bool PreSetupActors( Actor Other, Name MapName, out byte bSuperRelevant )
{
	local class<Actor> SpawnClass;
	local Teleporter Teleporter;
	local MapExit MapExit;
	local string OldURL, OldDestMap;

	//
	// GENERAL.
	//

	// MapExits and Teleporters contain bogus URLs containing map file extension and/or whitespaces.
	// (e.g. "14_OceanLab_Lab.dx #Sunkenlab").
	MapExit = MapExit(Other);
	if ( MapExit!=None )
	{
		OldDestMap = MapExit.DestMap;
		if ( SanitizeURL(MapExit.DestMap) )
			Log( Sprintf("Sanitized DestMap on MapExit (Other=%s,DestMap=\"%s\",OldDestMap=\"%s\").",MapExit.DestMap,OldDestMap), 'DevMutator' );
	}
	Teleporter = Teleporter(Other);
	if ( Teleporter!=None )
	{
		OldURL = Teleporter.URL;
		if ( SanitizeURL(Teleporter.URL) )
			Log( Sprintf("Sanitized URL on Teleporter (Other=%s,URL=\"%s\",OldURL=\"%s\").",Teleporter.URL,OldURL), 'DevMutator' );
	}

	//
	// 00_TRAINING.
	//
	if ( MapName=='00_Training' )
	{
		switch ( Other.Name )
		{
			// Medical room carcass Trigger. Hack this to be triggered by PlayerProximity instead as
			// corpses can't be carried in HX (as the animations for it are missing).
			case 'Trigger0':
				Trigger(Other).ClassProximityType = None;
				Trigger(Other).TriggerType        = TT_PlayerProximity;
				break;
		}

		// Place special FlagTrigger which also strips Inventory for MunitionsTrooper.
		if ( Other.IsA('FlagTrigger') && FlagTrigger(Other).FlagName=='MunitionsTrooperReady' )
		{
			SpawnClass = class'HXDeusExTrainingMunitionsTrooperTrigger';
			Game.ModifyActorClass( SpawnClass );
			return SpawnSuccessor( Other, SpawnClass );
		}
	}

	//
	// 00_TRAININGCOMBAT.
	//
	else if ( MapName=='00_TrainingCombat' )
	{
		switch ( Other.Name )
		{
			// Prevent doors from closing, so other Players can always catch up.
			case 'Trigger1': // gunrangeexit.
			case 'Trigger3': // riflerangeexit.
			case 'Trigger0': // demolitionsdoor.
			case 'Trigger4': // DemolitionExitDoors.
			case 'Trigger2': // bd2.
			case 'Trigger6': // StealthEntry.
				return false;
				break;
		}

		// Place special FlagTrigger which also strips Inventory for MunitionsTrooper.
		if ( Other.IsA('FlagTrigger') && FlagTrigger(Other).FlagName=='MunitionsTrooperReady' )
		{
			SpawnClass = class'HXDeusExTrainingMunitionsTrooperTrigger';
			Game.ModifyActorClass( SpawnClass );
			return SpawnSuccessor( Other, SpawnClass );
		}
	}

	//
	// 00_TRAININGFINAL.
	//
	else if ( MapName=='00_TrainingFinal' )
	{
		switch ( Other.Name )
		{
			// Training end points to DX.dx, but for now 01_NYC_UNATCOIsland with !bItems is desired.
			case 'MapExit0':
				MapExit(Other).DestMap = "01_NYC_UNATCOIsland";

				SpawnClass = class'HXMapExitNoItems';
				Game.ModifyActorClass( SpawnClass );
				return SpawnSuccessor( Other, SpawnClass );
				break;

			// Prevent door from closing, so other Players can always catch up.
			case 'Trigger1': // finaldoorsenter.
				return false;
				break;
		}

		// Place special FlagTrigger which also strips Inventory for MunitionsTrooper.
		if ( Other.IsA('FlagTrigger') && FlagTrigger(Other).FlagName=='MunitionsTrooperReady' )
		{
			SpawnClass = class'HXDeusExTrainingMunitionsTrooperTrigger';
			Game.ModifyActorClass( SpawnClass );
			return SpawnSuccessor( Other, SpawnClass );
		}
	}

	//
	// 01_NYC_UNATCOISLAND.
	//
	else if ( MapName=='01_NYC_UNATCOIsland' )
	{
		switch ( Other.Name )
		{
			// Fix wrong FragmentClass and ExplodeSounds on chest lid.
			case 'DeusExMover1':
				HXMover(Other).ExplodeSound1 = Sound'MetalHit2';
				HXMover(Other).ExplodeSound2 = Sound'MetalHit1';
				HXMover(Other).FragmentClass = Class'MetalFragment';
				break;

			// You couldn't highlight/frob the other bots, changed so
			// other players can quickly heal as well. Looks like ION just 
			// disabled the other bots, so the bots wouldn't move, the
			// usable one remained in Wandering state.
			case 'MedicalBot0':
			case 'MedicalBot1':
				ScriptedPawn(Other).bHighlight = true;
				// Fall through to 'MedicalBot1'.
			case 'MedicalBot1':
				ScriptedPawn(Other).Orders = 'Standing'; // Was Wandering/Idle before.
				break;

		}
	}

	//
	// 02_NYC_BATTERYPARK.
	//
	else if ( MapName=='02_NYC_BatteryPark' )
	{
		switch ( Other.Name )
		{
			// It fell out of world in original dx, so move it bit
			case 'Trashbag1':
				Other.SetLocation( Other.Location+vect(36,17,0) );
				break;

			// !! FIND ACTOR NAME !!
			default:
				if ( Other.BindName=="BoatPilot" )
					Other.BindName = "NYPoliceBoat";
				break;
		}
	}

	//
	// 02_NYC_UNDERGROUND.
	//
	else if ( MapName=='02_NYC_Underground' )
	{
		switch ( Other.Name )
		{
			// ControlPanal is frobable through wall, because collision cylinder reaches beyond the wall.
			case 'ControlPanel2':
				Other.SetCollisionSize( 12.0, Other.CollisionHeight );
				break;
		}
	}

	//
	// 03_NYC_AIRFIELD.
	//
	else if ( MapName=='03_NYC_Airfield' )
	{
		switch ( Other.Name )
		{
			// Fix wrong FragmentClass and ExplodeSounds on chest lids.
			case 'DeusExMover0':
			case 'DeusExMover18':
			case 'DeusExMover21':
			case 'DeusExMover23':
				HXMover(Other).ExplodeSound1 = Sound'MetalHit2';
				HXMover(Other).ExplodeSound2 = Sound'MetalHit1';
				HXMover(Other).FragmentClass = Class'MetalFragment';
				break;

			// Fix ExplodeSounds on trailer doors.
			case 'DeusExMover19':
			case 'DeusExMover20':
			case 'DeusExMover65':
			case 'DeusExMover67':
				HXMover(Other).ExplodeSound1 = Sound'MetalHit2';
				HXMover(Other).ExplodeSound2 = Sound'MetalHit1';
				break;
		}
	}

	//
	// 03_NYC_BATTERYPARK.
	//
	else if ( MapName=='03_NYC_BatteryPark' )
	{
		switch ( Other.Name )
		{
			// Fix wrong FragmentClass and ExplodeSounds on chest lid.
			case 'DeusExMover18':
				HXMover(Other).ExplodeSound1 = Sound'MetalHit2';
				HXMover(Other).ExplodeSound2 = Sound'MetalHit1';
				HXMover(Other).FragmentClass = Class'MetalFragment';
				break;
		}
	}

	//
	// 04_NYC_NSFHQ.
	//
	else if ( MapName=='04_NYC_NSFHQ' )
	{
		switch ( Other.Name )
		{
			// Completely stuck inside wall, just remove to shut up falling out of world log.
			case 'UNATCOTroop27':
				return false;
				break;
		}
	}

	//
	// 05_NYC_UNATCOMJ12LAB.
	//
	else if ( MapName=='05_NYC_UNATCOMJ12lab' )
	{
		switch ( Other.Name )
		{
			// It fell out of world in original dx, so move it up a bit.
			case 'Datacube8':
				Other.SetLocation( Other.Location+vect(0,0,32) );
				break;

			// Tag Baton and Knife for MissionScript.
			case 'WeaponBaton1':
				Other.Event = 'MissionScript';
				Other.Tag   = 'StartupBaton';
				break;
			case 'WeaponCombatKnife0':
				Other.Event = 'MissionScript';
				Other.Tag   = 'StartupCombatKnife';
				break;
		}
	}

	//
	// 05_NYC_UNATCOHQ.
	//
	else if ( MapName=='05_NYC_UNATCOHQ' )
	{
		switch ( Other.Name )
		{
		}
	}

	//
	// 06_HONGKONG_HELIBASE.
	//
	else if ( MapName=='06_HongKong_Helibase' )
	{
		switch ( Other.Name )
		{
			// Datacube is placed at an angle, but pitch gets reset with PHYS_Falling.
			case 'Datacube5':
				Other.SetPhysics( PHYS_None );
				break;
		}
	}

	//
	// 06_HONGKONG_WANCHAI_CANAL.
	//
	else if ( MapName=='06_HongKong_WanChai_Canal' )
	{
		switch ( Other.Name )
		{
			// Fix wrong FragmentClass and ExplodeSounds on chest lid.
			case 'DeusExMover85':
				HXMover(Other).ExplodeSound1 = Sound'MetalHit2';
				HXMover(Other).ExplodeSound2 = Sound'MetalHit1';
				HXMover(Other).FragmentClass = Class'MetalFragment';
				break;

			// Fix wrong FragmentClass and ExplodeSounds on hatch on barge. 
			case 'DeusExMover13':
				// Note: Maybe a "heavier" sound?
				HXMover(Other).ExplodeSound1 = Sound'MetalHit2';
				HXMover(Other).ExplodeSound2 = Sound'MetalHit1';
				HXMover(Other).FragmentClass = Class'MetalFragment';
				break;

			// Has invalid 'Stasis' Orders set and jumps up.
			//case 'RepairBot0':
				//ScriptedPawn(Other).Orders = 'Standing';
				//ScriptedPawn(Other).bCollideWorld = bCollideWorld;
				//ScriptedPawn(Other).bCollideWhenPlacing = bCollideWhenPlacing;
				//break;
		}
	}

	//
	// 06_HONGKONG_WANCHAI_STREET.
	//
	else if ( MapName=='06_HongKong_WanChai_Street' )
	{
		switch ( Other.Name )
		{
			// Fix for the elevator for Jocks apartment won't come up,
			// !! Players can probably get trapped on top though.
			case 'Button0':
				Other.Event = 'JocksElevatorTop';
				break;
		}
	}

	//
	// 10_PARIS_CATACOMBS_TUNNELS.
	//
	else if ( MapName=='10_Paris_Catacombs_Tunnels' )
	{
		switch ( Other.Name )
		{
			// Fix wrong FragmentClass and ExplodeSounds on chest lids.
			case 'DeusExMover0':
			case 'DeusExMover12':
			case 'DeusExMover13':
				HXMover(Other).ExplodeSound1 = Sound'MetalHit2';
				HXMover(Other).ExplodeSound2 = Sound'MetalHit1';
				HXMover(Other).FragmentClass = Class'MetalFragment';
				break;
		}
	}

	//
	// 10_PARIS_METRO.
	//
	else if ( MapName=='10_Paris_Metro' )
	{
		switch ( Other.Name )
		{
			// Fix wrong FragmentClass and ExplodeSounds on chest lid.
			case 'DeusExMover20':
				HXMover(Other).ExplodeSound1 = Sound'MetalHit2';
				HXMover(Other).ExplodeSound2 = Sound'MetalHit1';
				HXMover(Other).FragmentClass = Class'MetalFragment';
				break;
		}
	}

	//
	// 14_OCEANLAB_LAB.
	//
	else if ( MapName=='14_OceanLab_Lab' )
	{
		switch ( Other.Name )
		{
			// Add a combat knife to the dead trooper at map start.
			case 'MJ12TroopCarcass1':
				MJ12TroopCarcass(Other).InitialInventory[2].Inventory = Class'WeaponCombatKnife';
				MJ12TroopCarcass(Other).InitialInventory[2].Count     = 1;
				break;
		}
	}

	//
	// 14_OCEANLAB_SILO.
	//
	else if ( MapName=='14_Oceanlab_Silo' )
	{
		switch ( Other.Name )
		{
			// Fix wrong FragmentClass and ExplodeSounds.
			case 'DeusExMover21':
			case 'DeusExMover22':
				HXMover(Other).ExplodeSound1 = Sound'MetalHit2';
				HXMover(Other).ExplodeSound2 = Sound'MetalHit1';
				HXMover(Other).FragmentClass = Class'MetalFragment';
				break;

			// Silo elevator buttons do have collision disabled by default, which won't get reset anymore in HX.
			case 'Button8':
			case 'Button9':
			case 'Button10':
			case 'Button11':
			case 'Button12':
			case 'Button13':
				Other.SetCollision( true, false, false );
				break;
		}
	}

	//
	// 14_VANDENBERG_SUB.
	//
	else if ( MapName=='14_Vandenberg_Sub' )
	{
		switch ( Other.Name )
		{
			// Enlarge radius of triggers at map start.
			case 'DataLinkTrigger3':
			case 'InterpolateTrigger0':
				Other.SetCollisionSize( 400.0, Other.CollisionHeight );
				break;
		}
	}

	//
	// 15_AREA51_FINAL.
	//
	else if ( MapName=='15_Area51_Final' )
	{
		switch ( Other.Name )
		{
			// Set special names for LifeSupportBase used for Helios uplink (won't show for clients though).
			case 'LifeSupportBase0':
				LifeSupportBase(Other).ItemName = "Alpha";
				break;
			case 'LifeSupportBase1':
				LifeSupportBase(Other).ItemName = "Omega";
				break;
		}
	}

	return true;
}

// ----------------------------------------------------------------------------
// SpawnAdditionalActors()
//
// Called during PreBeginPlay() on the first visit of the map.
// ----------------------------------------------------------------------------

function SpawnAdditionalActors( Name MapName )
{
	local Actor Actor;
	local Inventory Inventory;
	local Switch1 Switch1;
	local bool bSwitchFound;

	local HXAugmentationCannister AugmentationCannister;

	//
	// 01_NYC_UNATCOHQ.
	//
	if ( MapName=='01_NYC_UNATCOHQ' )
	{
		// Non map patch versions miss the button to open the guards posts room.
		bSwitchFound = false;
		foreach AllActors( class'Switch1', Switch1 )
		{
			if ( Switch1.Event=='cannotopen' )
			{
				// Adjust rotation slightly.
				Switch1.SetRotation( rot(0,-16392,0) );
				bSwitchFound = true;
				break;
			}
		}
		if ( !bSwitchFound )
		{
			// 03/04/05_UNATCOHQ use two different button types on two spots.
			// with none of them matching. So use the remaining combination for HX.
			Actor = SpawnModifiedActor( class'Switch2', None, '', vect(-2120,494,610), rot(0,-16392,0), true );
			if ( Actor!=None )
			{
				Actor.Event = 'cannotopen';
			}
		}

		// 
		// Game has only one arm agumentation cannister. so add another one.
		//

		// Spawn Cart.
		SpawnModifiedActor( class'Cart', None, '', vect(1346,531,-37), rot(0,0,0), true );

		// Spawn AugmentationCannister on top of cart.
		AugmentationCannister = HXAugmentationCannister(SpawnModifiedInventory( class'AugmentationCannister', None, '', vect(1349,523,2), rot(0,0,0), true ));
		if ( AugmentationCannister!=None ) // !! FIX-ME !! Make this not depend on HXAugmentationCannister class.
		{
			AugmentationCannister.AddAugs[0] = 'HXAugMuscle';
			AugmentationCannister.AddAugs[1] = 'HXAugCombat';
		}
	}

	//
	// 10_PARIS_CATACOMBS.
	//
	else if ( MapName=='10_Paris_Catacombs' )
	{
		// Spawn second HazMatSuit in empty holder.
		SpawnModifiedInventory( class'HazMatSuit', None, '', vect(-1911,5336,4), rot(0,-16392,0), true );
	}

	//
	// 14_OCEANLAB_LAB.
	//
	else if ( MapName=='14_OceanLab_Lab' )
	{
		// Add missing outside top elevator button.
		Actor = SpawnModifiedActor( class'Switch2', None, '', vect(1582,3603,-2465), rot(0,0,0), true );
		if ( Actor!=None )
		{
			Actor.Event = 'st1';
		}
	}

	//
	// 14_OCEANLAB_SILO.
	//
	else if ( MapName=='14_OceanLab_Silo' )
	{
		// Add a FlagTrigger to catch trap closing missle silo door, so outside keypad can be hacked by missionscript.
		Actor = SpawnModifiedActor( class'FlagTrigger', None, 'doorclose', vect(0,0,0), rot(0,0,0), true);
		if ( Actor!=None )
		{
			Actor.SetPropertyText( "FlagName"           , string('M14_SiloDoorClosed') );
			Actor.SetPropertyText( "FlagValue"          , string(true                ) );
			Actor.SetPropertyText( "bSetFlag"           , string(true                ) );
			Actor.SetPropertyText( "bTrigger"           , string(false               ) );
			Actor.SetPropertyText( "bWhileStandingOnly" , string(false               ) );
			Actor.SetPropertyText( "FlagExpiration"     , string(15                  ) );
		}
	}

	//
	// 14_VANDENBERG_SUB.
	//
	else if ( MapName=='14_Vandenberg_Sub' )
	{
		// Add missing top elevator button.
		Actor = SpawnModifiedActor( class'Switch2', None, '', vect(3801,-446,-1702), rot(0,16384,0), true );
		if ( Actor!=None )
		{
			Actor.Event = 'Elevator1';
		}

		// Add missing bottom elevator button.
		Actor = SpawnModifiedActor( class'Switch2', None, '', vect(3806,-486,-370), rot(0,8192,0), true );
		if ( Actor!=None )
		{
			Actor.Event = 'Elevator1';
		}
	}
}

// ----------------------------------------------------------------------------
// CheckMissionScriptClassReplacement()
//
// Conveniance interface for ModifyMissionScriptClass similiar to 
// CheckReplacement.
// ----------------------------------------------------------------------------

function bool CheckMissionScriptClassReplacement( out Class<MissionScript> MissionScriptClass, Name LevelName )
{
	// Fix for missionscript in 12_Vandenberg_Tunnels missing.
	if ( MissionScriptClass==None && LevelName=='12_Vandenberg_Tunnels' )
		MissionScriptClass = class'Mission12';

	// Replace MissionScript if present.
	if ( MissionScriptClass!=None )
	{
		switch ( MissionScriptClass.Name )
		{
			// Intro.
			case 'MissionIntro': MissionScriptClass = Class'HXMissionIntro'; break;

			// Training.
			case 'Mission00': MissionScriptClass = Class'HXMission00'; break;

			// Campaign.
			case 'Mission01': MissionScriptClass = Class'HXMission01'; break;
			case 'Mission02': MissionScriptClass = Class'HXMission02'; break;
			case 'Mission03': MissionScriptClass = Class'HXMission03'; break;
			case 'Mission04': MissionScriptClass = Class'HXMission04'; break;
			case 'Mission05': MissionScriptClass = Class'HXMission05'; break;
			case 'Mission06': MissionScriptClass = Class'HXMission06'; break;
			case 'Mission08': MissionScriptClass = Class'HXMission08'; break;
			case 'Mission09': MissionScriptClass = Class'HXMission09'; break;
			case 'Mission10': MissionScriptClass = Class'HXMission10'; break;
			case 'Mission11': MissionScriptClass = Class'HXMission11'; break;
			case 'Mission12': MissionScriptClass = Class'HXMission12'; break;
			case 'Mission14': MissionScriptClass = Class'HXMission14'; break;
			case 'Mission15': MissionScriptClass = Class'HXMission15'; break;

			// Endgame.
			case 'MissionEndgame': MissionScriptClass = Class'HXMissionEndgame'; break;
		}
	}

	// Let further Mutators again swap MissionScript.
	return true;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
}
