//=============================================================================
// HXDeusExCoopHUD.
//=============================================================================
class HXDeusExCoopHUD extends HXDeusExHUD;

// Sounds for ClientMessages.
var Sound MessageSoundCoopSay;

// ----------------------------------------------------------------------------
// CustomizeMessageType()
//
// Custome Color and Sounds based on Mesage Types. Mod authors may want to
// modify existing or handle their own custom message types.
// (e.g. DM style enemy message sounds).
//
// Called by MsgLog.
// ----------------------------------------------------------------------------

function CustomizeMessageType( Name Type, out Color MessageColor, out Sound MessageSound, out float MessageSoundVolume )
{
	switch ( Type )
	{
		// Make Say and TeamSay have both the friendly sound and white color.
		case 'Say':
		case 'TeamSay':
			MessageColor       = MakeColor( 255, 255, 255, 255 );
			MessageSound       = MessageSoundCoopSay;
			MessageSoundVolume = 0.75;
			return;
			break;
	}

	Super.CustomizeMessageType( Type, MessageColor, MessageSound, MessageSoundVolume );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	// Temporary until Logan comes up with something awesome.
	MessageSoundCoopSay=Menu_Cancel
}
