//=============================================================================
// HXDeusExHUD.
//=============================================================================
class HXDeusExHUD extends HXHUD;

/*
var Crosshair						cross;
var TimerDisplay					timer;
var FrobDisplayWindow				frobDisplay;
var DamageHUDDisplay				damageDisplay;
var AugmentationDisplayWindow		augDisplay;

// NEW STUFF!

var HUDHitDisplay					hit;
var HUDCompassDisplay               compass;
var HUDAmmoDisplay					ammo;
var HUDObjectBelt					belt;
var HUDInformationDisplay           info;
var HUDInfoLinkDisplay				infolink;
var HUDLogDisplay					msgLog;
var HUDConWindowFirst				conWindow;
var HUDMissionStartTextDisplay      startDisplay;
var HUDActiveItemsDisplay			activeItems;
var HUDBarkDisplay					barkDisplay;
var HUDReceivedDisplay				receivedItems;

var HUDMultiSkills					hms;
*/

var HXHUDObjectBelt HXBelt;

// Minimum required space for msglog left next to infolink window to show up.
var float MessageLogMinWidth;

// Sounds for ClientMessages.
var Sound MessageSoundSay;
var Sound MessageSoundTeamSay;
var Sound MessageSoundNoteAdded;
var Sound MessageSoundGoalAdded;
var Sound MessageSoundGoalCompleted;
var Sound MessageSoundSkillPoints;

var bool bCanFitMessageLog;

// ----------------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------------

event InitWindow()
{
	local HXRootWindow root;
	local HXPlayerPawn player;

	Super.InitWindow();

	// Get a pointer to the root window
	root = HXRootWindow(GetRootWindow());

	// Get a pointer to the player
	player = HXPlayerPawn(root.parentPawn);

	SetFont(Font'TechMedium');
	SetSensitivity(false);

	ammo			= HUDAmmoDisplay(NewChild(Class'HUDAmmoDisplay'));
	hit				= HXHUDHitDisplay(NewChild(Class'HXHUDHitDisplay'));
	cross			= Crosshair(NewChild(Class'Crosshair'));
	HXBelt			= HXHUDObjectBelt(NewChild(Class'HXHUDObjectBelt'));
	activeItems		= HXHUDActiveItemsDisplay(NewChild(Class'HXHUDActiveItemsDisplay'));
	damageDisplay	= DamageHUDDisplay(NewChild(Class'DamageHUDDisplay'));
	compass     	= HXHUDCompassDisplay(NewChild(Class'HXHUDCompassDisplay'));
	//hms				= HUDMultiSkills(NewChild(Class'HUDMultiSkills'));

	// Create the InformationWindow
	info = HXHUDInformationDisplay(NewChild(Class'HXHUDInformationDisplay', False));

	// Create the log window
	msgLog	= HXHUDLogDisplay(NewChild(Class'HXHUDLogDisplay', False));
	//msgLog.SetLogTimeout(player.GetLogTimeout());

	frobDisplay = HXFrobDisplayWindow(NewChild(Class'HXFrobDisplayWindow'));
	frobDisplay.SetWindowAlignments(HALIGN_Full, VALIGN_Full);

	augDisplay	= HXAugmentationDisplayWindow(NewChild(Class'HXAugmentationDisplayWindow'));
	augDisplay.SetWindowAlignments(HALIGN_Full, VALIGN_Full);

	startDisplay = HUDMissionStartTextDisplay(NewChild(Class'HUDMissionStartTextDisplay', False));

	//startDisplay.SetWindowAlignments(HALIGN_Full, VALIGN_Full);

	// Bark display
	barkDisplay = HXHUDBarkDisplay(NewChild(Class'HXHUDBarkDisplay', False));

	// Received Items Display
	receivedItems = HUDReceivedDisplay(NewChild(Class'HUDReceivedDisplay', False));

	bTickEnabled = true;
}

// ----------------------------------------------------------------------------
// DescendantRemoved()
// ----------------------------------------------------------------------------

event DescendantRemoved(Window descendant)
{
	if      (descendant == ammo)
		ammo  = None;
	else if (descendant == hit)
		hit   = None;
	else if (descendant == cross)
		cross = None;
	else if (descendant == HXBelt)
		HXBelt  = None;
	else if (descendant == activeItems)
		activeItems = None;
	else if (descendant == damageDisplay)
		damageDisplay = None;
	else if (descendant == infolink)
		infolink = None;
	else if (descendant == timer)
		timer = None;
	else if (descendant == msgLog)
		msgLog = None;
	else if (descendant == info)
		info = None;
	else if (descendant == conWindow)
		conWindow = None;
	else if (descendant == frobDisplay)
		frobDisplay = None;
	else if (descendant == augDisplay)
		augDisplay = None;
	else if (descendant == compass)
		compass = None;
	else if (descendant == startDisplay)
		startDisplay = None;
	else if (descendant == barkDisplay)
		barkDisplay = None;
	else if (descendant == receivedItems)
		receivedItems = None;
	else if ( descendant == hms )
		hms = None;
}

// ----------------------------------------------------------------------------
// ConfigurationChanged()
// ----------------------------------------------------------------------------

function ConfigurationChanged()
{
	local float QueryWidth, QueryHeight;
	local float compassWidth, compassHeight;
	local float beltWidth, beltHeight;
	local float ammoWidth, ammoHeight;
	local float hitWidth, hitHeight;
	local float infoX, infoY, infoTop, infoBottom;
	local float infoWidth, infoHeight, maxInfoWidth, maxInfoHeight;
	local float itemsWidth, itemsHeight;
	local float damageWidth, damageHeight;
	local float InfoLinkWidth, InfoLinkHeight;
	local float MsgLogX, MsgLogY, MsgLogWidth, MsgLogHeight, MsgLogXPad;
	local float conHeight;
	local float barkWidth, barkHeight;
	local float recWidth, recHeight, recPosY;
	//local float logTop;

	if (ammo != None)
	{
		if (ammo.IsVisible())
		{
			ammo.QueryPreferredSize(ammoWidth, ammoHeight);
			ammo.ConfigureChild(0, height-ammoHeight, ammoWidth, ammoHeight);
		}
		else
		{
			ammoWidth  = 0;
			ammoHeight = 0;
		}
	}

	if (hit != None)
	{
		if (hit.IsVisible())
		{
			hit.QueryPreferredSize(hitWidth, hitHeight);
			hit.ConfigureChild(0, 0, hitWidth, hitHeight);
		}
	}

	// Stick the Compass directly under the Hit display
	if (compass != None)
	{
		compass.QueryPreferredSize(compassWidth, compassHeight);
		compass.ConfigureChild(0, hitHeight + 4, compassWidth, compassHeight);

		if (hitWidth == 0)
			hitWidth = compassWidth;
	}

	if (cross != None)
	{
		cross.QueryPreferredSize(QueryWidth, QueryHeight);
		cross.ConfigureChild((width-QueryWidth)*0.5+0.5, (height-QueryHeight)*0.5+0.5, QueryWidth, QueryHeight);
	}
	if (HXBelt != None)
	{
		HXBelt.QueryPreferredSize(beltWidth, beltHeight);
		HXBelt.ConfigureChild(width - beltWidth, height - beltHeight, beltWidth, beltHeight);

		infoBottom = height - beltHeight;
	}
	else
	{
		infoBottom = height;
	}

	//
	// Damage display.
	//
	// Left side, under the compass.
	//
	if ( DamageDisplay!=None )
	{
		// Doesn't check to see if it might bump into the Hit Display 
		DamageDisplay.QueryPreferredSize( DamageWidth, DamageHeight );
		DamageDisplay.ConfigureChild( 0.0, HitHeight+CompassHeight+4.0, DamageWidth, DamageHeight );
	}

	//
	// Active Items, includes Augmentations and various charged Items.
	// 
	// Upper right corner.
	//
	if ( ActiveItems!=None && ActiveItems.IsVisible() )
	{
		ItemsWidth = ActiveItems.QueryPreferredWidth( Height-BeltHeight );

		ActiveItems.ConfigureChild( Width-ItemsWidth, 0.0, ItemsWidth, Height-BeltHeight );
	}

	// Display the infolink to the right of the hit display.
	if ( Infolink!=None && Infolink.IsVisible(false) )
	{
		Infolink.QueryPreferredSize( InfoLinkWidth, InfoLinkHeight );
		Infolink.ConfigureChild( HitWidth+20, 0, InfoLinkWidth, InfoLinkHeight );

		InfoLinkWidth += 16.0;//24.0;
	}

	// Display the Log right of the hit display, or at the right of the infolink if present,
	// as long there is enough room left.
	if ( MsgLog!=None )
	{
		// Preferably visible.
		//if ( !HXHUDLogDisplay(MsgLog).HasTimedOut() )
		//{
			MsgLogXPad   = 19.0; // Visually pleasing.
			//MsgLogXPad   = 0.0; // Tight but pleasing, but would need infolink to be tighter padded to the left.

			MsgLogX      = HitWidth+InfoLinkWidth+MsgLogXPad+1.0;
			MsgLogY      = 10.0;
			MsgLogWidth  = Width-HitWidth-InfoLinkWidth-ItemsWidth-2.0*MsgLogXPad;

			// Make sure we have a least a modest size (or no infolink window).
			if ( MsgLogWidth>=MessageLogMinWidth || InfoLink==None || !InfoLink.IsVisible(false) )
			{
				MsgLogHeight = MsgLog.QueryPreferredHeight( MsgLogWidth );
				MsgLog.ConfigureChild( MsgLogX, MsgLogY, MsgLogWidth, MsgLogHeight);

				// Show if hidden (now done by tick)
				//if ( !MsgLog.IsVisible(false) )
					//MsgLog.Show();

				bCanFitMessageLog = true;
			}
			else
				bCanFitMessageLog = false;

			// Otherwise force MsgLog into hiding again.
			//else if ( MsgLog.IsVisible(false) )
			//{
				//MsgLog.Hide();
			//}
		//}
	}

	// First-person conversation window
	if (conWindow != None)
	{
		QueryWidth  = Min(width - 100, 800);
		conHeight = conWindow.QueryPreferredHeight(QueryWidth);

		// Stick it above the belt
		conWindow.ConfigureChild(
			(width / 2) - (QueryWidth / 2), (infoBottom - conHeight) - 20, 
			QueryWidth, conHeight);
	}

	// Bark Display.  Position where first-person convo window would
	// go, or above it if the first-person convo is visible
	if (barkDisplay != None)
	{
		QueryWidth = Min(width - 100, 800);
		barkHeight = barkDisplay.QueryPreferredHeight(QueryWidth);

		barkDisplay.ConfigureChild(
			(width / 2) - (QueryWidth / 2), (infoBottom - barkHeight - conHeight) - 20, 
			QueryWidth, barkHeight);
	}

	// Received Items display
	// 
	// Stick below the crosshair, but above any bark/convo windows that might 
	// be visible.

	if (receivedItems != None)
	{
		receivedItems.QueryPreferredSize(recWidth, recHeight);

		recPosY = (height / 2) + 20;

		if ((barkDisplay != None) && (barkDisplay.IsVisible()))
			recPosY -= barkHeight;
		if ((conWindow != None) && (conWindow.IsVisible()))
			recPosY -= conHeight;

		receivedItems.ConfigureChild(
			(width / 2) - (recWidth / 2), recPosY,
			recWidth, recHeight);
	}

	// Display the timer above the object belt if it's visible

	/*if (timer != None)
	{
		timer.QueryPreferredSize(QueryWidth, QueryHeight);

		if ((HXBelt != None) && (HXBelt.IsVisible()))
			timer.ConfigureChild(width-QueryWidth, height-QueryHeight-beltHeight-10, QueryWidth, QueryHeight);
		else
			timer.ConfigureChild(width-QueryWidth, height-QueryHeight, QueryWidth, QueryHeight);
	}*/

	// Mission Start Text
	if (startDisplay != None)
	{
		// Stick this baby right in the middle of the screen.
		startDisplay.QueryPreferredSize(QueryWidth, QueryHeight);
		startDisplay.ConfigureChild(
			(width / 2) - (QueryWidth / 2), (height / 2) - (QueryHeight / 2) - 75,
			QueryWidth, QueryHeight);
	}

	// Display the Info Window sandwiched between all the other windows.  :)

	if ((info != None) && (info.IsVisible(False)))
	{
		// Must redo these formulas
		maxInfoWidth  = Min(width - 170, 800);
		maxInfoHeight = (infoBottom - infoTop) - 20;

		info.QueryPreferredSize(infoWidth, infoHeight);

		if (infoWidth > maxInfoWidth)
		{
			infoHeight = info.QueryPreferredHeight(maxInfoWidth);
			infoWidth  = maxInfoWidth;
		}

		infoX = (width / 2) - (infoWidth / 2);
		infoY = infoTop + (((infoBottom - infoTop) / 2) - (infoHeight / 2)) + 10;

		info.ConfigureChild(infoX, infoY, infoWidth, infoHeight);
	}
}

// ----------------------------------------------------------------------------
// Tick()
//
// Used to display the log Window for 'x' number of seconds before
// hiding it again.
// ----------------------------------------------------------------------------

event Tick( float DeltaTime )
{
	local bool bShowMessageLog;

	if ( MsgLog!=None )
	{
		bShowMessageLog = bCanFitMessageLog && !HXHUDLogDisplay(MsgLog).HasTimedOut();

		if ( bShowMessageLog )
		{
			if ( !MsgLog.IsVisible(false) )
				MsgLog.Show();
		}
		else
		{
			if ( MsgLog.IsVisible(false) )
				MsgLog.Hide();
		}

		//ConfigurationChanged();
	}
}

// ----------------------------------------------------------------------------
// ChildRequestedReconfiguration()
// ----------------------------------------------------------------------------

function bool ChildRequestedReconfiguration(window child)
{
	ConfigurationChanged();

	return true;
}

// ----------------------------------------------------------------------------
// ChildRequestedVisibilityChange()
// ----------------------------------------------------------------------------

function ChildRequestedVisibilityChange(window child, bool bNewVisibility)
{
	child.SetChildVisibility(bNewVisibility);

	ConfigurationChanged();
}

// ----------------------------------------------------------------------------
// CreateInfoLinkWindow()
//
// Creates the InfoLink window used to display messages.  If a 
// InfoLink window already exists, then return None.  If the Log window
// is visible, it hides it.
// ----------------------------------------------------------------------------

function HUDInfoLinkDisplay CreateInfoLinkWindow()
{
	if ( infolink != None )
		return None;

	infolink = HUDInfoLinkDisplay(NewChild(Class'HUDInfoLinkDisplay'));

	// Hide Log window
	//if ( msgLog != None )
		//msgLog.Hide();

	//infolink.AskParentForReconfigure();

	ConfigurationChanged();

	return infolink;
}

// ----------------------------------------------------------------------------
// DestroyInfoLinkWindow()
// ----------------------------------------------------------------------------

function DestroyInfoLinkWindow()
{
	local HXHUDLogDisplay _MsgLog;

	if ( infoLink!=None )
	{
		infoLink.Destroy();

		// Maybe?
		//infoLink = None;

		// In case MsgLog was hidden, because there wasn't enough room while
		// InfoLink was active.
		//_MsgLog = HXHUDLogDisplay(MsgLog);
		//if ( _MsgLog!=None && !_MsgLog.IsVisible(false) && !_MsgLog.HasTimedOut() )
			//_MsgLog.Show();

		ConfigurationChanged();
	}
}

// ----------------------------------------------------------------------------
// CreateConWindowFirst()
// ----------------------------------------------------------------------------

function HUDConWindowFirst CreateConWindowFirst()
{
	local HXRootWindow root;

	// Get a pointer to the root window
	root = HXRootWindow(GetRootWindow());

	conWindow = HUDConWindowFirst(NewChild(Class'HUDConWindowFirst', False));
	conWindow.AskParentForReconfigure();

	return conWindow;
}

// ----------------------------------------------------------------------------
// VisibilityChanged()
//
// Used to display Log messages that were received while the HUD
// wasn't visible
// ----------------------------------------------------------------------------

event VisibilityChanged( bool bNewVisibility )
{
	Super.VisibilityChanged( bNewVisibility );

	if ( bNewVisibility )
	{
		/*if ( HXHUDLogDisplay(MsgLog).HasTimedOut() && MsgLog.IsVisible(false) )
			MsgLog.Hide();
		else if ( !MsgLog.IsVisible(false) )
			MsgLog.Show();*/
	}
}

// ----------------------------------------------------------------------------
// CreateTimerWindow()
//
// Creates the Timer window used to display countdowns.  If a 
// Timer window already exists, then return None.
// ----------------------------------------------------------------------------

/*function TimerDisplay CreateTimerWindow()
{
	if ( timer != None )
		return None;

	timer = TimerDisplay(NewChild(Class'TimerDisplay'));
	timer.AskParentForReconfigure();

	return timer;
}*/

// ----------------------------------------------------------------------------
// ShowInfoWindow()
// ----------------------------------------------------------------------------

function HUDInformationDisplay ShowInfoWindow()
{
	if (info != None)
		info.Show();

	return info;
}

// ----------------------------------------------------------------------------
// UpdateSettings()
//
// Show/Hide these items as dictated by settings in DeusExPlayer (until 
// DeusExHUD can be serialized)
// ----------------------------------------------------------------------------

function UpdateSettings( DeusExPlayer player )
{
	HXBelt.SetVisibility(player.bObjectBeltVisible);
	hit.SetVisibility(player.bHitDisplayVisible);
	ammo.SetVisibility(player.bAmmoDisplayVisible);
	//activeItems.SetVisibility(player.bAugDisplayVisible);
	HXHUDActiveItemsDisplay(activeItems).UpdateVisibility();
	damageDisplay.SetVisibility(player.bHitDisplayVisible);
	compass.SetVisibility(player.bCompassVisible);
	cross.SetCrosshair(player.bCrosshairVisible);
}

// ----------------------------------------------------------------------------
// ClientMessage()
// ----------------------------------------------------------------------------

function bool ClientMessage( coerce string Message, optional Name Type, optional bool bBeep )
{
	local HXHUDLogDisplay _MsgLog;

	// Let message log deal with it.
	_MsgLog = HXHUDLogDisplay(MsgLog);
	if ( _MsgLog!=None )
		if ( _MsgLog.ClientMessage(Message,Type,bBeep) )
			return true;

	return false;
}

// ----------------------------------------------------------------------------
// CustomizeMessageType()
//
// Custome Color and Sounds based on Mesage Types. Mod authors may want to
// modify existing or handle their own custom message types.
// (e.g. DM style enemy message sounds).
//
// Called by MsgLog.
// ----------------------------------------------------------------------------

function CustomizeMessageType( Name Type, out Color MessageColor, out Sound MessageSound, out float MessageSoundVolume )
{
	switch ( Type )
	{
		case 'Say':
			MessageColor       = MakeColor( 255, 255, 255, 255 );
			MessageSound       = MessageSoundSay;
			MessageSoundVolume = 0.5;
			break;

		case 'TeamSay':
			MessageColor       = MakeColor( 0, 255, 0, 255 );
			MessageSound       = MessageSoundTeamSay;
			MessageSoundVolume = 0.5;
			break;

		case 'NoteAdded':
			MessageSound       = MessageSoundNoteAdded;
			MessageSoundVolume = 0.75;
			break;

		case 'GoalAdded':
			MessageSound       = MessageSoundGoalAdded;
			MessageSoundVolume = 0.75;
			break;

		case 'GoalCompleted':
			MessageSound       = MessageSoundGoalCompleted;
			MessageSoundVolume = 0.75;
			break;

		case 'SkillPoints':
			MessageSound       = MessageSoundSkillPoints;
			MessageSoundVolume = 0.75;
			break;

		default:
			break;
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	MessageSoundSay=Menu_Incoming
	MessageSoundTeamSay=Menu_IncomingFriend
	MessageSoundNoteAdded=LogNoteAdded
	MessageSoundGoalAdded=LogGoalAdded
	MessageSoundGoalCompleted=LogGoalCompleted
	MessageSoundSkillPoints=LogSkillPoints
	MessageLogMinWidth=250.0
	bTickEnabled=True
}
