//=============================================================================
// HXDeusExPickup.
//=============================================================================
class HXDeusExPickup extends HXPickup
	abstract;

/*
var const localized string CountLabel;
var const localized string MsgTooMany;
*/

/*
var class<Fragment> FragType; // fragments created when pickup is destroyed
var const in MaxCopies;       // 0 means unlimited copies
*/

// ----------------------------------------------------------------------------
// Networking Replication.
// ----------------------------------------------------------------------------

replication
{
/*
	// Client to server function.
	reliable if ( Role<ROLE_Authority && bNetOwner )
		UseOnce; // Uhm? --han
*/
}

// ----------------------------------------------------------------------------
// HandlePickupQuery()
//
// If the bCanHaveMultipleCopies variable is set to True, then we want
// to stack items of this type in the player's inventory.
// ----------------------------------------------------------------------------

function bool HandlePickupQuery( inventory Item )
{
	local DeusExPlayer player;
	local Inventory anItem;
	local Bool bAlreadyHas;
	local Bool bResult;

	if ( Item.Class == Class )
	{
		player = DeusExPlayer(Owner);
		bResult = False;

		// Check to see if the player already has one of these in 
		// his inventory
		anItem = player.FindInventoryType(Item.Class);

		if ((anItem != None) && (bCanHaveMultipleCopies))
		{
			// don't actually put it in the hand, just add it to the count
			NumCopies += HXPickup(item).NumCopies;

			if ((MaxCopies > 0) && (NumCopies > MaxCopies))
			{
				NumCopies -= HXPickup(item).NumCopies;
				player.ClientMessage(msgTooMany);

				// abort the pickup
				return True;
			}
			bResult = True;
		}

		if (bResult)
		{
			// HX_INV: maybe change message for stacked lockpicks
			player.ClientMessage(Item.PickupMessage @ Item.itemArticle @ Item.itemName $ ".", 'Pickup');

			// Destroy me!

			// DEUS_EX AMSD In multiplayer, we don't want to destroy the item, we want it to set to respawn
			// HX_NOTE: No we won't, but SetRespawn() will destroy it
			if (Level.NetMode != NM_Standalone)
				Item.SetRespawn();
			else			
				Item.Destroy();
		}
		else
		{
			bResult = Super(Pickup).HandlePickupQuery(Item);
		}

		// Update object belt text
		//if (bResult)			
			//UpdateBeltText();	

		return bResult;
	}

	if ( Inventory == None )
		return false;

	return Inventory.HandlePickupQuery(Item);
}

// ----------------------------------------------------------------------------
// UseOnce()
//
// Subtract a use, then destroy if out of uses.
// ----------------------------------------------------------------------------

function UseOnce()
{
	local HXPlayerPawn PlayerOwner;

	PlayerOwner = HXPlayerPawn(Owner);
	NumCopies--;

	GotoState('DeActivated');

	if ( NumCopies<=0 )
	{
		// Shouldn't destory put us out of the hands?
		//if ( PlayerOwner.InHand==Self )
			//Player.PutInHand(None);
		Destroy();
	}
}

// ----------------------------------------------------------------------------
// UpdateBeltText()
// ----------------------------------------------------------------------------

// Is this even called?
function UpdateBeltText()
{
	Warn( "Called" );
/*
	local DeusExRootWindow root;

	if (DeusExPlayer(Owner) != None)
	{
		root = DeusExRootWindow(DeusExPlayer(Owner).rootWindow);

		// Update object belt text
		if ((bInObjectBelt) && (root != None) && (root.hud != None) && (root.hud.belt != None))
			root.hud.belt.UpdateObjectText(beltPos);
	}
*/
}

// ----------------------------------------------------------------------------
// BaseChange()
// ----------------------------------------------------------------------------

singular function BaseChange()
{
	Super.BaseChange();

	// Make sure we fall if we don't have a base.
	if ( Base==None && Owner==None )
		SetPhysics( PHYS_Falling );
}

// ----------------------------------------------------------------------------
// PlayLandingSound()
// ----------------------------------------------------------------------------

function PlayLandingSound()
{
	if (LandSound != None)
	{
		if (Velocity.Z <= -200)
		{
			PlaySound(LandSound, SLOT_None, TransientSoundVolume,, 768);
			AISendEvent('LoudNoise', EAITYPE_Audio, TransientSoundVolume, 768);
		}
	}
}

// ----------------------------------------------------------------------------
// InfoText()
//
// Description intended for the info window.
// ----------------------------------------------------------------------------

simulated function string InfoText()
{
	// Only show count if we have multiple copies.
	if ( bCanHaveMultipleCopies && NumCopies>1 )
		return Description $ "|n|n" $ CountLabel @ String(NumCopies);
	else
		return Description;
}

// ----------------------------------------------------------------------------
// UpdateInfo()
// ----------------------------------------------------------------------------

simulated function bool UpdateInfo( Object InfoObject )
{
	local HXPersonaInfoWindow InfoWindow;

	InfoWindow = HXPersonaInfoWindow(InfoObject);
	if ( InfoWindow==None )
		return false;

	// !! SetTitle will cause a clear.
	InfoWindow.SetTitle( InfoTitle() );
	InfoWindow.SetText( InfoText() );

	return true;
}

//=============================================================================
// state Pickup.
//
// This inventory item is sitting on the ground.
//=============================================================================

auto state Pickup
{
	// if we hit the ground fast enough, break it, smash it!!!
	function Landed( vector HitNormal )
	{
		Super.Landed( HitNormal );

		PlayLandingSound();
	}
}

//=============================================================================
// state DeActivated.
//=============================================================================

state Deactivated
{
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
}
